/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.pay.local.entity.AuditProduct;
import com.biz.crm.tpm.business.pay.local.repository.AuditProductRepository;
import com.biz.crm.tpm.business.pay.local.service.AuditProductService;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditProductDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="auditProductService")
public class AuditProductServiceImpl
implements AuditProductService {
    @Autowired
    private AuditProductRepository auditProductRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;

    @Override
    public Page<AuditProductVo> findByConditions(Pageable pageable, AuditProductDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditProductDto();
        }
        return this.auditProductRepository.findByConditions(pageable, dto);
    }

    @Override
    public AuditProductVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditProduct auditProduct = (AuditProduct)((Object)this.auditProductRepository.getById((Serializable)((Object)id)));
        if (auditProduct == null) {
            return null;
        }
        AuditProductVo auditProductVo = (AuditProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditProduct, AuditProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditProductVo;
    }

    @Override
    public List<AuditProductVo> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return Collections.emptyList();
        }
        List<AuditProduct> auditProducts = this.auditProductRepository.findByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(auditProducts)) {
            return Collections.emptyList();
        }
        Collection auditProductVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditProducts, AuditProduct.class, AuditProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)auditProductVos);
    }

    @Override
    public List<AuditProductVo> findByAuditDetailCode(String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return Collections.emptyList();
        }
        List<AuditProduct> auditProducts = this.auditProductRepository.findByAuditDetailCode(auditDetailCode);
        if (CollectionUtils.isEmpty(auditProducts)) {
            return null;
        }
        Collection auditProductVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditProducts, AuditProduct.class, AuditProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)auditProductVos);
    }

    @Override
    @Transactional
    public AuditProductVo create(AuditProductDto auditProductDto) {
        this.createValidate(auditProductDto);
        AuditProduct auditProduct = (AuditProduct)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditProductDto, AuditProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        auditProduct.setTenantCode(TenantUtils.getTenantCode());
        this.auditProductRepository.saveOrUpdate((Object)auditProduct);
        AuditProductVo auditProductVo = (AuditProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditProduct, AuditProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditProductVo.setId(auditProduct.getId());
        return auditProductVo;
    }

    @Override
    public List<AuditProductVo> createBatch(List<AuditProductDto> auditProductDtos) {
        ArrayList auditActivitiesVos = Lists.newArrayList();
        for (AuditProductDto auditProductDto : auditProductDtos) {
            AuditProductVo auditProductVo = this.create(auditProductDto);
            auditActivitiesVos.add(auditProductVo);
        }
        return auditActivitiesVos;
    }

    @Override
    @Transactional
    public AuditProductVo update(AuditProductDto auditProductDto) {
        this.updateValidate(auditProductDto);
        AuditProduct auditProduct = (AuditProduct)((Object)this.auditProductRepository.getById((Serializable)((Object)auditProductDto.getId())));
        Validate.notNull((Object)((Object)auditProduct), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        auditProduct.setProductCode(auditProductDto.getProductCode());
        auditProduct.setProductName(auditProductDto.getProductName());
        this.auditProductRepository.saveOrUpdate((Object)auditProduct);
        AuditProductVo auditProductVo = (AuditProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditProduct, AuditProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditProductVo;
    }

    @Override
    public List<AuditProductVo> updateBatch(List<AuditProductDto> auditProductDtos) {
        Set currentIds;
        Set dbIds;
        Sets.SetView delData;
        if (CollectionUtils.isEmpty(auditProductDtos)) {
            return Lists.newArrayList();
        }
        String code = auditProductDtos.stream().map(AuditProductDto::getAuditCode).findFirst().get();
        ArrayList dbAuditProductVos = this.findByAuditCode(code);
        if (CollectionUtils.isEmpty(dbAuditProductVos)) {
            dbAuditProductVos = Lists.newArrayList();
        }
        if (!CollectionUtils.isEmpty((Collection)(delData = Sets.difference(dbIds = dbAuditProductVos.stream().map(AuditProductVo::getId).collect(Collectors.toSet()), currentIds = auditProductDtos.stream().map(AuditProductDto::getId).collect(Collectors.toSet()))))) {
            this.delete(Lists.newArrayList((Iterable)delData));
        }
        List<AuditProductDto> addDtos = auditProductDtos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditProductDto> updateDtos = auditProductDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditProductVo> auditProductVos = this.createBatch(addDtos);
        if (!CollectionUtils.isEmpty(updateDtos)) {
            updateDtos.forEach(item -> auditProductVos.add(this.update((AuditProductDto)item)));
        }
        return auditProductVos;
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<AuditProduct> auditProducts = this.auditProductRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(auditProducts)) {
            return;
        }
        Collection auditProductVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditProducts, AuditProduct.class, AuditProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.auditProductRepository.removeByIds(ids);
    }

    @Override
    @Transactional
    public void deleteByAuditCode(String auditCode) {
        this.auditProductRepository.removeByAuditCode(auditCode);
    }

    @Override
    @Transactional
    public void deleteByAuditDetailCode(String auditDetailCode) {
        this.auditProductRepository.removeByAuditDetailCode(auditDetailCode);
    }

    @Override
    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode("generate:prefix", prefix, prefix, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
        return prefix;
    }

    private void createValidate(AuditProductDto auditProductDto) {
        Validate.notNull((Object)auditProductDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        auditProductDto.setId(null);
        Validate.notBlank((CharSequence)auditProductDto.getAuditCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6838\u9500\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditProductDto.getAuditDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6838\u9500\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditProductDto.getProductCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditProductDto.getProductName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(AuditProductDto auditProductDto) {
        Validate.notNull((Object)auditProductDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditProductDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditProductDto.getProductCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditProductDto.getProductName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

