/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.budget.sdk.dto.CostTypeDetailsDto;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeDetailVoService;
import com.biz.crm.tpm.business.pay.local.entity.Prepay;
import com.biz.crm.tpm.business.pay.local.repository.PrepayRepository;
import com.biz.crm.tpm.business.pay.local.service.AuditDetailService;
import com.biz.crm.tpm.business.pay.local.service.PrepayBillService;
import com.biz.crm.tpm.business.pay.local.service.PrepayDetailService;
import com.biz.crm.tpm.business.pay.sdk.dto.PrepayDetailDto;
import com.biz.crm.tpm.business.pay.sdk.dto.PrepayDto;
import com.biz.crm.tpm.business.pay.sdk.dto.log.PrepayLogEventDto;
import com.biz.crm.tpm.business.pay.sdk.event.PrepayEventListener;
import com.biz.crm.tpm.business.pay.sdk.event.log.PrepayLogEventListener;
import com.biz.crm.tpm.business.pay.sdk.service.PrepayService;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayActivityItemVo;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayBillVo;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayDetailVo;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="prepayService")
public class PrepayServiceImpl
implements PrepayService {
    @Autowired
    private PrepayRepository prepayRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private List<PrepayEventListener> prepayEventListeners;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private PrepayBillService prepayBillService;
    @Autowired
    private PrepayDetailService prepayDetailService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private ActivitiesDetailService activitiesDetailService;
    @Autowired
    private AuditDetailService auditDetailService;
    @Autowired
    private ActivitiesService activitiesService;
    @Autowired
    private CostTypeDetailVoService costTypeDetailVoService;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;

    public Page<PrepayVo> findByConditions(Pageable pageable, PrepayDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new PrepayDto();
        }
        return this.prepayRepository.findByConditions(pageable, dto);
    }

    public Page<ActivitiesVo> findActivitiesByConditions(Pageable pageable, ActivitiesDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ActivitiesDto();
        }
        return this.activitiesService.findByConditions(pageable, dto);
    }

    public Page<PrepayActivityItemVo> findActivitiesDetailByConditions(Pageable pageable, ActivitiesDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ActivitiesDetailDto();
        }
        HashSet excludeCostTypeDetailCodes = Sets.newHashSet();
        HashSet excludeActivitiesDetailCodes = Sets.newHashSet();
        CostTypeDetailsDto notAuditDto = new CostTypeDetailsDto();
        notAuditDto.setIsAudit(BooleanEnum.FALSE.getCapital());
        Set notAuditCostTypeDetailCodes = this.costTypeDetailVoService.findCodeByCondition(notAuditDto);
        CostTypeDetailsDto autoAuditDto = new CostTypeDetailsDto();
        autoAuditDto.setIsAudit(BooleanEnum.TRUE.getCapital());
        autoAuditDto.setIsAutoAudit(BooleanEnum.TRUE.getCapital());
        Set autoAuditCostTypeDetailCodes = this.costTypeDetailVoService.findCodeByCondition(autoAuditDto);
        CostTypeDetailsDto notMultiAuditDto = new CostTypeDetailsDto();
        notMultiAuditDto.setIsAudit(BooleanEnum.TRUE.getCapital());
        notMultiAuditDto.setIsMultipleAudit(BooleanEnum.FALSE.getCapital());
        Set notMultiAuditCostTypeDetailCodes = this.costTypeDetailVoService.findCodeByCondition(notMultiAuditDto);
        Set<String> auditingActivitiesDetailCodes = this.auditDetailService.findActivitiesDetailByAuditing(notMultiAuditCostTypeDetailCodes);
        Set<String> auditedActivitiesDetailCodes = this.auditDetailService.findActivitiesDetailByAudited();
        excludeCostTypeDetailCodes.addAll(notAuditCostTypeDetailCodes);
        excludeCostTypeDetailCodes.addAll(autoAuditCostTypeDetailCodes);
        excludeActivitiesDetailCodes.addAll(auditingActivitiesDetailCodes);
        excludeActivitiesDetailCodes.addAll(auditedActivitiesDetailCodes);
        dto.setExcludeCostTypeDetailCodes((Set)excludeCostTypeDetailCodes);
        dto.setExcludeItemCodes((Set)excludeActivitiesDetailCodes);
        Page basicPage = this.activitiesDetailService.findByConditions(pageable, dto);
        ArrayList result = Lists.newArrayList();
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (!CollectionUtils.isEmpty((Collection)basicPage.getRecords())) {
            for (ActivitiesDetailVo basicActivityItemVo : basicPage.getRecords()) {
                PrepayActivityItemVo prepayActivityItemVo = (PrepayActivityItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)basicActivityItemVo, PrepayActivityItemVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"costTypeDetailVo"});
                PrepayBillVo prepayBillVo = this.prepayBillService.findByActivitiesDetailCode(basicActivityItemVo.getActivitiesDetailCode());
                if (prepayBillVo == null) {
                    prepayActivityItemVo.setPrepaidAmount(BigDecimal.ZERO);
                } else {
                    prepayActivityItemVo.setPrepaidAmount(prepayBillVo.getPrepaidAmount());
                }
                result.add(prepayActivityItemVo);
            }
        }
        page.setRecords((List)result);
        page.setTotal(basicPage.getTotal());
        return page;
    }

    public PrepayVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Prepay prepay = (Prepay)((Object)this.prepayRepository.getById((Serializable)((Object)id)));
        if (prepay == null) {
            return null;
        }
        PrepayVo prepayVo = (PrepayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepay, PrepayVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(prepayVo);
        return prepayVo;
    }

    public List<PrepayVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<Prepay> prepayActivities = this.prepayRepository.findByIds(ids);
        Collection prepayVos = this.nebulaToolkitService.copyCollectionByWhiteList(prepayActivities, Prepay.class, PrepayVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        prepayVos.forEach(this::fillDetail);
        return Lists.newArrayList((Iterable)prepayVos);
    }

    public PrepayVo findByCode(String code) {
        return this.findByPrepayCode(code);
    }

    public PrepayVo findByPrepayCode(String prepayCode) {
        if (StringUtils.isBlank((CharSequence)prepayCode)) {
            return null;
        }
        Prepay prepay = this.prepayRepository.findByPrepayCode(prepayCode);
        if (prepay == null) {
            return null;
        }
        PrepayVo prepayVo = (PrepayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepay, PrepayVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(prepayVo);
        return prepayVo;
    }

    public List<PrepayVo> findByPrepayCodes(List<String> prepayCodes) {
        if (CollectionUtils.isEmpty(prepayCodes)) {
            return Collections.emptyList();
        }
        List<Prepay> prepayActivitiesses = this.prepayRepository.findByPrepayCodes(prepayCodes);
        if (CollectionUtils.isEmpty(prepayActivitiesses)) {
            return Collections.emptyList();
        }
        Collection prepayVos = this.nebulaToolkitService.copyCollectionByWhiteList(prepayActivitiesses, Prepay.class, PrepayVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        prepayVos.forEach(this::fillDetail);
        return Lists.newArrayList((Iterable)prepayVos);
    }

    private void fillDetail(PrepayVo prepayVo) {
        List<PrepayDetailVo> prepayDetailVos = this.prepayDetailService.findByPrepayCode(prepayVo.getPrepayCode());
        prepayVo.setPrepayDetails(prepayDetailVos);
    }

    @Transactional
    public PrepayVo create(PrepayDto prepayDto) {
        prepayDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        prepayDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        String code = (String)this.generateCodeService.generateCode("YFMX", 1).get(0);
        prepayDto.setPrepayCode(code);
        this.createValidate(prepayDto);
        Prepay prepay = (Prepay)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepayDto, Prepay.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        prepay.setTenantCode(TenantUtils.getTenantCode());
        this.prepayRepository.saveOrUpdate((Object)prepay);
        PrepayVo prepayVo = (PrepayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepay, PrepayVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        prepayVo.setId(prepay.getId());
        prepayDto.getPrepayDetails().forEach(item -> {
            item.setTenantCode(TenantUtils.getTenantCode());
            item.setPrepayCode(prepayVo.getPrepayCode());
        });
        this.prepayDetailService.createBatch(prepayDto.getPrepayDetails());
        if (!CollectionUtils.isEmpty(this.prepayEventListeners)) {
            for (PrepayEventListener prepayEventListener : this.prepayEventListeners) {
                prepayEventListener.onCreated(prepayVo);
            }
        }
        if (prepayDto.getProcessBusiness() != null) {
            prepayDto.setId(prepay.getId());
            this.commitProcess(prepayDto);
        }
        PrepayLogEventDto logEventDto = new PrepayLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(prepayVo);
        SerializableBiConsumer & Serializable onCreate = PrepayLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PrepayLogEventListener.class, (SerializableBiConsumer)onCreate);
        return prepayVo;
    }

    @Transactional
    public List<PrepayVo> createBatch(List<PrepayDto> prepayDtos) {
        if (CollectionUtils.isEmpty(prepayDtos)) {
            return Lists.newArrayList();
        }
        ArrayList prepayVos = Lists.newArrayList();
        for (PrepayDto prepayDto : prepayDtos) {
            PrepayVo prepayVo = this.create(prepayDto);
            prepayVos.add(prepayVo);
        }
        return prepayVos;
    }

    @Transactional
    public PrepayVo update(PrepayDto prepayDto) {
        this.updateValidate(prepayDto);
        Prepay prepay = (Prepay)((Object)this.prepayRepository.getById((Serializable)((Object)prepayDto.getId())));
        Validate.notNull((Object)((Object)prepay), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        PrepayVo oldPrepayVo = (PrepayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepay, PrepayVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<ProcessBusinessMappingVo> processBusinessMappingVoList = this.findProcessBusinessMappingVo(Lists.newArrayList((Object[])new String[]{prepay.getPrepayCode()}));
        if (!CollectionUtils.isEmpty(processBusinessMappingVoList)) {
            ProcessBusinessMappingVo processBusinessMappingVo = processBusinessMappingVoList.get(0);
            String processStatus = processBusinessMappingVo.getProcessStatus();
            Validate.isTrue((ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus) || ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ? 1 : 0) != 0, (String)"\u53ea\u6709\u72b6\u6001\u4e3a\u3010\u5f85\u63d0\u4ea4\u3001\u6d41\u7a0b\u8ffd\u56de\u3001\u5ba1\u6279\u9a73\u56de\u3011\u6570\u636e\u80fd\u4fee\u6539\uff0c\u3010%s\u3011\u7533\u8bf7\u72b6\u6001\u4e3a\u3010%s\u3011", (Object[])new Object[]{prepay.getActivitiesName(), ProcessStatusEnum.getStatusNameByKey((String)processStatus)});
        }
        prepay.setRemark(prepayDto.getRemark());
        prepay.setPrepayCode(prepayDto.getPrepayCode());
        prepay.setActivitiesCode(prepayDto.getActivitiesCode());
        prepay.setActivitiesName(prepayDto.getActivitiesName());
        prepay.setTotalPrepayAmount(prepayDto.getTotalPrepayAmount());
        this.prepayRepository.saveOrUpdate((Object)prepay);
        PrepayVo prepayVo = (PrepayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepay, PrepayVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.prepayDetailService.updateBatch(prepayDto.getPrepayDetails());
        if (!CollectionUtils.isEmpty(this.prepayEventListeners)) {
            for (PrepayEventListener prepayEventListener : this.prepayEventListeners) {
                prepayEventListener.onUpdate(oldPrepayVo, prepayVo);
            }
        }
        if (prepayDto.getProcessBusiness() != null) {
            prepayDto.setId(prepay.getId());
            this.commitProcess(prepayDto);
        }
        PrepayLogEventDto logEventDto = new PrepayLogEventDto();
        logEventDto.setOriginal(oldPrepayVo);
        logEventDto.setNewest(prepayVo);
        SerializableBiConsumer & Serializable onUpdate = PrepayLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PrepayLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return prepayVo;
    }

    public List<PrepayVo> updateBatch(List<PrepayDto> prepayDtos) {
        Set currentIds;
        if (CollectionUtils.isEmpty(prepayDtos)) {
            return Collections.emptyList();
        }
        List<String> codes = prepayDtos.stream().map(PrepayDto::getPrepayCode).collect(Collectors.toList());
        List<PrepayVo> dbPrepayVos = this.findByPrepayCodes(codes);
        Set dbIds = dbPrepayVos.stream().map(PrepayVo::getId).collect(Collectors.toSet());
        Sets.SetView delData = Sets.difference(dbIds, currentIds = prepayDtos.stream().map(PrepayDto::getId).collect(Collectors.toSet()));
        if (!CollectionUtils.isEmpty((Collection)delData)) {
            this.delete((Collection<String>)delData);
        }
        List<PrepayDto> addDtos = prepayDtos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<PrepayDto> updateDtos = prepayDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<PrepayVo> prepayVos = this.createBatch(addDtos);
        if (!CollectionUtils.isEmpty(updateDtos)) {
            updateDtos.forEach(item -> prepayVos.add(this.update((PrepayDto)item)));
        }
        return prepayVos;
    }

    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Prepay> prepayActivitiesses = this.prepayRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(prepayActivitiesses)) {
            return;
        }
        Collection prepayVos = this.nebulaToolkitService.copyCollectionByWhiteList(prepayActivitiesses, Prepay.class, PrepayVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<String> prepayCodes = prepayActivitiesses.stream().map(Prepay::getPrepayCode).collect(Collectors.toList());
        List<ProcessBusinessMappingVo> processBusinessMappingVoList = this.findProcessBusinessMappingVo(prepayCodes);
        if (CollectionUtils.isEmpty(processBusinessMappingVoList)) {
            processBusinessMappingVoList.forEach(item -> {
                throw new RuntimeException("\u53ea\u6709\u3010\u5f85\u63d0\u4ea4\u3011\u9884\u4ed8\u6570\u636e\u80fd\u5220\u9664\uff0c\u9884\u4ed8\u7f16\u53f7\u3010" + item.getBusinessNo() + "\u3011\u9884\u4ed8\u7533\u8bf7\u72b6\u6001\u4e3a\u3010" + ProcessStatusEnum.getStatusNameByKey((String)item.getProcessStatus()) + "\u3011");
            });
        }
        this.prepayRepository.removeByIds(ids);
        if (!CollectionUtils.isEmpty(this.prepayEventListeners)) {
            for (PrepayEventListener prepayEventListener : this.prepayEventListeners) {
                for (PrepayVo prepayVo : prepayVos) {
                    prepayEventListener.onDeleted(prepayVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDelete = PrepayLogEventListener::onDelete;
        for (PrepayVo prepayVo : prepayVos) {
            PrepayLogEventDto logEventDto = new PrepayLogEventDto();
            logEventDto.setOriginal(prepayVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PrepayLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode("generate:prefix", prefix, prefix, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validationPrefix(PrepayDto prepayDto) {
        block5: {
            String prefix = prepayDto.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode("generate:prefix", prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode("generate:prefix", prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
    }

    private void createValidate(PrepayDto prepayDto) {
        Validate.notNull((Object)prepayDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        prepayDto.setId(null);
        this.validationPrefix(prepayDto);
        Validate.notBlank((CharSequence)prepayDto.getDelFlag(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6570\u636e\u72b6\u6001\uff08\u5220\u9664\u72b6\u6001\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDto.getPrepayCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u4ed8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDto.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDto.getActivitiesName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)prepayDto.getTotalPrepayAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u4ed8\u91d1\u989d\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)prepayDto.getPrepayDetails(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u4ed8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BigDecimal totalPrepayAmount = prepayDto.getPrepayDetails().stream().map(PrepayDetailDto::getPrepayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((totalPrepayAmount.compareTo(prepayDto.getTotalPrepayAmount()) == 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u9884\u4ed8\u603b\u91d1\u989d\u4e0e\u660e\u7ec6\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(PrepayDto prepayDto) {
        Validate.notNull((Object)prepayDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validationPrefix(prepayDto);
        Validate.notBlank((CharSequence)prepayDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDto.getPrepayCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u4ed8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDto.getActivitiesCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDto.getActivitiesName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)prepayDto.getTotalPrepayAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u4ed8\u91d1\u989d\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)prepayDto.getPrepayDetails(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u4ed8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BigDecimal totalPrepayAmount = prepayDto.getPrepayDetails().stream().map(PrepayDetailDto::getPrepayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((totalPrepayAmount.compareTo(prepayDto.getTotalPrepayAmount()) == 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u9884\u4ed8\u603b\u91d1\u989d\u4e0e\u660e\u7ec6\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private void commitProcess(PrepayDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNo(dto.getPrepayCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("PAY_PREPAY");
        this.processBusinessService.processStart(processBusiness);
    }

    private List<ProcessBusinessMappingVo> findProcessBusinessMappingVo(List<String> businessNos) {
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setBusinessNos(businessNos);
        processBusinessMappingDto.setBusinessCode("PAY_PREPAY");
        return this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
    }
}

