/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.observer;

import com.biz.crm.tpm.business.pay.local.service.PrepayBillService;
import com.biz.crm.tpm.business.pay.sdk.event.PrepayEventListener;
import com.biz.crm.tpm.business.pay.sdk.service.PrepayService;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PrepayActivitiesProcessCallBackListener
implements ProcessCompleteListener {
    @Autowired(required=false)
    private PrepayService prepayService;
    @Autowired
    private PrepayBillService prepayBillService;
    @Autowired(required=false)
    private List<PrepayEventListener> prepayEventListeners;

    public String getBusinessCode() {
        return "PAY_PREPAY";
    }

    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {
        if (!dto.getBusinessCode().equals("PAY_PREPAY")) {
            return;
        }
        String code = dto.getBusinessNo();
        String processStatus = dto.getProcessStatus();
        PrepayVo prepayVo = this.prepayService.findByCode(code);
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.PASS.getDictCode())) {
            this.prepayBillService.prepayAmountByPrepayCode(prepayVo.getPrepayCode());
        }
        if (!CollectionUtils.isEmpty(this.prepayEventListeners)) {
            this.prepayEventListeners.forEach(event -> event.onUpdateProcessStatus(prepayVo, processStatus));
        }
    }
}

