/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.pay.local.service.AuditInvoiceService;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditInvoiceDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditInvoiceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d39\u7528\u6838\u9500\u53d1\u7968\u529f\u80fd\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/auditInvoice"})
public class AuditInvoiceController {
    private static final Logger log = LoggerFactory.getLogger(AuditInvoiceController.class);
    @Autowired
    private AuditInvoiceService auditInvoiceService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<AuditInvoiceVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="auditInvoice", value="\u6838\u9500\u91c7\u96c6\u4fe1\u606f") AuditInvoiceDto dto) {
        try {
            Page<AuditInvoiceVo> page = this.auditInvoiceService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<AuditInvoiceVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid", required=true) String id) {
        try {
            AuditInvoiceVo auditInvoiceVo = this.auditInvoiceService.findById(id);
            return Result.ok((Object)auditInvoiceVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByCode"})
    public Result<List<AuditInvoiceVo>> findByCode(@PathVariable @ApiParam(name="code", value="\u7f16\u53f7", required=true) String code) {
        try {
            List<AuditInvoiceVo> auditInvoiceVos = this.auditInvoiceService.findByAuditCode(code);
            return Result.ok(auditInvoiceVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<AuditInvoiceVo> create(@ApiParam(name="auditInvoiceDto", value="\u8d39\u7528\u6838\u9500\u53d1\u7968") @RequestBody AuditInvoiceDto auditInvoiceDto) {
        try {
            AuditInvoiceVo result = this.auditInvoiceService.create(auditInvoiceDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<AuditInvoiceVo> update(@ApiParam(name="auditInvoiceDto", value="\u8d39\u7528\u6838\u9500\u53d1\u7968") @RequestBody AuditInvoiceDto auditInvoiceDto) {
        try {
            AuditInvoiceVo result = this.auditInvoiceService.update(auditInvoiceDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.auditInvoiceService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

