/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.pay.sdk.dto.InvoiceDto;
import com.biz.crm.tpm.business.pay.sdk.service.InvoiceService;
import com.biz.crm.tpm.business.pay.sdk.vo.InvoiceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/pay/invoice"})
@Api(tags={"\u53d1\u7968\u6c60"})
public class InvoiceController {
    private static final Logger log = LoggerFactory.getLogger(InvoiceController.class);
    @Autowired
    private InvoiceService invoiceService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<InvoiceVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u53d1\u7968\u6c60") InvoiceDto dto) {
        try {
            Page page = this.invoiceService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u53d1\u7968\u53f7\u7801\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByInvoiceNo"})
    public Result<InvoiceVo> findByInvoiceNo(@RequestParam(value="invoiceNo") @ApiParam(name="invoiceNo", value="\u53d1\u7968\u53f7\u7801") String invoiceNo) {
        try {
            InvoiceVo Invoice2 = this.invoiceService.findByInvoiceNo(invoiceNo);
            return Result.ok((Object)Invoice2);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<InvoiceVo> create(@ApiParam(name="Invoice", value="\u53d1\u7968\u6c60") @RequestBody InvoiceDto Invoice2) {
        try {
            InvoiceVo result = this.invoiceService.create(Invoice2);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<InvoiceVo> update(@ApiParam(name="Invoice", value="\u53d1\u7968\u6c60") @RequestBody InvoiceDto Invoice2) {
        try {
            InvoiceVo result = this.invoiceService.update(Invoice2);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u64cd\u4f5c")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.invoiceService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7981\u7528")
    @PatchMapping(value={"updateEnableStatus"})
    public Result<?> updateEnableStatus(@RequestBody @ApiParam(name="ids", value="\u4e3b\u952eid") Set<String> ids, @RequestParam(value="enableStatus") @ApiParam(name="enableStatus", value="\u542f\u7981\u7528\u72b6\u6001") String enableStatus) {
        try {
            this.invoiceService.updateEnableStatus(ids, enableStatus);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

