/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.notifier;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesDetailEventListener;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.pay.local.service.AuditBillService;
import com.biz.crm.tpm.business.pay.sdk.service.AuditService;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditBillVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditForActivitiesDetailEventListener
implements ActivitiesDetailEventListener {
    private static final Logger log = LoggerFactory.getLogger(AuditForActivitiesDetailEventListener.class);
    @Autowired
    private AuditBillService auditBillService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private ActivitiesDetailService activitiesDetailService;
    @Autowired
    private ActivitiesService activitiesService;
    @Autowired
    private AuditService auditService;

    public void onCreated(ActivitiesDetailVo activitiesDetailVo) {
    }

    public void onUpdate(ActivitiesDetailVo oldActivitiesDetailVo, ActivitiesDetailVo activitiesDetailVo) {
    }

    public void onDeleted(ActivitiesDetailVo activitiesDetailVo) {
    }

    @Transactional
    public void onClosed(Collection<ActivitiesDetailVo> activitiesDetailVos) {
        if (CollectionUtils.isEmpty(activitiesDetailVos)) {
            return;
        }
        activitiesDetailVos.forEach(item -> {
            ActivitiesDetailVo activitiesDetailVo = this.activitiesDetailService.findByActivitiesDetailCode(item.getActivitiesDetailCode());
            Validate.notNull((Object)activitiesDetailVo, (String)"\u8be5\u6d3b\u52a8\u5c1a\u672a\u5ba1\u6279\u901a\u8fc7\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u3010%s\u3011,\u8bf7\u68c0\u67e5!", (Object[])new Object[]{item.getActivitiesDetailCode()});
            ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(item.getActivitiesCode());
            Validate.notNull((Object)activitiesVo, (String)"\u8be5\u6d3b\u52a8\u660e\u7ec6\u3010%s\u3011\u4e0d\u542b\u6709\u4e3b\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{item.getActivitiesDetailCode()});
            List auditVos = this.auditService.findByActivitiesDetailCode(activitiesDetailVo.getActivitiesDetailCode());
            if (CollectionUtils.isEmpty((Collection)auditVos)) {
                this.costBudgetVoService.back(activitiesDetailVo.getActivitiesCode(), activitiesDetailVo.getActivitiesDetailCode(), activitiesDetailVo.getCostBudgetCode(), activitiesDetailVo.getApplyAmount(), null, this.analysisSource(activitiesVo.getActivityMark()));
                return;
            }
            AuditBillVo auditBillVo = this.auditBillService.findByActivitiesDetailCode(item.getActivitiesDetailCode());
            for (AuditVo auditVo : auditVos) {
                Validate.isTrue((auditVo == null || !ActApproveStatusEnum.APPROVING.getCode().equals(auditVo.getProcessStatus()) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u660e\u7ec6\u3010%s\u3011\u662f\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u6d3b\u52a8\u5173\u95ed", (Object[])new Object[]{item.getActivitiesDetailCode()});
                if (auditVo == null || auditBillVo == null || !ActApproveStatusEnum.APPROVED.getCode().equals(auditVo.getProcessStatus())) continue;
                Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(auditBillVo.getIsFullAudit()) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u3010%s\u3011\u5df2\u5b8c\u5168\u6838\u9500\uff0c\u65e0\u6cd5\u5173\u95ed", (Object[])new Object[]{item.getActivitiesDetailCode()});
            }
            BigDecimal backAmount = BigDecimal.ZERO;
            backAmount = auditBillVo == null ? activitiesDetailVo.getApplyAmount() : auditBillVo.getApplyAmount().subtract(auditBillVo.getAuditedAmount());
            if (backAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.costBudgetVoService.back(activitiesDetailVo.getActivitiesCode(), activitiesDetailVo.getActivitiesDetailCode(), activitiesDetailVo.getCostBudgetCode(), backAmount, null, this.analysisSource(activitiesVo.getActivityMark()));
            }
        });
        this.auditService.updateActivitiesAuditStatusByActivitiesDetails(activitiesDetailVos);
    }

    private String analysisSource(String value) {
        switch (value) {
            case "OrdinaryActivity": {
                return CostBudgetItemSourceType.ORDINARY_ACTIVITY.getDescr();
            }
            case "ProjectActivity": {
                return CostBudgetItemSourceType.PROJECT_ACTIVITY.getDescr();
            }
            case "SchemeActivity": {
                return CostBudgetItemSourceType.SCHEMA_ACTIVITY.getDescr();
            }
        }
        throw new IllegalArgumentException("\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u6765\u6e90\uff0c\u8bf7\u68c0\u67e5");
    }
}

