/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.pay.local.entity.AccountProduct;
import com.biz.crm.tpm.business.pay.local.mapper.AccountProductMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AccountProductRepository
extends ServiceImpl<AccountProductMapper, AccountProduct> {
    @Autowired
    private AccountProductMapper accountProductMapper;

    public Page<AccountProduct> findByConditions(Pageable pageable, AccountProduct tpmAccountProduct) {
        tpmAccountProduct.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AccountProduct> pageList = this.accountProductMapper.findByConditions((Page<AccountProduct>)page, tpmAccountProduct);
        return pageList;
    }

    public List<AccountProduct> findByCode(String code) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AccountProduct::getAccountCode, (Object)code)).list();
    }

    public void deleteBatchByCodes(List<String> codes) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(AccountProduct::getAccountCode, codes)).remove();
    }

    public List<AccountProduct> findByCodes(List<String> codes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AccountProduct::getAccountCode, codes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }
}

