/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.tpm.business.pay.local.mapper.AccountVoMapper;
import com.biz.crm.tpm.business.pay.sdk.dto.AccountDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AccountVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AccountVoRepository
extends ServiceImpl<AccountVoMapper, AccountVo> {
    public List<AccountVo> findByIds(List<String> idList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpVo::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpVo::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidVo::getId, idList)).list();
    }

    public void enable(List<String> idList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpVo::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidVo::getId, idList)).update();
    }

    public void disable(List<String> idList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpVo::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidVo::getId, idList)).update();
    }

    public Page<AccountVo> findByConditions(Pageable pageable, AccountDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AccountVo> pageList = ((AccountVoMapper)this.baseMapper).findByConditions((Page<AccountVo>)page, dto);
        return pageList;
    }

    public Map<String, BigDecimal> findAllAccountAmount(AccountDto account) {
        List<AccountVo> allAccountAmount = ((AccountVoMapper)this.baseMapper).findAllAccountAmount(account);
        if (CollectionUtils.isEmpty(allAccountAmount)) {
            return new HashMap<String, BigDecimal>(0);
        }
        HashMap<String, BigDecimal> res = new HashMap<String, BigDecimal>();
        for (AccountVo accountVo : allAccountAmount) {
            BigDecimal amount = accountVo.getAmount();
            String customerCode = accountVo.getCustomerCode();
            String auditDetailCode = accountVo.getAuditDetailCode();
            String key = auditDetailCode.concat(customerCode != null ? customerCode : "");
            res.put(key, amount);
        }
        return res;
    }
}

