/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.pay.local.entity.AuditBill;
import com.biz.crm.tpm.business.pay.local.mapper.AuditBillMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditBillRepository
extends ServiceImpl<AuditBillMapper, AuditBill> {
    @Autowired
    private AuditBillMapper auditBillMapper;

    public List<AuditBill> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public AuditBill findByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (AuditBill)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditBill::getActivitiesDetailCode, (Object)activitiesDetailCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public void addAuditedAmount(String activitiesDetailCode, BigDecimal amount) {
        String tenantCode = TenantUtils.getTenantCode();
        this.auditBillMapper.addAuditAmount(activitiesDetailCode, amount, tenantCode);
    }

    public void reduceAuditedAmount(String activitiesDetailCode, BigDecimal amount) {
        String tenantCode = TenantUtils.getTenantCode();
        this.auditBillMapper.reduceAuditAmount(activitiesDetailCode, amount, tenantCode);
    }
}

