/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.pay.local.entity.Invoice;
import com.biz.crm.tpm.business.pay.local.mapper.InvoiceMapper;
import com.biz.crm.tpm.business.pay.sdk.dto.InvoiceDto;
import com.biz.crm.tpm.business.pay.sdk.vo.InvoiceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class InvoiceRepository
extends ServiceImpl<InvoiceMapper, Invoice> {
    @Autowired
    private InvoiceMapper invoiceMapper;

    public Page<InvoiceVo> findByConditions(Pageable pageable, InvoiceDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.invoiceMapper.findByConditions((Page<InvoiceVo>)page, dto);
    }

    public Invoice findByInvoiceNo(String invoiceNo) {
        return (Invoice)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Invoice::getInvoiceNo, (Object)invoiceNo)).one());
    }

    public List<Invoice> findByInvoiceNos(Set<String> invoiceNos) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(Invoice::getInvoiceNo, invoiceNos)).list();
    }

    public void updateEnableStatus(Set<String> ids, String enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).update();
    }

    public void delete(Set<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }
}

