/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.pay.local.entity.PrepayBill;
import com.biz.crm.tpm.business.pay.local.mapper.PrepayBillMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PrepayBillRepository
extends ServiceImpl<PrepayBillMapper, PrepayBill> {
    @Autowired
    private PrepayBillMapper prepayBillMapper;

    public List<PrepayBill> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public PrepayBill findByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (PrepayBill)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PrepayBill::getActivitiesDetailCode, (Object)activitiesDetailCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public List<PrepayBill> findByActivitiesDetailCodes(Collection<String> activitiesDetailCodes) {
        if (CollectionUtils.isEmpty(activitiesDetailCodes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PrepayBill::getActivitiesDetailCode, activitiesDetailCodes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(PrepayBill::getActivitiesDetailCode, (Object)activitiesDetailCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public void addPreparedAmount(String activitiesDetailCode, BigDecimal amount) {
        String tenantCode = TenantUtils.getTenantCode();
        this.prepayBillMapper.addPrepayAmount(activitiesDetailCode, amount, tenantCode);
    }

    public void reducePreparedAmount(String activitiesDetailCode, BigDecimal amount) {
        String tenantCode = TenantUtils.getTenantCode();
        this.prepayBillMapper.reducePrepayAmount(activitiesDetailCode, amount, tenantCode);
    }
}

