/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.pay.local.entity.PrepayDetail;
import com.biz.crm.tpm.business.pay.local.mapper.PrepayDetailMapper;
import com.biz.crm.tpm.business.pay.sdk.dto.PrepayDetailDto;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PrepayDetailRepository
extends ServiceImpl<PrepayDetailMapper, PrepayDetail> {
    @Autowired
    private PrepayDetailMapper prepayDetailMapper;

    public Page<PrepayDetailVo> findByConditions(Pageable pageable, PrepayDetailDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.prepayDetailMapper.findByConditions((Page<PrepayDetailVo>)page, dto);
    }

    public List<PrepayDetail> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(PrepayDetail::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, idList)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).set(PrepayDetail::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<PrepayDetail> findByPrepayCode(String prepayCode) {
        if (StringUtils.isBlank((CharSequence)prepayCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PrepayDetail::getPrepayCode, (Object)prepayCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(PrepayDetail::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public boolean deleteByPrepayCode(String prepayCode) {
        if (StringUtils.isBlank((CharSequence)prepayCode)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(PrepayDetail::getPrepayCode, (Object)prepayCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).set(PrepayDetail::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public PrepayDetail findByPrepayDetailCode(String prepayDetailCode) {
        if (StringUtils.isBlank((CharSequence)prepayDetailCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (PrepayDetail)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PrepayDetail::getPrepayDetailCode, (Object)prepayDetailCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(PrepayDetail::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }
}

