/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.pay.local.entity.AccountProduct;
import com.biz.crm.tpm.business.pay.local.repository.AccountProductRepository;
import com.biz.crm.tpm.business.pay.local.service.AccountProductService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountProductServiceImpl
implements AccountProductService {
    @Autowired
    private AccountProductRepository accountProductRepository;

    @Override
    public Page<AccountProduct> findByConditions(Pageable pageable, AccountProduct tpmAccountProduct) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)tpmAccountProduct)) {
            tpmAccountProduct = new AccountProduct();
        }
        return this.accountProductRepository.findByConditions(pageable, tpmAccountProduct);
    }

    @Override
    public AccountProduct findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (AccountProduct)((Object)this.accountProductRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public List<AccountProduct> findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.accountProductRepository.findByCode(code);
    }

    @Override
    @Transactional
    public AccountProduct create(AccountProduct tpmAccountProduct) {
        this.createValidate(tpmAccountProduct);
        this.accountProductRepository.saveOrUpdate((Object)tpmAccountProduct);
        return tpmAccountProduct;
    }

    @Override
    public void createBatch(List<AccountProduct> accountProducts) {
        Validate.notEmpty(accountProducts, (String)"\u65b0\u589e\u65f6\uff0c\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (AccountProduct accountProduct : accountProducts) {
            this.createValidate(accountProduct);
        }
        this.accountProductRepository.saveBatch(accountProducts);
    }

    @Override
    @Transactional
    public AccountProduct update(AccountProduct tpmAccountProduct) {
        this.updateValidate(tpmAccountProduct);
        this.accountProductRepository.saveOrUpdate((Object)tpmAccountProduct);
        return tpmAccountProduct;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.accountProductRepository.removeByIds(idList);
    }

    @Override
    public void deleteBatchByCodes(List<String> codes) {
        Validate.isTrue((!CollectionUtils.isEmpty(codes) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e0a\u8d26\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.accountProductRepository.deleteBatchByCodes(codes);
    }

    @Override
    public List<AccountProduct> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<AccountProduct>(0);
        }
        return this.accountProductRepository.findByCodes(codes);
    }

    private void createValidate(AccountProduct tpmAccountProduct) {
        tpmAccountProduct.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        tpmAccountProduct.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        tpmAccountProduct.setTenantCode(TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)tpmAccountProduct), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        tpmAccountProduct.setId(null);
        Validate.notBlank((CharSequence)tpmAccountProduct.getAccountCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u4e0a\u8d26\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmAccountProduct.getProductCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5546\u54c1\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmAccountProduct.getProductName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5546\u54c1\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(AccountProduct tpmAccountProduct) {
        tpmAccountProduct.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        tpmAccountProduct.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)((Object)tpmAccountProduct), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmAccountProduct.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmAccountProduct.getAccountCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u4e0a\u8d26\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmAccountProduct.getProductCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5546\u54c1\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmAccountProduct.getProductName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5546\u54c1\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

