/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.budget.sdk.strategy.payby.PayByStrategy;
import com.biz.crm.tpm.business.pay.local.entity.Account;
import com.biz.crm.tpm.business.pay.local.entity.AccountProduct;
import com.biz.crm.tpm.business.pay.local.repository.AccountVoRepository;
import com.biz.crm.tpm.business.pay.local.service.AccountProductService;
import com.biz.crm.tpm.business.pay.local.service.AccountService;
import com.biz.crm.tpm.business.pay.sdk.dto.AccountDto;
import com.biz.crm.tpm.business.pay.sdk.dto.AccountProductDto;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditDetailDto;
import com.biz.crm.tpm.business.pay.sdk.enums.AccountStatusEnum;
import com.biz.crm.tpm.business.pay.sdk.event.AccountEventListener;
import com.biz.crm.tpm.business.pay.sdk.service.AccountVoService;
import com.biz.crm.tpm.business.pay.sdk.service.AuditDetailWithCustomerVoService;
import com.biz.crm.tpm.business.pay.sdk.vo.AccountProductVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AccountVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditDetailWithCustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountVoServiceImpl
implements AccountVoService {
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountProductService accountProductService;
    @Autowired(required=false)
    private List<AccountEventListener> accountEventListeners;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private AccountVoRepository accountVoRepository;
    @Autowired(required=false)
    private List<PayByStrategy> payByStrategies;
    @Autowired(required=false)
    private AuditDetailWithCustomerVoService auditDetailWithCustomerVoService;

    public Page<AccountVo> findByConditions(Pageable pageable, AccountDto dto) {
        Page<AccountVo> byConditions;
        List accountVos;
        List<String> codes;
        List<AccountProduct> productList;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AccountDto();
        }
        if (!CollectionUtils.isEmpty(productList = this.accountProductService.findByCodes(codes = (accountVos = (byConditions = this.accountVoRepository.findByConditions(pageable, dto)).getRecords()).stream().map(AccountVo::getAccountCode).collect(Collectors.toList())))) {
            Collection accountProductVos = this.nebulaToolkitService.copyCollectionByWhiteList(productList, AccountProduct.class, AccountProductVo.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<AccountProductVo>> productMap = accountProductVos.stream().collect(Collectors.groupingBy(AccountProductVo::getAccountCode));
            for (AccountVo accountVo : accountVos) {
                String accountCode = accountVo.getAccountCode();
                List<AccountProductVo> productVos = productMap.get(accountCode);
                if (CollectionUtils.isEmpty(productVos)) continue;
                accountVo.setProductList(productVos);
            }
        }
        byConditions.setRecords(accountVos);
        return byConditions;
    }

    public AccountVo findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u67e5\u8be2ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Account entity = this.accountService.findById(id);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        AccountVo accountVo = (AccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AccountVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<AccountProduct> byCode = this.accountProductService.findByCode(accountVo.getAccountCode());
        if (CollectionUtils.isEmpty(byCode)) {
            return accountVo;
        }
        List accountProductVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(byCode, AccountProduct.class, AccountProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        accountVo.setProductList(accountProductVos);
        return accountVo;
    }

    @Transactional
    public AccountVo create(List<AccountDto> accountDtoList) {
        List<AccountDto> collect;
        this.amountVerify(accountDtoList);
        String ruleCode = StringUtils.join((Object[])new String[]{"SZ", DateFormatUtils.format((Date)new Date(), (String)"dd")});
        List accountCodes = this.generateCodeService.generateCode(ruleCode, accountDtoList.size());
        for (int i = 0; i < accountDtoList.size(); ++i) {
            accountDtoList.get(i).setAccountCode((String)accountCodes.get(i));
            BigDecimal customerAuditAmount = accountDtoList.get(i).getCustomerAuditAmount();
            if (!Objects.nonNull(customerAuditAmount)) continue;
            accountDtoList.get(i).setAuditAmount(customerAuditAmount);
        }
        List accounts = (List)this.nebulaToolkitService.copyCollectionByWhiteList(accountDtoList, AccountDto.class, Account.class, HashSet.class, ArrayList.class, new String[0]);
        this.accountService.createBatch(accounts);
        ArrayList<AccountProduct> productList = new ArrayList<AccountProduct>();
        for (AccountDto dto : accountDtoList) {
            List<AccountProduct> list = this.splitProducts(dto);
            if (CollectionUtils.isEmpty(list)) continue;
            productList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(productList)) {
            this.accountProductService.createBatch(productList);
        }
        if (!CollectionUtils.isEmpty(collect = accountDtoList.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getAccountStatus())).collect(Collectors.toList()))) {
            this.executeAccount(collect);
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(accountDtoList, AccountDto.class, AccountVo.class, HashSet.class, ArrayList.class, new String[]{"productList"});
        if (!CollectionUtils.isEmpty(this.accountEventListeners)) {
            for (AccountEventListener accountEventListener : this.accountEventListeners) {
                accountEventListener.onCreated(vos);
            }
        }
        return null;
    }

    private void executeAccount(List<AccountDto> accountDtoList) {
        if (CollectionUtils.isEmpty(accountDtoList) || CollectionUtils.isEmpty(this.payByStrategies)) {
            return;
        }
        for (AccountDto dto : accountDtoList) {
            String payBy = dto.getPayBy();
            List collect = this.payByStrategies.stream().filter(e -> e.getCode().equals(payBy)).collect(Collectors.toList());
            for (PayByStrategy payByStrategy : collect) {
                Collection accountPayByStrategies = payByStrategy.getAccountPayByStrategies();
                if (CollectionUtils.isEmpty((Collection)accountPayByStrategies)) continue;
                accountPayByStrategies.forEach(item -> item.execute((Object)dto));
            }
        }
    }

    private void amountVerify(List<AccountDto> accountDtoList) {
        Validate.notEmpty(accountDtoList, (String)"\u65b0\u589e\u65f6,\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<String> codes = accountDtoList.stream().map(AccountDto::getAuditDetailCode).collect(Collectors.toSet());
        Map<String, AccountVo> map = this.findAmountByAuditDetailCode(codes);
        Validate.notEmpty(map, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u76f8\u5173\u7684\u6838\u9500\u4fe1\u606f\uff0c\u65e0\u6cd5\u786e\u8ba4\u5f53\u524d\u4e0a\u8d26\u91d1\u989d\u662f\u5426\u6b63\u786e!", (Object[])new Object[0]);
        for (AccountDto dto : accountDtoList) {
            if (!Objects.nonNull(map.get(dto.getAuditDetailCode().concat(dto.getCustomerCode() != null ? dto.getCustomerCode() : "")))) continue;
            BigDecimal amount = dto.getAmount();
            BigDecimal availableAmount = map.get(dto.getAuditDetailCode().concat(dto.getCustomerCode() != null ? dto.getCustomerCode() : "")).getAvailableAmount();
            Validate.notNull((Object)amount, (String)("\u6838\u9500\u660e\u7ec6\u7f16\u7801[" + dto.getAuditDetailCode() + "],\u672a\u586b\u5199\u4e0a\u8d26\u91d1\u989d"), (Object[])new Object[0]);
            Validate.isTrue((amount.compareTo(availableAmount) <= 0 ? 1 : 0) != 0, (String)("\u6838\u9500\u660e\u7ec6\u7f16\u7801[" + dto.getAuditDetailCode() + "],\u4e0a\u8d26\u91d1\u989d\u8d85\u51fa\u5f53\u524d\u53ef\u4e0a\u8d26\u91d1\u989d"), (Object[])new Object[0]);
            dto.setAvailableAmount(availableAmount);
        }
    }

    private List<AccountProduct> splitProducts(AccountDto dto) {
        String accountCode = dto.getAccountCode();
        List productList = dto.getProductList();
        if (CollectionUtils.isEmpty((Collection)productList)) {
            return null;
        }
        for (AccountProductDto accountProductDto : productList) {
            accountProductDto.setAccountCode(accountCode);
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)productList, AccountProductDto.class, AccountProduct.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public AccountVo update(AccountDto dto) {
        Validate.notNull((Object)dto, (String)"\u66f4\u65b0\u65f6\uff0c\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        String id = dto.getId();
        AccountVo oldVo = this.findById(id);
        String accountStatus = oldVo.getAccountStatus();
        Validate.isTrue((boolean)accountStatus.equals(AccountStatusEnum.PENDING.getDictCode()), (String)"\u53ea\u80fd\u7f16\u8f91\u5f85\u4e0a\u8d26\u72b6\u6001\u7684\u8d39\u7528\u4fe1\u606f", (Object[])new Object[0]);
        Account newEntity = (Account)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldVo, Account.class, HashSet.class, ArrayList.class, new String[0]));
        newEntity.setAmount(dto.getAmount());
        newEntity.setAccountStatus(dto.getAccountStatus());
        newEntity.setRemark(dto.getRemark());
        newEntity.setProductLevelCode(dto.getProductLevelCode());
        newEntity.setProductLevelName(dto.getProductLevelName());
        this.amountVerify(Lists.newArrayList((Object[])new AccountDto[]{dto}));
        this.accountService.update(newEntity);
        this.accountProductService.deleteBatchByCodes(Lists.newArrayList((Object[])new String[]{dto.getAccountCode()}));
        ArrayList<AccountProduct> productList = new ArrayList<AccountProduct>();
        List<AccountProduct> list = this.splitProducts(dto);
        if (!CollectionUtils.isEmpty(list)) {
            productList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(productList)) {
            this.accountProductService.createBatch(productList);
        }
        if (StringUtils.isBlank((CharSequence)dto.getAccountStatus())) {
            this.executeAccount(Lists.newArrayList((Object[])new AccountDto[]{dto}));
        }
        AccountVo newVo = (AccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)newEntity, AccountVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(this.accountEventListeners)) {
            for (AccountEventListener accountEventListener : this.accountEventListeners) {
                accountEventListener.onUpdate(oldVo, newVo);
            }
        }
        return null;
    }

    @Transactional
    public void delete(List<String> idList) {
        Validate.notEmpty(idList, (String)"\u5220\u9664\u5bf9\u8c61ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<Account> byIds = this.accountService.findByIds(idList);
        Validate.notEmpty(idList, (String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e!", (Object[])new Object[0]);
        Validate.isTrue((byIds.size() == idList.size() ? 1 : 0) != 0, (String)"\u4f20\u5165ID\u96c6\u5408\u4e0e\u76f8\u5173\u6570\u636e\u96c6\u5408\u957f\u5ea6\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List onList = byIds.stream().filter(e -> e.getAccountStatus().equals(AccountStatusEnum.ON.getDictCode())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(onList), (String)"\u53ea\u80fd\u5220\u9664\u5f85\u4e0a\u8d26\u6570\u636e", (Object[])new Object[0]);
        this.accountService.deleteBatch(idList);
        List<String> codes = byIds.stream().map(Account::getAccountCode).collect(Collectors.toList());
        this.accountProductService.deleteBatchByCodes(codes);
        List accountVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(byIds, Account.class, AccountVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(this.accountEventListeners)) {
            for (AccountEventListener accountEventListener : this.accountEventListeners) {
                accountEventListener.onDeleted(accountVos);
            }
        }
    }

    public Page<AccountVo> findAuditByDto(Pageable pageable, AccountDto account) {
        AuditDetailDto dto;
        List auditDetailWithCustomer;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(account)) {
            account = new AccountDto();
        }
        if (CollectionUtils.isEmpty((Collection)(auditDetailWithCustomer = this.auditDetailWithCustomerVoService.getAuditDetailWithCustomer(dto = (AuditDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)account, AuditDetailDto.class, HashSet.class, ArrayList.class, new String[0]))))) {
            return null;
        }
        List accountVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)auditDetailWithCustomer, AuditDetailWithCustomerVo.class, AccountVo.class, HashSet.class, ArrayList.class, new String[]{"productList"});
        Map<String, BigDecimal> allAccountAmount = this.accountVoRepository.findAllAccountAmount(account);
        List<Object> res = this.countAvailableAmount(accountVos, allAccountAmount);
        long totalSize = res.size();
        res = res.stream().sorted(Comparator.comparing(AccountVo::getAuditDetailCode).reversed()).skip(pageable.getPageSize() * (pageable.getPageNumber() > 0 ? pageable.getPageNumber() - 1 : 0)).limit(pageable.getPageSize()).collect(Collectors.toList());
        Page result = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        result.setRecords(res);
        result.setTotal(totalSize);
        return result;
    }

    private List<AccountVo> countAvailableAmount(List<AccountVo> accountVos, Map<String, BigDecimal> allAccountAmount) {
        for (AccountVo accountVo : accountVos) {
            String customerCode = accountVo.getCustomerCode();
            String auditDetailCode = accountVo.getAuditDetailCode();
            BigDecimal auditAmount = accountVo.getAuditAmount();
            BigDecimal customerAuditAmount = accountVo.getCustomerAuditAmount();
            accountVo.setAvailableAmount(BigDecimal.ZERO);
            if (CollectionUtils.isEmpty(allAccountAmount)) continue;
            if (StringUtils.isBlank((CharSequence)customerCode)) {
                BigDecimal accountAmount = allAccountAmount.get(auditDetailCode);
                BigDecimal subtract = auditAmount.subtract(accountAmount != null ? accountAmount : BigDecimal.ZERO);
                Validate.isTrue((subtract.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u53ef\u4e0a\u8d26\u91d1\u989d\u8d85\u51fa\u6838\u9500\u91d1\u989d", (Object[])new Object[0]);
                accountVo.setAvailableAmount(subtract);
                continue;
            }
            String key = auditDetailCode.concat(customerCode);
            BigDecimal accountAmount = allAccountAmount.get(key);
            BigDecimal subtract = customerAuditAmount.subtract(accountAmount != null ? accountAmount : BigDecimal.ZERO);
            Validate.isTrue((subtract.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u53ef\u4e0a\u8d26\u91d1\u989d\u8d85\u51fa\u6838\u9500\u91d1\u989d", (Object[])new Object[0]);
            accountVo.setAvailableAmount(subtract);
        }
        return accountVos.stream().filter(e -> e.getAvailableAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
    }

    public Map<String, AccountVo> findAmountByAuditDetailCode(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Maps.newHashMap();
        }
        AuditDetailDto dto = new AuditDetailDto();
        dto.setAuditDetailCodeList((List)Lists.newArrayList(codes));
        List auditDetailWithCustomer = this.auditDetailWithCustomerVoService.getAuditDetailWithCustomer(dto);
        if (CollectionUtils.isEmpty((Collection)auditDetailWithCustomer)) {
            return null;
        }
        List accountVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)auditDetailWithCustomer, AuditDetailWithCustomerVo.class, AccountVo.class, HashSet.class, ArrayList.class, new String[0]);
        AccountDto account = new AccountDto();
        Map<String, BigDecimal> allAccountAmount = this.accountVoRepository.findAllAccountAmount(account);
        List<AccountVo> res = this.countAvailableAmount(accountVos, allAccountAmount);
        HashMap<String, AccountVo> map = new HashMap<String, AccountVo>();
        for (AccountVo vo : res) {
            String auditDetailCode = vo.getAuditDetailCode();
            String customerCode = vo.getCustomerCode();
            map.put(auditDetailCode.concat(customerCode != null ? customerCode : ""), vo);
        }
        return map;
    }

    @Transactional
    public void enable(List<String> idList) {
        Validate.notEmpty(idList, (String)"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AccountVo> byIds = this.findByIds(idList);
        Validate.notEmpty(byIds, (String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((byIds.size() == idList.size() ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0e\u67e5\u8be2\u51fa\u7684\u6570\u636e\u4e0d\u7b26\u5408!", (Object[])new Object[0]);
        this.accountVoRepository.enable(idList);
    }

    public List<AccountVo> findByIds(List<String> idList) {
        Validate.notEmpty(idList, (String)"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.accountVoRepository.findByIds(idList);
    }

    public void disable(List<String> idList) {
        Validate.notEmpty(idList, (String)"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AccountVo> byIds = this.findByIds(idList);
        Validate.notEmpty(byIds, (String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((byIds.size() == idList.size() ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0e\u67e5\u8be2\u51fa\u7684\u6570\u636e\u4e0d\u7b26\u5408!", (Object[])new Object[0]);
        this.accountVoRepository.disable(idList);
    }
}

