/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.pay.local.entity.AuditActivities;
import com.biz.crm.tpm.business.pay.local.repository.AuditActivitiesRepository;
import com.biz.crm.tpm.business.pay.local.service.AuditActivitiesService;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditActivitiesDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditActivitiesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="auditActivitiesService")
public class AuditActivitiesServiceImpl
implements AuditActivitiesService {
    @Autowired
    private AuditActivitiesRepository auditActivitiesRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<AuditActivitiesVo> findByConditions(Pageable pageable, AuditActivitiesDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditActivitiesDto();
        }
        return this.auditActivitiesRepository.findByConditions(pageable, dto);
    }

    @Override
    public AuditActivitiesVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditActivities auditActivities = (AuditActivities)((Object)this.auditActivitiesRepository.getById((Serializable)((Object)id)));
        if (auditActivities == null) {
            return null;
        }
        AuditActivitiesVo auditActivitiesVo = (AuditActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditActivities, AuditActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditActivitiesVo;
    }

    @Override
    public List<AuditActivitiesVo> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return Collections.emptyList();
        }
        List<AuditActivities> auditActivities = this.auditActivitiesRepository.findByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(auditActivities)) {
            return Collections.emptyList();
        }
        Collection auditActivitiesVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditActivities, AuditActivities.class, AuditActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)auditActivitiesVos);
    }

    @Override
    @Transactional
    public AuditActivitiesVo create(AuditActivitiesDto auditActivitiesDto) {
        this.createValidate(auditActivitiesDto);
        AuditActivities auditActivities = (AuditActivities)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditActivitiesDto, AuditActivities.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        auditActivities.setTenantCode(TenantUtils.getTenantCode());
        this.auditActivitiesRepository.saveOrUpdate((Object)auditActivities);
        AuditActivitiesVo auditActivitiesVo = (AuditActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditActivities, AuditActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditActivitiesVo.setId(auditActivities.getId());
        return auditActivitiesVo;
    }

    @Override
    @Transactional
    public AuditActivitiesVo update(AuditActivitiesDto auditActivitiesDto) {
        this.updateValidate(auditActivitiesDto);
        AuditActivities auditActivities = (AuditActivities)((Object)this.auditActivitiesRepository.getById((Serializable)((Object)auditActivitiesDto.getId())));
        Validate.notNull((Object)((Object)auditActivities), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        auditActivities.setActivitiesCode(auditActivitiesDto.getActivitiesCode());
        auditActivities.setActivitiesName(auditActivitiesDto.getActivitiesName());
        auditActivities.setBeginTime(auditActivitiesDto.getBeginTime());
        auditActivities.setEndTime(auditActivitiesDto.getEndTime());
        auditActivities.setAuditCode(auditActivitiesDto.getAuditCode());
        this.auditActivitiesRepository.saveOrUpdate((Object)auditActivities);
        AuditActivitiesVo auditActivitiesVo = (AuditActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditActivities, AuditActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditActivitiesVo;
    }

    @Override
    @Transactional
    public List<AuditActivitiesVo> createBatch(List<AuditActivitiesDto> auditActivitiesDtos) {
        if (CollectionUtils.isEmpty(auditActivitiesDtos)) {
            return Lists.newArrayList();
        }
        ArrayList auditActivitiesVos = Lists.newArrayList();
        for (AuditActivitiesDto auditActivitiesDto : auditActivitiesDtos) {
            AuditActivitiesVo activitiesVo = this.create(auditActivitiesDto);
            auditActivitiesVos.add(activitiesVo);
        }
        return auditActivitiesVos;
    }

    @Override
    @Transactional
    public List<AuditActivitiesVo> updateBatch(List<AuditActivitiesDto> auditActivitiesDtos) {
        if (CollectionUtils.isEmpty(auditActivitiesDtos)) {
            return Collections.emptyList();
        }
        String auditCode = ((AuditActivitiesDto)auditActivitiesDtos.stream().findFirst().get()).getAuditCode();
        List<AuditActivitiesVo> dbAuditActivitiesVos = this.findByAuditCode(auditCode);
        Set dbIds = dbAuditActivitiesVos.stream().map(AuditActivitiesVo::getId).collect(Collectors.toSet());
        Set currentIds = auditActivitiesDtos.stream().map(AuditActivitiesDto::getId).collect(Collectors.toSet());
        List<AuditActivitiesDto> addData = auditActivitiesDtos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditActivitiesDto> updateData = auditActivitiesDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).collect(Collectors.toList());
        Sets.SetView delData = Sets.difference(dbIds, currentIds);
        if (!CollectionUtils.isEmpty((Collection)delData)) {
            this.delete(Lists.newArrayList((Iterable)delData));
        }
        List<AuditActivitiesVo> auditActivitiesVos = this.createBatch(addData);
        if (!CollectionUtils.isEmpty(updateData)) {
            updateData.forEach(item -> auditActivitiesVos.add(this.update((AuditActivitiesDto)item)));
        }
        return auditActivitiesVos;
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<AuditActivities> auditActivitiess = this.auditActivitiesRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(auditActivitiess)) {
            return;
        }
        this.auditActivitiesRepository.removeByIds(ids);
    }

    @Override
    @Transactional
    public void deleteByAuditCode(String auditCode) {
        this.auditActivitiesRepository.deleteByAuditCode(auditCode);
    }

    private void createValidate(AuditActivitiesDto auditActivitiesDto) {
        Validate.notNull((Object)auditActivitiesDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        auditActivitiesDto.setId(null);
        Validate.notBlank((CharSequence)auditActivitiesDto.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditActivitiesDto.getActivitiesName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditActivitiesDto.getBeginTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditActivitiesDto.getEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(AuditActivitiesDto auditActivitiesDto) {
        Validate.notNull((Object)auditActivitiesDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditActivitiesDto.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditActivitiesDto.getActivitiesCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditActivitiesDto.getActivitiesName(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditActivitiesDto.getBeginTime(), (String)"\u4fee\u6539\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditActivitiesDto.getEndTime(), (String)"\u4fee\u6539\u65f6\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

