/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.pay.local.dto.AuditBillRecordDto;
import com.biz.crm.tpm.business.pay.local.entity.AuditBill;
import com.biz.crm.tpm.business.pay.local.repository.AuditBillRepository;
import com.biz.crm.tpm.business.pay.local.service.AuditBillRecordService;
import com.biz.crm.tpm.business.pay.local.service.AuditBillService;
import com.biz.crm.tpm.business.pay.local.service.AuditDetailService;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditBillDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditBillVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="auditBillService")
public class AuditBillServiceImpl
implements AuditBillService {
    @Autowired
    private AuditBillRepository auditBillRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private AuditDetailService auditDetailService;
    @Autowired
    private AuditBillRecordService auditBillRecordService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private ActivitiesService activitiesService;

    @Override
    public AuditBillVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditBill auditBill = (AuditBill)((Object)this.auditBillRepository.getById((Serializable)((Object)id)));
        if (auditBill == null) {
            return null;
        }
        AuditBillVo auditBillVo = (AuditBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditBill, AuditBillVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditBillVo;
    }

    @Override
    public AuditBillVo findByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return null;
        }
        AuditBill auditBill = this.auditBillRepository.findByActivitiesDetailCode(activitiesDetailCode);
        if (auditBill == null) {
            return null;
        }
        AuditBillVo auditBillVo = (AuditBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditBill, AuditBillVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditBillVo;
    }

    @Override
    @Transactional
    public AuditBillVo create(AuditBillDto auditBillDto) {
        this.createValidate(auditBillDto);
        AuditBill auditBill = this.auditBillRepository.findByActivitiesDetailCode(auditBillDto.getActivitiesDetailCode());
        if (auditBill != null) {
            AuditBillVo auditBillVo = (AuditBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditBill, AuditBillVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            auditBillVo.setId(auditBill.getId());
            return auditBillVo;
        }
        auditBill = (AuditBill)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditBillDto, AuditBill.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        auditBill.setTenantCode(TenantUtils.getTenantCode());
        this.auditBillRepository.saveOrUpdate((Object)auditBill);
        AuditBillVo auditBillVo = (AuditBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditBill, AuditBillVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditBillVo.setId(auditBill.getId());
        AuditBillRecordDto auditBillRecordDto = new AuditBillRecordDto();
        auditBillRecordDto.setTenantCode(TenantUtils.getTenantCode());
        auditBillRecordDto.setActivitiesDetailCode(auditBill.getActivitiesDetailCode());
        auditBillRecordDto.setChangeAmount(BigDecimal.ZERO);
        auditBillRecordDto.setType(0);
        this.auditBillRecordService.create(auditBillRecordDto);
        return auditBillVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void auditAmountByActivityDetailCode(String activitiesDetailCode, String auditDetailCode, BigDecimal amount) {
        Validate.notBlank((CharSequence)activitiesDetailCode, (String)"\u66f4\u6539\u5df2\u6838\u9500\u91d1\u989d\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String lockKey = String.format("bz:crm:tpm:audit:lock:%s:%s", tenantCode, activitiesDetailCode);
        boolean isLock = false;
        try {
            isLock = this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, 10);
            Validate.isTrue((boolean)isLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            this.auditBillRepository.addAuditedAmount(activitiesDetailCode, amount);
            AuditBillRecordDto auditBillRecordDto = new AuditBillRecordDto();
            auditBillRecordDto.setTenantCode(TenantUtils.getTenantCode());
            auditBillRecordDto.setActivitiesDetailCode(activitiesDetailCode);
            auditBillRecordDto.setChangeAmount(amount);
            auditBillRecordDto.setBusinessCode(auditDetailCode);
            auditBillRecordDto.setType(1);
            this.auditBillRecordService.create(auditBillRecordDto);
            AuditBill auditBill = this.auditBillRepository.findByActivitiesDetailCode(activitiesDetailCode);
            BigDecimal waitBackAmount = auditBill.getApplyAmount().subtract(auditBill.getAuditedAmount());
            if (auditBill.getIsFullAudit().equals(BooleanEnum.TRUE.getCapital()) && waitBackAmount.compareTo(BigDecimal.ZERO) > 0) {
                AuditDetailVo auditDetailVo = this.auditDetailService.findByAuditDetailCode(auditDetailCode);
                ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(auditDetailVo.getActivitiesCode());
                Validate.notNull((Object)activitiesVo, (String)"\u8be5\u6d3b\u52a8\u660e\u7ec6\u3010%s\u3011\u4e0d\u542b\u6709\u4e3b\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{auditDetailVo.getActivitiesDetailCode()});
                this.costBudgetVoService.back(auditDetailVo.getAuditCode(), auditDetailVo.getAuditDetailCode(), auditDetailVo.getCostBudgetCode(), waitBackAmount, null, CostBudgetItemSourceType.AUDIT.getDescr());
            }
        }
        finally {
            if (isLock) {
                this.redisMutexService.unlock(lockKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backAuditAmountByActivityDetailCode(String activitiesDetailCode, String auditDetailCode, BigDecimal amount) {
        Validate.notBlank((CharSequence)activitiesDetailCode, (String)"\u66f4\u6539\u5df2\u6838\u9500\u91d1\u989d\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String lockKey = String.format("bz:crm:tpm:audit:lock:%s:%s", tenantCode, activitiesDetailCode);
        boolean isLock = false;
        try {
            isLock = this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, 10);
            Validate.isTrue((boolean)isLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            this.auditBillRepository.reduceAuditedAmount(activitiesDetailCode, amount);
            AuditBillRecordDto auditBillRecordDto = new AuditBillRecordDto();
            auditBillRecordDto.setTenantCode(TenantUtils.getTenantCode());
            auditBillRecordDto.setActivitiesDetailCode(activitiesDetailCode);
            auditBillRecordDto.setBusinessCode(auditDetailCode);
            auditBillRecordDto.setChangeAmount(amount);
            auditBillRecordDto.setType(2);
            this.auditBillRecordService.create(auditBillRecordDto);
        }
        finally {
            if (isLock) {
                this.redisMutexService.unlock(lockKey);
            }
        }
    }

    @Override
    @Transactional
    public void auditAmountByAuditCode(String auditCode) {
        List<AuditDetailVo> auditDetailVos = this.auditDetailService.findByAuditCode(auditCode);
        for (AuditDetailVo auditDetailVo : auditDetailVos) {
            this.auditAmountByActivityDetailCode(auditDetailVo.getActivitiesDetailCode(), auditDetailVo.getAuditDetailCode(), auditDetailVo.getAuditAmount());
        }
    }

    @Override
    public void backAuditAmountByAuditCode(String auditCode) {
        List<AuditDetailVo> auditDetailVos = this.auditDetailService.findByAuditCode(auditCode);
        for (AuditDetailVo auditDetailVo : auditDetailVos) {
            this.backAuditAmountByActivityDetailCode(auditDetailVo.getActivitiesDetailCode(), auditDetailVo.getAuditDetailCode(), auditDetailVo.getAuditAmount());
        }
    }

    @Override
    public void updateIsFullAudit(String activitiesDetailCode, String isFullAudit) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{activitiesDetailCode, isFullAudit})) {
            return;
        }
        AuditBill auditBill = this.auditBillRepository.findByActivitiesDetailCode(activitiesDetailCode);
        auditBill.setIsFullAudit(isFullAudit);
        this.auditBillRepository.saveOrUpdate((Object)auditBill);
    }

    private void createValidate(AuditBillDto auditBillDto) {
        Validate.notNull((Object)auditBillDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        auditBillDto.setId(null);
        Validate.notBlank((CharSequence)auditBillDto.getActivitiesDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditBillDto.getApplyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditBillDto.getAuditedAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5df2\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private String analysisSource(String value) {
        switch (value) {
            case "OrdinaryActivity": {
                return CostBudgetItemSourceType.ORDINARY_ACTIVITY.getDescr();
            }
            case "ProjectActivity": {
                return CostBudgetItemSourceType.PROJECT_ACTIVITY.getDescr();
            }
            case "SchemeActivity": {
                return CostBudgetItemSourceType.SCHEMA_ACTIVITY.getDescr();
            }
        }
        throw new IllegalArgumentException("\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u6765\u6e90\uff0c\u8bf7\u68c0\u67e5");
    }
}

