/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.pay.local.entity.AuditCustomer;
import com.biz.crm.tpm.business.pay.local.repository.AuditCustomerRepository;
import com.biz.crm.tpm.business.pay.local.service.AuditCustomerService;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditCustomerDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditCustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="auditCustomerService")
public class AuditCustomerServiceImpl
implements AuditCustomerService {
    @Autowired
    private AuditCustomerRepository auditCustomerRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<AuditCustomerVo> findByConditions(Pageable pageable, AuditCustomerDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditCustomerDto();
        }
        return this.auditCustomerRepository.findByConditions(pageable, dto);
    }

    @Override
    public AuditCustomerVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditCustomer auditCustomer = (AuditCustomer)((Object)this.auditCustomerRepository.getById((Serializable)((Object)id)));
        if (auditCustomer == null) {
            return null;
        }
        AuditCustomerVo auditCustomerVo = (AuditCustomerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCustomer, AuditCustomerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditCustomerVo;
    }

    @Override
    public List<AuditCustomerVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<AuditCustomer> auditCustomers = this.auditCustomerRepository.findByIds(ids);
        Collection auditCustomerVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditCustomers, AuditCustomer.class, AuditCustomerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)auditCustomerVos);
    }

    @Override
    public List<AuditCustomerVo> findByAuditDetailCode(String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return Collections.emptyList();
        }
        List<AuditCustomer> auditCustomers = this.auditCustomerRepository.findByAuditDetailCode(auditDetailCode);
        if (CollectionUtils.isEmpty(auditCustomers)) {
            return Collections.emptyList();
        }
        Collection auditCustomerVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditCustomers, AuditCustomer.class, AuditCustomerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)auditCustomerVos);
    }

    @Override
    public List<AuditCustomerVo> findByAuditDetailCodes(Collection<String> auditDetailCodes) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return Collections.emptyList();
        }
        List<AuditCustomer> auditCustomers = this.auditCustomerRepository.findByAuditDetailCodes(auditDetailCodes);
        if (CollectionUtils.isEmpty(auditCustomers)) {
            return Collections.emptyList();
        }
        Collection auditCustomerVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditCustomers, AuditCustomer.class, AuditCustomerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)auditCustomerVos);
    }

    @Override
    @Transactional
    public AuditCustomerVo create(AuditCustomerDto auditCustomerDto) {
        this.createValidate(auditCustomerDto);
        AuditCustomer auditCustomer = (AuditCustomer)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCustomerDto, AuditCustomer.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        auditCustomer.setTenantCode(TenantUtils.getTenantCode());
        this.auditCustomerRepository.saveOrUpdate((Object)auditCustomer);
        AuditCustomerVo auditCustomerVo = (AuditCustomerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCustomer, AuditCustomerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditCustomerVo.setId(auditCustomer.getId());
        return auditCustomerVo;
    }

    @Override
    @Transactional
    public List<AuditCustomerVo> createBatch(Collection<AuditCustomerDto> auditCustomerDtos) {
        if (CollectionUtils.isEmpty(auditCustomerDtos)) {
            return Lists.newArrayList();
        }
        ArrayList auditCustomerVos = Lists.newArrayList();
        for (AuditCustomerDto auditCustomerDto : auditCustomerDtos) {
            AuditCustomerVo auditCustomerVo = this.create(auditCustomerDto);
            auditCustomerVos.add(auditCustomerVo);
        }
        return auditCustomerVos;
    }

    @Override
    @Transactional
    public AuditCustomerVo update(AuditCustomerDto auditCustomerDto) {
        this.updateValidate(auditCustomerDto);
        AuditCustomer auditCustomer = (AuditCustomer)((Object)this.auditCustomerRepository.getById((Serializable)((Object)auditCustomerDto.getId())));
        Validate.notNull((Object)((Object)auditCustomer), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        auditCustomer.setCustomerCode(auditCustomerDto.getCustomerCode());
        auditCustomer.setCustomerName(auditCustomerDto.getCustomerName());
        auditCustomer.setAuditAmount(auditCustomerDto.getAuditAmount());
        this.auditCustomerRepository.saveOrUpdate((Object)auditCustomer);
        AuditCustomerVo auditCustomerVo = (AuditCustomerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCustomer, AuditCustomerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditCustomerVo;
    }

    @Override
    @Transactional
    public List<AuditCustomerVo> updateBatch(Collection<AuditCustomerDto> auditCustomerDtos) {
        Set currentIds;
        if (CollectionUtils.isEmpty(auditCustomerDtos)) {
            return Collections.emptyList();
        }
        String code = auditCustomerDtos.stream().findFirst().get().getAuditDetailCode();
        List<AuditCustomerVo> dbAuditCustomerVos = this.findByAuditDetailCode(code);
        Set dbIds = dbAuditCustomerVos.stream().map(AuditCustomerVo::getId).collect(Collectors.toSet());
        Sets.SetView delData = Sets.difference(dbIds, currentIds = auditCustomerDtos.stream().map(AuditCustomerDto::getId).collect(Collectors.toSet()));
        if (!CollectionUtils.isEmpty((Collection)delData)) {
            this.delete((Collection<String>)delData);
        }
        List<AuditCustomerDto> addDtos = auditCustomerDtos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditCustomerDto> updateDtos = auditCustomerDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditCustomerVo> auditCustomerVos = this.createBatch(addDtos);
        if (!CollectionUtils.isEmpty(updateDtos)) {
            updateDtos.forEach(item -> auditCustomerVos.add(this.update((AuditCustomerDto)item)));
        }
        return auditCustomerVos;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<AuditCustomer> auditCustomers = this.auditCustomerRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(auditCustomers)) {
            return;
        }
        Set delIds = auditCustomers.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.auditCustomerRepository.removeByIds(delIds);
    }

    @Override
    public void deleteByAuditCode(String auditCode) {
        this.auditCustomerRepository.deleteByAuditCode(auditCode);
    }

    private void createValidate(AuditCustomerDto auditCustomerDto) {
        Validate.notNull((Object)auditCustomerDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((auditCustomerDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditCustomerDto.getAuditCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6838\u9500\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditCustomerDto.getAuditDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6838\u9500\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditCustomerDto.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditCustomerDto.getCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditCustomerDto.getAuditAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((auditCustomerDto.getAuditAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u5c0f\u4e8e\u6216\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(AuditCustomerDto auditCustomerDto) {
        Validate.notNull((Object)auditCustomerDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditCustomerDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditCustomerDto.getCustomerCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditCustomerDto.getCustomerName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditCustomerDto.getAuditAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((auditCustomerDto.getAuditAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u5c0f\u4e8e\u6216\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
    }
}

