/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailCollectService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailCollectVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeCategoryVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeDetailVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.payby.PayByStrategy;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeCategoryVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeDetailVo;
import com.biz.crm.tpm.business.pay.local.entity.AuditDetail;
import com.biz.crm.tpm.business.pay.local.repository.AuditDetailRepository;
import com.biz.crm.tpm.business.pay.local.service.AuditBillService;
import com.biz.crm.tpm.business.pay.local.service.AuditCustomerService;
import com.biz.crm.tpm.business.pay.local.service.AuditDetailService;
import com.biz.crm.tpm.business.pay.local.service.AuditProductService;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditBillDto;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditCustomerDto;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditDetailDto;
import com.biz.crm.tpm.business.pay.sdk.event.AuditDetailEventListener;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditBillVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditCustomerVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditDetailVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="auditDetailService")
public class AuditDetailServiceImpl
implements AuditDetailService {
    private static final Logger log = LoggerFactory.getLogger(AuditDetailServiceImpl.class);
    @Autowired
    private AuditDetailRepository auditDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AuditProductService auditProductService;
    @Autowired
    private CostTypeDetailVoService costTypeDetailVoService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private AuditBillService auditBillService;
    @Autowired
    private ActivitiesService activitiesService;
    @Autowired
    private AuditCustomerService auditCustomerService;
    @Autowired
    private CostTypeCategoryVoService costTypeCategoryVoService;
    @Autowired(required=false)
    private List<PayByStrategy> payByStrategies;
    @Autowired(required=false)
    private List<AuditDetailEventListener> auditDetailEventListeners;
    @Autowired
    private ActivitiesDetailService activitiesDetailService;
    @Autowired
    private ActivitiesDetailCollectService activitiesDetailCollectService;

    @Override
    public Page<AuditDetailVo> findByConditions(Pageable pageable, AuditDetailDto dto) {
        Page<AuditDetailVo> page;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditDetailDto();
        }
        if (!CollectionUtils.isEmpty((Collection)(page = this.auditDetailRepository.findByConditions(pageable, dto)).getRecords())) {
            page.getRecords().forEach(item -> this.fillDetail((AuditDetailVo)item));
        }
        return page;
    }

    @Override
    public AuditDetailVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditDetail auditDetail = (AuditDetail)((Object)this.auditDetailRepository.getById((Serializable)((Object)id)));
        if (auditDetail == null) {
            return null;
        }
        AuditDetailVo auditDetailVo = (AuditDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditDetail, AuditDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(auditDetailVo);
        return auditDetailVo;
    }

    @Override
    public AuditDetailVo findByAuditDetailCode(String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return null;
        }
        AuditDetail auditDetail = this.auditDetailRepository.findByCode(auditDetailCode);
        if (auditDetail == null) {
            return null;
        }
        AuditDetailVo auditDetailVo = (AuditDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditDetail, AuditDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(auditDetailVo);
        return auditDetailVo;
    }

    @Override
    public List<AuditDetailVo> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return Collections.emptyList();
        }
        List<AuditDetail> auditDetails = this.auditDetailRepository.findByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(auditDetails)) {
            return Collections.emptyList();
        }
        Collection auditDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditDetails, AuditDetail.class, AuditDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditDetailVos.forEach(item -> this.fillDetail((AuditDetailVo)item));
        return Lists.newArrayList((Iterable)auditDetailVos);
    }

    private AuditDetailVo findByCode(String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return null;
        }
        AuditDetail auditDetail = this.auditDetailRepository.findByCode(auditDetailCode);
        AuditDetailVo auditDetailVo = (AuditDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditDetail, AuditDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(auditDetailVo);
        return auditDetailVo;
    }

    private void fillDetail(AuditDetailVo auditDetailVo) {
        if (auditDetailVo == null) {
            return;
        }
        AuditBillVo auditBillVo = this.auditBillService.findByActivitiesDetailCode(auditDetailVo.getActivitiesDetailCode());
        auditDetailVo.setAuditedAmount(auditBillVo.getAuditedAmount());
        auditDetailVo.setIsFullAudit(auditBillVo.getIsFullAudit());
        List<AuditProductVo> auditProductVos = this.auditProductService.findByAuditDetailCode(auditDetailVo.getAuditDetailCode());
        auditDetailVo.setAuditProducts(auditProductVos);
        CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(auditDetailVo.getCostTypeDetailCode());
        auditDetailVo.setCostTypeDetailVo(costTypeDetailVo);
        List<AuditCustomerVo> auditCustomerVos = this.auditCustomerService.findByAuditDetailCode(auditDetailVo.getAuditDetailCode());
        auditDetailVo.setAuditCustomers(auditCustomerVos);
        ActivitiesDetailVo activitiesDetailVo = this.activitiesDetailService.findByActivitiesDetailCode(auditDetailVo.getActivitiesDetailCode());
        auditDetailVo.setActivitiesDetailVo(activitiesDetailVo);
    }

    @Override
    @Transactional
    public AuditDetailVo create(AuditDetailDto auditDetailDto) {
        AuditBillVo auditBillVo;
        List<AuditProductVo> auditProductVos;
        String code = (String)this.generateCodeService.generateCode("HXMX", 1).get(0);
        auditDetailDto.setAuditDetailCode(code);
        this.createValidate(auditDetailDto);
        AuditDetail auditDetail = (AuditDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditDetailDto, AuditDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        auditDetail.setTenantCode(TenantUtils.getTenantCode());
        auditDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.auditDetailRepository.saveOrUpdate((Object)auditDetail);
        AuditDetailVo auditDetailVo = (AuditDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditDetail, AuditDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditDetailVo.setId(auditDetail.getId());
        if (!CollectionUtils.isEmpty(this.auditDetailEventListeners)) {
            for (AuditDetailEventListener auditDetailEventListener : this.auditDetailEventListeners) {
                auditDetailEventListener.onCreated(auditDetailVo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)auditDetailDto.getAuditProducts())) {
            auditDetailDto.getAuditProducts().forEach(item -> {
                item.setAuditCode(auditDetailVo.getAuditCode());
                item.setAuditDetailCode(auditDetailVo.getAuditDetailCode());
            });
            auditProductVos = this.auditProductService.createBatch(auditDetailDto.getAuditProducts());
            auditDetailVo.setAuditProducts(auditProductVos);
        }
        if (!CollectionUtils.isEmpty((Collection)auditDetailDto.getAuditCustomers())) {
            auditDetailDto.getAuditCustomers().forEach(item -> {
                item.setAuditCode(auditDetailVo.getAuditCode());
                item.setAuditDetailCode(auditDetailVo.getAuditDetailCode());
            });
            auditProductVos = this.auditCustomerService.createBatch(auditDetailDto.getAuditCustomers());
            auditDetailVo.setAuditCustomers(auditProductVos);
        }
        if ((auditBillVo = this.auditBillService.findByActivitiesDetailCode(auditDetailDto.getActivitiesDetailCode())) == null) {
            AuditBillDto auditBillDto = new AuditBillDto();
            auditBillDto.setAuditedAmount(BigDecimal.ZERO);
            auditBillDto.setApplyAmount(auditDetailDto.getApplyAmount());
            auditBillDto.setTenantCode(TenantUtils.getTenantCode());
            auditBillDto.setActivitiesDetailCode(auditDetailDto.getActivitiesDetailCode());
            auditBillDto.setIsFullAudit(auditDetailDto.getIsFullAudit());
            this.auditBillService.create(auditBillDto);
            this.activitiesDetailService.updateFullAuditByActivitiesDetailCode(auditDetailDto.getActivitiesDetailCode(), auditDetailDto.getIsFullAudit());
        } else {
            this.auditBillService.updateIsFullAudit(auditBillVo.getActivitiesDetailCode(), auditDetailDto.getIsFullAudit());
            this.activitiesDetailService.updateFullAuditByActivitiesDetailCode(auditDetailDto.getActivitiesDetailCode(), auditDetailDto.getIsFullAudit());
        }
        auditDetailVo.setIsFullAudit(auditDetailDto.getIsFullAudit());
        return auditDetailVo;
    }

    @Override
    @Transactional
    public List<AuditDetailVo> createBatch(List<AuditDetailDto> auditDetailDtos) {
        if (CollectionUtils.isEmpty(auditDetailDtos)) {
            return Lists.newArrayList();
        }
        ArrayList auditDetailVos = Lists.newArrayList();
        for (AuditDetailDto auditDetailDto : auditDetailDtos) {
            AuditDetailVo auditDetailVo = this.create(auditDetailDto);
            auditDetailVos.add(auditDetailVo);
        }
        return auditDetailVos;
    }

    @Override
    @Transactional
    public AuditDetailVo update(AuditDetailDto auditDetailDto) {
        List<AuditProductVo> auditProductVos;
        this.updateValidate(auditDetailDto);
        AuditDetail auditDetail = (AuditDetail)((Object)this.auditDetailRepository.getById((Serializable)((Object)auditDetailDto.getId())));
        Validate.notNull((Object)((Object)auditDetail), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        AuditDetailVo oldAuditDetailVo = (AuditDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditDetail, AuditDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditDetail.setPayBy(auditDetailDto.getPayBy());
        auditDetail.setPayByName(auditDetailDto.getPayByName());
        auditDetail.setAuditAmount(auditDetailDto.getAuditAmount());
        auditDetail.setProductLevelCode(auditDetailDto.getProductLevelCode());
        auditDetail.setProductLevelName(auditDetailDto.getProductLevelName());
        auditDetail.setActivitiesDetailCode(auditDetailDto.getActivitiesDetailCode());
        auditDetail.setAccountingSubjectsCode(auditDetailDto.getAccountingSubjectsCode());
        auditDetail.setAccountingSubjectsName(auditDetailDto.getAccountingSubjectsName());
        auditDetail.setApplyAmount(auditDetailDto.getApplyAmount());
        auditDetail.setRemark(auditDetailDto.getRemark());
        auditDetail.setExcessAmount(auditDetailDto.getExcessAmount());
        this.auditDetailRepository.saveOrUpdate((Object)auditDetail);
        AuditDetailVo auditDetailVo = (AuditDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditDetail, AuditDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)auditDetailDto.getAuditProducts())) {
            auditDetailDto.getAuditProducts().forEach(item -> {
                item.setAuditCode(auditDetailVo.getAuditCode());
                item.setAuditDetailCode(auditDetailVo.getAuditDetailCode());
            });
            auditProductVos = this.auditProductService.updateBatch(auditDetailDto.getAuditProducts());
            auditDetailVo.setAuditProducts(auditProductVos);
        }
        if (!CollectionUtils.isEmpty((Collection)auditDetailDto.getAuditCustomers())) {
            auditDetailDto.getAuditCustomers().forEach(item -> {
                item.setAuditCode(auditDetailVo.getAuditCode());
                item.setAuditDetailCode(auditDetailVo.getAuditDetailCode());
            });
            auditProductVos = this.auditCustomerService.updateBatch(auditDetailDto.getAuditCustomers());
            auditDetailVo.setAuditCustomers(auditProductVos);
        }
        this.auditBillService.updateIsFullAudit(auditDetailVo.getActivitiesDetailCode(), auditDetailDto.getIsFullAudit());
        this.activitiesDetailService.updateFullAuditByActivitiesDetailCode(auditDetailDto.getActivitiesDetailCode(), auditDetailDto.getIsFullAudit());
        auditDetailVo.setIsFullAudit(auditDetailDto.getIsFullAudit());
        if (!CollectionUtils.isEmpty(this.auditDetailEventListeners)) {
            for (AuditDetailEventListener auditDetailEventListener : this.auditDetailEventListeners) {
                auditDetailEventListener.onUpdate(oldAuditDetailVo, auditDetailVo);
            }
        }
        return auditDetailVo;
    }

    @Override
    @Transactional
    public List<AuditDetailVo> updateBatch(List<AuditDetailDto> auditDetailDtos) {
        Set currentIds;
        if (CollectionUtils.isEmpty(auditDetailDtos)) {
            return Collections.emptyList();
        }
        String auditCode = ((AuditDetailDto)auditDetailDtos.stream().findFirst().get()).getAuditCode();
        List<AuditDetailVo> dbAuditDetailVos = this.findByAuditCode(auditCode);
        Set dbIds = dbAuditDetailVos.stream().map(AuditDetailVo::getId).collect(Collectors.toSet());
        Sets.SetView deleteIds = Sets.difference(dbIds, currentIds = auditDetailDtos.stream().map(AuditDetailDto::getId).collect(Collectors.toSet()));
        if (!CollectionUtils.isEmpty((Collection)deleteIds)) {
            this.delete(Lists.newArrayList((Iterable)deleteIds));
        }
        List<AuditDetailDto> addDtos = auditDetailDtos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditDetailDto> updateDtos = auditDetailDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditDetailVo> auditDetailVos = this.createBatch(addDtos);
        if (!CollectionUtils.isEmpty(updateDtos)) {
            updateDtos.forEach(item -> auditDetailVos.add(this.update((AuditDetailDto)item)));
        }
        return auditDetailVos;
    }

    @Override
    @Transactional
    public void updateCostTypeDetailName(String costTypeDetailCode, String costTypeDetailName) {
        this.auditDetailRepository.updateCostTypeDetailName(costTypeDetailCode, costTypeDetailName);
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<AuditDetail> auditDetails = this.auditDetailRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(auditDetails)) {
            return;
        }
        Collection auditDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditDetails, AuditDetail.class, AuditDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.auditDetailRepository.removeByIds(ids);
        if (!CollectionUtils.isEmpty(this.auditDetailEventListeners)) {
            for (AuditDetailEventListener auditDetailEventListener : this.auditDetailEventListeners) {
                for (AuditDetailVo auditDetailVo : auditDetailVos) {
                    auditDetailEventListener.onDeleted(auditDetailVo);
                }
            }
        }
    }

    @Override
    public void deleteByAuditCode(String auditCode) {
        this.auditCustomerService.deleteByAuditCode(auditCode);
        this.auditDetailRepository.removeByAuditCode(auditCode);
    }

    @Override
    public void deleteByAuditCodes(Collection<String> auditCodes) {
        this.auditDetailRepository.removeByAuditCodes(auditCodes);
    }

    @Override
    @Transactional
    public void doRefund(String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return;
        }
        AuditDetailVo auditDetailVo = this.findByCode(auditDetailCode);
        AuditBillVo auditBillVo = this.auditBillService.findByActivitiesDetailCode(auditDetailVo.getActivitiesDetailCode());
        if (BooleanEnum.TRUE.getCapital().equals(auditBillVo.getIsFullAudit())) {
            return;
        }
        BigDecimal auditedAmount = auditBillVo.getAuditedAmount();
        BigDecimal applyAmount = auditBillVo.getApplyAmount();
        BigDecimal refundAmount = applyAmount.subtract(auditedAmount);
        if (refundAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.auditDetailRepository.updateRefundAmount(auditDetailVo.getAuditDetailCode(), refundAmount);
            ActivitiesDetailVo basicActivityItemVo = this.activitiesDetailService.findByActivitiesDetailCode(auditDetailVo.getActivitiesDetailCode());
            Validate.notNull((Object)basicActivityItemVo, (String)"\u6d3b\u52a8\u660e\u7ec6\u3010%s\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{auditDetailVo.getActivitiesDetailCode()});
            ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(auditDetailVo.getActivitiesCode());
            Validate.notNull((Object)activitiesVo, (String)"\u8be5\u6d3b\u52a8\u660e\u7ec6\u3010%s\u3011\u4e0d\u542b\u6709\u4e3b\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{auditDetailVo.getActivitiesDetailCode()});
            this.costBudgetVoService.back(auditDetailVo.getActivitiesCode(), basicActivityItemVo.getActivitiesDetailCode(), basicActivityItemVo.getCostBudgetCode(), refundAmount, null, this.analysisSource(activitiesVo.getActivityMark()));
        } else {
            log.warn("\u6838\u9500\u660e\u7ec6\u7f16\u53f7\u3010{}\u3011\u6570\u636e\u5728\u8fdb\u884c\u9000\u8d39\u65f6\u5019\uff0c\u9000\u8d39\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u8bf7\u6838\u5bf9\u68c0\u67e5\u662f\u5426\u8d85\u989d\u6838\u9500\uff01", (Object)auditDetailVo.getAuditDetailCode());
        }
    }

    @Override
    public Set<String> findActivitiesDetailByAuditing(Set<String> costTypeDetailCodes) {
        return this.auditDetailRepository.findActivitiesDetailByAuditing(costTypeDetailCodes);
    }

    @Override
    public Set<String> findActivitiesDetailByAudited() {
        return this.auditDetailRepository.findActivitiesDetailByAudited();
    }

    @Override
    public Set<String> findActivitiesDetailByFullAudit() {
        return this.auditDetailRepository.findActivitiesDetailByFullAudit();
    }

    @Override
    public List<ActivitiesDetailCollectVo> findDetailCollectByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return Collections.emptyList();
        }
        List activitiesDetailCollectVos = this.activitiesDetailCollectService.findByActivitiesDetailCode(activitiesDetailCode);
        return activitiesDetailCollectVos;
    }

    private void createValidate(AuditDetailDto auditDetailDto) {
        Validate.notNull((Object)auditDetailDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        auditDetailDto.setId(null);
        Validate.notBlank((CharSequence)auditDetailDto.getAuditCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u7533\u8bf7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getAuditDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u7533\u8bf7\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getActivitiesDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getCostTypeDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getCostTypeCategoryCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditDetailDto.getApplyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditDetailDto.getAuditAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getAuditDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getPayBy(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getCostBudgetCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u9884\u7b97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validate(auditDetailDto, true);
        this.validateExist(auditDetailDto, true);
        this.validatePayBy(auditDetailDto);
    }

    private void updateValidate(AuditDetailDto auditDetailDto) {
        Validate.notNull((Object)auditDetailDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditDetailDto.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getAuditCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6838\u9500\u7533\u8bf7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getAuditDetailCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6838\u9500\u7533\u8bf7\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getActivitiesCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getActivitiesName(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getActivitiesDetailCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getCostTypeDetailCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getCostTypeDetailName(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getCostTypeCategoryCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getCostTypeCategoryName(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditDetailDto.getApplyAmount(), (String)"\u4fee\u6539\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditDetailDto.getAuditAmount(), (String)"\u4fee\u6539\u65f6\uff0c\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getAuditDetailCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getPayBy(), (String)"\u4fee\u6539\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDetailDto.getCostBudgetCode(), (String)"\u4fee\u6539\u65f6\uff0c\u8d39\u7528\u9884\u7b97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validate(auditDetailDto, false);
        this.validateExist(auditDetailDto, false);
        this.validatePayBy(auditDetailDto);
    }

    private void validate(AuditDetailDto auditDetailDto, boolean addFlag) {
        if (!CollectionUtils.isEmpty((Collection)auditDetailDto.getAuditCustomers())) {
            BigDecimal customerAuditAmount = auditDetailDto.getAuditCustomers().stream().map(AuditCustomerDto::getAuditAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Validate.isTrue((customerAuditAmount.compareTo(auditDetailDto.getAuditAmount()) == 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u6838\u9500\u91d1\u989d\u4e0e\u5ba2\u6237\u7533\u8bf7\u6838\u9500\u91d1\u989d\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        }
        CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(auditDetailDto.getCostTypeDetailCode());
        Validate.notNull((Object)costTypeDetailVo, (String)"\u6d3b\u52a8\u7ec6\u7c7b\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        CostTypeCategoryVo costTypeCategoryVo = this.costTypeCategoryVoService.findByCode(auditDetailDto.getCostTypeCategoryCode());
        Validate.notNull((Object)costTypeCategoryVo, (String)"\u6d3b\u52a8\u5927\u7c7b\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        auditDetailDto.setCostTypeCategoryName(costTypeCategoryVo.getCategoryName());
        auditDetailDto.setCostTypeDetailName(costTypeDetailVo.getDetailName());
        auditDetailDto.setBudgetSubjectsCode(costTypeCategoryVo.getBudgetSubjectsCode());
        auditDetailDto.setBudgetSubjectsName(costTypeCategoryVo.getBudgetSubjectsName());
        auditDetailDto.setIsMultipleAudit(costTypeDetailVo.getIsMultipleAudit());
        ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(auditDetailDto.getActivitiesCode());
        Validate.notNull((Object)activitiesVo, (String)"\u6d3b\u52a8\u7f16\u53f7\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        auditDetailDto.setActivitiesName(activitiesVo.getActivitiesName());
        auditDetailDto.setBeginTime(activitiesVo.getBeginTime());
        auditDetailDto.setEndTime(activitiesVo.getEndTime());
        Validate.isTrue((boolean)BooleanEnum.TRUE.getCapital().equals(costTypeDetailVo.getIsAudit()), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u3010%s\u3011\u5173\u8054\u6d3b\u52a8\u672a\u5f00\u542f\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{auditDetailDto.getActivitiesDetailCode()});
        Integer auditValidityMonth = costTypeDetailVo.getAuditValidityTime();
        if (auditValidityMonth != null && auditValidityMonth > 0) {
            LocalDateTime activitiesEndTime = LocalDateTime.ofInstant(activitiesVo.getEndTime().toInstant(), ZoneId.systemDefault());
            LocalDateTime validityTime = activitiesEndTime.plusMonths(auditValidityMonth.intValue());
            LocalDateTime now = LocalDateTime.now();
            Validate.isTrue((boolean)now.isBefore(validityTime), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u3010%s\u3011,\u6838\u9500\u65f6\u95f4\u5df2\u7ecf\u8d85\u8fc7\u6838\u9500\u6709\u6548\u671f", (Object[])new Object[]{auditDetailDto.getAuditDetailCode()});
        }
        if (BooleanEnum.FALSE.getCapital().equals(costTypeDetailVo.getIsMultipleAudit())) {
            int detailCount = this.auditDetailRepository.countByCostTypeAndActivitiesDetail(costTypeDetailVo.getDetailCode(), auditDetailDto.getActivitiesDetailCode());
            if (addFlag) {
                Validate.isTrue((detailCount == 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6 \u6d3b\u52a8\u3010%s\u3011-\u3010%s\u3011\u4e0d\u5141\u8bb8\u591a\u6b21\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{costTypeDetailVo.getDetailCode(), costTypeDetailVo.getDetailName()});
            } else {
                Validate.isTrue((detailCount == 1 ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6 \u8be5\u6d3b\u52a8\u3010%s\u3011-\u3010%s\u3011\u4e0d\u5141\u8bb8\u591a\u6b21\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{costTypeDetailVo.getDetailCode(), costTypeDetailVo.getDetailName()});
            }
            auditDetailDto.setIsFullAudit(BooleanEnum.TRUE.getCapital());
        }
        BigDecimal applyAmount = auditDetailDto.getApplyAmount();
        AuditBillVo auditBillVo = this.auditBillService.findByActivitiesDetailCode(auditDetailDto.getActivitiesDetailCode());
        BigDecimal auditedAmount = BigDecimal.ZERO;
        if (auditBillVo != null) {
            auditedAmount = auditBillVo.getAuditedAmount();
        }
        BigDecimal auditAmount = auditDetailDto.getAuditAmount();
        if (BooleanEnum.FALSE.getCapital().equals(costTypeDetailVo.getIsAutoAudit())) {
            if (costTypeDetailVo.getExceedingAuditRate() != null) {
                BigDecimal excessAmount = applyAmount.multiply(costTypeDetailVo.getExceedingAuditRate()).divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                Integer compare = applyAmount.add(excessAmount).compareTo(auditedAmount.add(auditAmount));
                Validate.isTrue((compare >= 0 ? 1 : 0) != 0, (String)"\u6838\u9500\u91d1\u989d\u8d85\u51fa\u7533\u8bf7\u91d1\u989d\uff0c\u7533\u8bf7\u91d1\u989d\u3010%s\u3011, \u5141\u8bb8\u8d85\u989d\u91d1\u989d\u3010%s\u3011,\u5df2\u7ecf\u6838\u9500\u91d1\u989d\u3010%s\u3011\u7533\u8bf7\u6838\u9500\u91d1\u989d\u3010%s\u3011", (Object[])new Object[]{applyAmount.toString(), excessAmount.toString(), auditedAmount.toString(), auditAmount.toString()});
                if (compare == 0) {
                    auditDetailDto.setIsFullAudit(BooleanEnum.TRUE.getCapital());
                } else if (compare < 0) {
                    Validate.isTrue((applyAmount.compareTo(auditedAmount.add(auditAmount)) >= 0 ? 1 : 0) != 0, (String)"\u6838\u9500\u91d1\u989d\u8d85\u51fa\u7533\u8bf7\u91d1\u989d\uff0c\u7533\u8bf7\u91d1\u989d\u3010%s\u3011,\u5df2\u7ecf\u6838\u9500\u91d1\u989d\u3010%s\u3011\u7533\u8bf7\u6838\u9500\u91d1\u989d\u3010%s\u3011", (Object[])new Object[]{applyAmount.toString(), auditedAmount.toString(), auditAmount.toString()});
                } else {
                    BigDecimal currentAmount;
                    excessAmount = auditedAmount.compareTo(applyAmount) > 0 ? auditAmount : ((currentAmount = applyAmount.subtract(auditedAmount).subtract(auditAmount)).compareTo(BigDecimal.ZERO) < 0 ? currentAmount.abs() : BigDecimal.ZERO);
                }
                auditDetailDto.setExcessAmount(excessAmount);
            } else {
                BigDecimal currentAmount = applyAmount.subtract(auditedAmount).subtract(auditAmount);
                Validate.isTrue((currentAmount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u91d1\u989d\u3010%s\u3011,\u5df2\u7ecf\u6838\u9500\u91d1\u989d\u3010%s\u3011,\u5df2\u7ecf\u8d85\u51fa\u7533\u8bf7\u91d1\u989d\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{auditAmount.toString(), auditedAmount.toString(), applyAmount.toString()});
                if (currentAmount.compareTo(BigDecimal.ZERO) == 0) {
                    auditDetailDto.setIsFullAudit(BooleanEnum.TRUE.getCapital());
                }
            }
        }
    }

    private void validateExist(AuditDetailDto auditDetailDto, boolean isAdd) {
        int detailCount = 0;
        detailCount = isAdd ? this.auditDetailRepository.countByActivitiesDetailCodesAndProcessStatus(auditDetailDto.getActivitiesDetailCode(), Lists.newArrayList((Object[])new Integer[]{0, 1, 3, 4})) : this.auditDetailRepository.countByExcludeActivitiesCodeAndActivitiesDetailCodesAndProcessStatus(auditDetailDto.getAuditCode(), auditDetailDto.getActivitiesDetailCode(), Lists.newArrayList((Object[])new Integer[]{0, 1, 3, 4}));
        Validate.isTrue((detailCount == 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6838\u9500\u660e\u7ec6\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u3010%s\u3011\u5b58\u5728\u5f85\u5ba1\u6838\u8d39\u7528\u6838\u9500\u4fe1\u606f\uff0c\u4e0d\u80fd\u518d\u6b21\u6dfb\u52a0\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{auditDetailDto.getActivitiesDetailCode()});
    }

    private void validatePayBy(AuditDetailDto auditDetailDto) {
        Validate.notNull((Object)auditDetailDto.getAuditDto(), (String)"\u6838\u9500\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (BooleanEnum.TRUE.getCapital().equals(auditDetailDto.getAuditDto().getIsAutoAudit())) {
            return;
        }
        if (CollectionUtils.isEmpty(this.payByStrategies)) {
            return;
        }
        String payBy = auditDetailDto.getPayBy();
        List currentValidators = this.payByStrategies.stream().filter(item -> item.getCode().equals(payBy)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(currentValidators)) {
            return;
        }
        for (PayByStrategy payByStrategy : currentValidators) {
            if (CollectionUtils.isEmpty((Collection)payByStrategy.getValidators())) continue;
            payByStrategy.getValidators().forEach(item -> item.handler((Object)auditDetailDto));
        }
    }

    private String analysisSource(String value) {
        switch (value) {
            case "OrdinaryActivity": {
                return CostBudgetItemSourceType.ORDINARY_ACTIVITY.getDescr();
            }
            case "ProjectActivity": {
                return CostBudgetItemSourceType.PROJECT_ACTIVITY.getDescr();
            }
            case "SchemeActivity": {
                return CostBudgetItemSourceType.SCHEMA_ACTIVITY.getDescr();
            }
        }
        throw new IllegalArgumentException("\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u6765\u6e90\uff0c\u8bf7\u68c0\u67e5");
    }
}

