/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.pay.local.entity.AuditFiles;
import com.biz.crm.tpm.business.pay.local.repository.AuditFilesRepository;
import com.biz.crm.tpm.business.pay.local.service.AuditFilesService;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditFilesDto;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditFilesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="auditFilesService")
public class AuditFilesServiceImpl
implements AuditFilesService {
    @Autowired
    private AuditFilesRepository auditFilesRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<AuditFilesVo> findByConditions(Pageable pageable, AuditFilesDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditFilesDto();
        }
        return this.auditFilesRepository.findByConditions(pageable, dto);
    }

    @Override
    public AuditFilesVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFiles auditFiles = (AuditFiles)((Object)this.auditFilesRepository.getById((Serializable)((Object)id)));
        if (auditFiles == null) {
            return null;
        }
        AuditFilesVo auditFilesVo = (AuditFilesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFiles, AuditFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditFilesVo;
    }

    @Override
    public List<AuditFilesVo> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        List<AuditFiles> auditFiles = this.auditFilesRepository.findByAuditCode(auditCode);
        if (auditFiles == null) {
            return null;
        }
        Collection auditFilesVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditFiles, AuditFiles.class, AuditFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)auditFilesVos);
    }

    @Override
    @Transactional
    public AuditFilesVo create(AuditFilesDto auditFilesDto) {
        this.createValidate(auditFilesDto);
        AuditFiles auditFiles = (AuditFiles)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFilesDto, AuditFiles.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        auditFiles.setTenantCode(TenantUtils.getTenantCode());
        this.auditFilesRepository.saveOrUpdate((Object)auditFiles);
        AuditFilesVo auditFilesVo = (AuditFilesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFiles, AuditFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditFilesVo.setId(auditFiles.getId());
        return auditFilesVo;
    }

    @Override
    public List<AuditFilesVo> createBatch(List<AuditFilesDto> auditFilesDtos) {
        if (CollectionUtils.isEmpty(auditFilesDtos)) {
            return Lists.newArrayList();
        }
        ArrayList auditFilesVos = Lists.newArrayList();
        for (AuditFilesDto auditFilesDto : auditFilesDtos) {
            AuditFilesVo auditFilesVo = this.create(auditFilesDto);
            auditFilesVos.add(auditFilesVo);
        }
        return auditFilesVos;
    }

    @Override
    @Transactional
    public AuditFilesVo update(AuditFilesDto auditFilesDto) {
        this.updateValidate(auditFilesDto);
        AuditFiles auditFiles = (AuditFiles)((Object)this.auditFilesRepository.getById((Serializable)((Object)auditFilesDto.getId())));
        Validate.notNull((Object)((Object)auditFiles), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        auditFiles.setAuditCode(auditFilesDto.getAuditCode());
        auditFiles.setFileName(auditFilesDto.getFileName());
        auditFiles.setRelativePath(auditFilesDto.getRelativePath());
        auditFiles.setRefileName(auditFilesDto.getRefileName());
        auditFiles.setUrl(auditFilesDto.getUrl());
        auditFiles.setCostTypeDetailCode(auditFilesDto.getCostTypeDetailCode());
        auditFiles.setCostTypeDetailName(auditFilesDto.getCostTypeDetailName());
        auditFiles.setRequestCode(auditFilesDto.getRequestCode());
        this.auditFilesRepository.saveOrUpdate((Object)auditFiles);
        AuditFilesVo auditFilesVo = (AuditFilesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFiles, AuditFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditFilesVo;
    }

    @Override
    public List<AuditFilesVo> updateBatch(List<AuditFilesDto> auditFilesDtos) {
        Set currentIds;
        if (CollectionUtils.isEmpty(auditFilesDtos)) {
            return Collections.emptyList();
        }
        String auditCode = ((AuditFilesDto)auditFilesDtos.stream().findFirst().get()).getAuditCode();
        List<AuditFilesVo> dbAuditFilesVos = this.findByAuditCode(auditCode);
        Set dbIds = dbAuditFilesVos.stream().map(AuditFilesVo::getId).collect(Collectors.toSet());
        Sets.SetView deleteIds = Sets.difference(dbIds, currentIds = auditFilesDtos.stream().map(AuditFilesDto::getId).collect(Collectors.toSet()));
        if (!CollectionUtils.isEmpty((Collection)deleteIds)) {
            this.delete(Lists.newArrayList((Iterable)deleteIds));
        }
        List<AuditFilesDto> addDtos = auditFilesDtos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditFilesDto> updateDtos = auditFilesDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<AuditFilesVo> auditFilesVos = this.createBatch(addDtos);
        if (!CollectionUtils.isEmpty(updateDtos)) {
            updateDtos.forEach(item -> auditFilesVos.add(this.update((AuditFilesDto)item)));
        }
        return auditFilesVos;
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<AuditFiles> auditFiless = this.auditFilesRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(auditFiless)) {
            return;
        }
        Collection auditFilesVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditFiless, AuditFiles.class, AuditFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.auditFilesRepository.removeByIds(ids);
    }

    @Override
    @Transactional
    public void deleteByAuditCode(String auditCode) {
        this.auditFilesRepository.removeByAuditCode(auditCode);
    }

    private void createValidate(AuditFilesDto auditFilesDto) {
        Validate.notNull((Object)auditFilesDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        auditFilesDto.setId(null);
        Validate.notBlank((CharSequence)auditFilesDto.getAuditCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6838\u9500\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getFileName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getRelativePath(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getRefileName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91cd\u547d\u540d\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getUrl(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getCostTypeDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getCostTypeDetailName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getRequestCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8981\u6c42\u6838\u9500\u8d44\u6599\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(AuditFilesDto auditFilesDto) {
        Validate.notNull((Object)auditFilesDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getAuditCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6838\u9500\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getFileName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getRelativePath(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getRefileName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u91cd\u547d\u540d\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getUrl(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getCostTypeDetailCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getCostTypeDetailName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFilesDto.getRequestCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8981\u6c42\u6838\u9500\u8d44\u6599\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

