/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.budget.sdk.dto.CostTypeDetailsDto;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeDetailVoService;
import com.biz.crm.tpm.business.pay.local.entity.Audit;
import com.biz.crm.tpm.business.pay.local.repository.AuditRepository;
import com.biz.crm.tpm.business.pay.local.service.AuditActivitiesService;
import com.biz.crm.tpm.business.pay.local.service.AuditBillService;
import com.biz.crm.tpm.business.pay.local.service.AuditDetailService;
import com.biz.crm.tpm.business.pay.local.service.AuditFilesService;
import com.biz.crm.tpm.business.pay.local.service.AuditInvoiceService;
import com.biz.crm.tpm.business.pay.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.pay.sdk.dto.InvoiceDetailDto;
import com.biz.crm.tpm.business.pay.sdk.dto.log.AuditLogEventDto;
import com.biz.crm.tpm.business.pay.sdk.event.AuditEventListener;
import com.biz.crm.tpm.business.pay.sdk.event.log.AuditLogEventListener;
import com.biz.crm.tpm.business.pay.sdk.service.AuditService;
import com.biz.crm.tpm.business.pay.sdk.service.InvoiceDeailService;
import com.biz.crm.tpm.business.pay.sdk.service.InvoiceService;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditActivitiesVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditActivityItemVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditBillVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditDetailVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditFilesVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditInvoiceVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditVo;
import com.biz.crm.tpm.business.pay.sdk.vo.InvoiceVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.StartProcessDto;
import com.biz.crm.workflow.sdk.listener.ProcessListener;
import com.biz.crm.workflow.sdk.vo.response.CommitWorkflowResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="auditService")
public class AuditServiceImpl
implements AuditService {
    @Autowired
    private AuditRepository auditRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private List<AuditEventListener> auditEventListeners;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private AuditActivitiesService auditActivitiesService;
    @Autowired
    private AuditDetailService auditDetailService;
    @Autowired
    private AuditFilesService auditFilesService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private CostTypeDetailVoService costTypeDetailVoService;
    @Autowired
    private ActivitiesService activitiesService;
    @Autowired
    private AuditBillService auditBillService;
    @Autowired
    private ActivitiesDetailService activitiesDetailService;
    @Autowired
    private AuditInvoiceService auditInvoiceService;
    @Autowired
    private InvoiceService invoiceService;
    @Autowired
    private InvoiceDeailService invoiceDeailService;

    public Page<AuditVo> findByConditions(Pageable pageable, AuditDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditDto();
        }
        return this.auditRepository.findByConditions(pageable, dto);
    }

    public Page<AuditActivityItemVo> findActivitiesDetailByConditions(Pageable pageable, ActivitiesDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ActivitiesDto();
        }
        HashSet excludeCostTypeDetailCodes = Sets.newHashSet();
        HashSet excludeActivitiesDetailCodes = Sets.newHashSet();
        CostTypeDetailsDto notAuditDto = new CostTypeDetailsDto();
        notAuditDto.setIsAudit(BooleanEnum.FALSE.getCapital());
        Set notAuditCostTypeDetailCodes = this.costTypeDetailVoService.findCodeByCondition(notAuditDto);
        CostTypeDetailsDto autoAuditDto = new CostTypeDetailsDto();
        autoAuditDto.setIsAudit(BooleanEnum.TRUE.getCapital());
        autoAuditDto.setIsAutoAudit(BooleanEnum.TRUE.getCapital());
        Set autoAuditCostTypeDetailCodes = this.costTypeDetailVoService.findCodeByCondition(autoAuditDto);
        CostTypeDetailsDto notMultiAuditDto = new CostTypeDetailsDto();
        notMultiAuditDto.setIsAudit(BooleanEnum.TRUE.getCapital());
        notMultiAuditDto.setIsMultipleAudit(BooleanEnum.FALSE.getCapital());
        Set notMultiAuditCostTypeDetailCodes = this.costTypeDetailVoService.findCodeByCondition(notMultiAuditDto);
        Set<String> auditingActivitiesDetailCodes = this.auditDetailService.findActivitiesDetailByAuditing(notMultiAuditCostTypeDetailCodes);
        Set<String> auditFullActivitiesDetailCodes = this.auditDetailService.findActivitiesDetailByFullAudit();
        excludeCostTypeDetailCodes.addAll(notAuditCostTypeDetailCodes);
        excludeCostTypeDetailCodes.addAll(autoAuditCostTypeDetailCodes);
        excludeActivitiesDetailCodes.addAll(auditingActivitiesDetailCodes);
        excludeActivitiesDetailCodes.addAll(auditFullActivitiesDetailCodes);
        ActivitiesDetailDto detailDto = new ActivitiesDetailDto();
        detailDto.setExcludeCostTypeDetailCodes((Set)excludeCostTypeDetailCodes);
        detailDto.setExcludeItemCodes((Set)excludeActivitiesDetailCodes);
        detailDto.setActivitiesCode(dto.getActivitiesCode());
        detailDto.setActivitiesName(dto.getActivitiesName());
        detailDto.setActivitiesCodes(dto.getActivitiesCodes());
        detailDto.setCreateName(dto.getCreateName());
        detailDto.setIsFullAudit(BooleanEnum.FALSE.getCapital());
        Page basicPage = this.activitiesDetailService.findByConditions(pageable, detailDto);
        ArrayList result = Lists.newArrayList();
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (!CollectionUtils.isEmpty((Collection)basicPage.getRecords())) {
            for (ActivitiesDetailVo basicActivityItemVo : basicPage.getRecords()) {
                AuditActivityItemVo auditActivityItemVo = (AuditActivityItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)basicActivityItemVo, AuditActivityItemVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"costTypeDetailVo"});
                AuditBillVo auditBillVo = this.auditBillService.findByActivitiesDetailCode(basicActivityItemVo.getActivitiesDetailCode());
                if (auditBillVo == null) {
                    auditActivityItemVo.setAuditedAmount(BigDecimal.ZERO);
                } else {
                    auditActivityItemVo.setAuditedAmount(auditBillVo.getAuditedAmount());
                }
                result.add(auditActivityItemVo);
            }
        }
        page.setRecords((List)result);
        page.setTotal(basicPage.getTotal());
        return page;
    }

    public AuditVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Audit audit = (Audit)((Object)this.auditRepository.getById((Serializable)((Object)id)));
        if (audit == null) {
            return null;
        }
        AuditVo auditVo = (AuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetails(auditVo);
        return auditVo;
    }

    public AuditVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        Audit audit = this.auditRepository.findByCode(code);
        if (audit == null) {
            return null;
        }
        AuditVo auditVo = (AuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetails(auditVo);
        return auditVo;
    }

    public List<AuditVo> findByActivitiesDetailCode(String activitiesDetailCode) {
        return this.auditRepository.findByActivitiesDetailCode(activitiesDetailCode);
    }

    private void fillDetails(AuditVo auditVo) {
        List<AuditActivitiesVo> auditActivitiesVos = this.auditActivitiesService.findByAuditCode(auditVo.getAuditCode());
        auditVo.setAuditActivities(auditActivitiesVos);
        List<AuditDetailVo> auditDetailVos = this.auditDetailService.findByAuditCode(auditVo.getAuditCode());
        auditVo.setAuditDetails(auditDetailVos);
        List<AuditFilesVo> auditFilesVos = this.auditFilesService.findByAuditCode(auditVo.getAuditCode());
        auditVo.setAuditFiles(auditFilesVos);
        List<AuditInvoiceVo> auditInvoiceVos = this.auditInvoiceService.findByAuditCode(auditVo.getAuditCode());
        if (!CollectionUtils.isEmpty(auditInvoiceVos)) {
            auditInvoiceVos.forEach(item -> {
                InvoiceVo invoiceVo = this.invoiceService.findByInvoiceNo(item.getInvoiceNo());
                BeanUtils.copyProperties((Object)invoiceVo, (Object)item);
            });
            auditVo.setAuditInvoices(auditInvoiceVos);
        }
    }

    @Transactional
    public AuditVo create(AuditDto auditDto) {
        auditDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditDto.setIsAutoAudit(BooleanEnum.FALSE.getCapital());
        String code = (String)this.generateCodeService.generateCode("HXSQ", 1).get(0);
        auditDto.setAuditCode(code);
        this.createValidate(auditDto);
        Audit audit = (Audit)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditDto, Audit.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        audit.setTenantCode(TenantUtils.getTenantCode());
        audit.setProcessStatus(ActApproveStatusEnum.CREATE.getCode());
        audit.setIsAutoAudit(BooleanEnum.FALSE.getCapital());
        this.auditRepository.saveOrUpdate((Object)audit);
        AuditVo auditVo = (AuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditVo.setId(audit.getId());
        auditDto.getAuditActivities().forEach(item -> item.setAuditCode(auditVo.getAuditCode()));
        auditDto.getAuditDetails().forEach(item -> {
            item.setAuditCode(auditVo.getAuditCode());
            item.setAuditDto(auditDto);
        });
        auditDto.getAuditFiles().forEach(item -> item.setAuditCode(auditVo.getAuditCode()));
        if (!CollectionUtils.isEmpty((Collection)auditDto.getAuditInvoices())) {
            auditDto.getAuditInvoices().forEach(item -> item.setAuditCode(auditVo.getAuditCode()));
        }
        List<AuditActivitiesVo> auditActivitiesVos = this.auditActivitiesService.createBatch(auditDto.getAuditActivities());
        auditVo.setAuditActivities(auditActivitiesVos);
        List<AuditDetailVo> auditDetailVos = this.auditDetailService.createBatch(auditDto.getAuditDetails());
        auditVo.setAuditDetails(auditDetailVos);
        BigDecimal totalAmount = auditVo.getTotalApplyAmount();
        BigDecimal currentTotalAuditAmount = auditDetailVos.stream().map(AuditDetailVo::getAuditAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((totalAmount.compareTo(currentTotalAuditAmount) == 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u6838\u9500\u8d39\u7528\u6c47\u603b\u91d1\u989d\u4e0e\u660e\u7ec6\u6838\u9500\u8d39\u7528\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        List<AuditFilesVo> auditFilesVos = this.auditFilesService.createBatch(auditDto.getAuditFiles());
        auditVo.setAuditFiles(auditFilesVos);
        List<AuditInvoiceVo> auditInvoiceVos = this.auditInvoiceService.createBatch(auditDto.getAuditInvoices());
        auditVo.setAuditInvoices(auditInvoiceVos);
        if (!CollectionUtils.isEmpty(this.auditEventListeners)) {
            for (AuditEventListener auditEventListener : this.auditEventListeners) {
                auditEventListener.onCreated(auditVo);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)auditDto.getProcessKey())) {
            auditDto.setId(audit.getId());
            auditDto.setAuditCode(audit.getAuditCode());
            audit.setProcessKey(auditDto.getProcessKey());
            audit.setProcessRemark(auditDto.getProcessRemark());
            audit.setProcessNumber(this.commitProcess(auditDto));
            audit.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
            this.auditRepository.saveOrUpdate((Object)audit);
            for (AuditDetailVo auditDetailVo : auditVo.getAuditDetails()) {
                BigDecimal excessAmount = auditDetailVo.getExcessAmount();
                if (excessAmount == null || excessAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(auditDetailVo.getActivitiesCode());
                ActivitiesDetailVo basicActivityItemVo = this.activitiesDetailService.findByActivitiesDetailCode(auditDetailVo.getActivitiesDetailCode());
                Validate.notNull((Object)basicActivityItemVo, (String)"\u6d3b\u52a8\u660e\u7ec6\u3010%s\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{auditDetailVo.getActivitiesDetailCode()});
                this.costBudgetVoService.occupy(auditDetailVo.getAuditCode(), auditDetailVo.getAuditDetailCode(), basicActivityItemVo.getCostBudgetCode(), excessAmount, activitiesVo.getActivityMark(), CostBudgetItemSourceType.AUDIT.getDescr());
            }
            if (!CollectionUtils.isEmpty(auditInvoiceVos)) {
                for (AuditInvoiceVo invoiceVo : auditInvoiceVos) {
                    InvoiceDetailDto detailDto = new InvoiceDetailDto();
                    detailDto.setInvoiceNo(invoiceVo.getInvoiceNo());
                    detailDto.setBusinessCode(audit.getAuditCode());
                    detailDto.setOperateAmount(invoiceVo.getUseAmount());
                    this.invoiceDeailService.occupy(detailDto);
                }
            }
        }
        AuditLogEventDto logEventDto = new AuditLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditVo);
        SerializableBiConsumer & Serializable onCreate = AuditLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditLogEventListener.class, (SerializableBiConsumer)onCreate);
        return auditVo;
    }

    public AuditVo creatForAutoAudit(AuditDto auditDto) {
        auditDto.setPrefix(this.preSave());
        auditDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditDto.setIsAutoAudit(BooleanEnum.TRUE.getCapital());
        String code = (String)this.generateCodeService.generateCode("HXSQ", 1).get(0);
        auditDto.setAuditCode(code);
        this.createValidate(auditDto);
        Audit audit = (Audit)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditDto, Audit.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        audit.setTenantCode(TenantUtils.getTenantCode());
        audit.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
        audit.setIsAutoAudit(BooleanEnum.TRUE.getCapital());
        this.auditRepository.saveOrUpdate((Object)audit);
        AuditVo auditVo = (AuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditVo.setId(audit.getId());
        auditDto.getAuditActivities().forEach(item -> item.setAuditCode(auditVo.getAuditCode()));
        auditDto.getAuditDetails().forEach(item -> {
            item.setAuditCode(auditVo.getAuditCode());
            item.setAuditDto(auditDto);
            item.setTenantCode(TenantUtils.getTenantCode());
        });
        List<AuditActivitiesVo> auditActivitiesVos = this.auditActivitiesService.createBatch(auditDto.getAuditActivities());
        auditVo.setAuditActivities(auditActivitiesVos);
        List<AuditDetailVo> auditDetailVos = this.auditDetailService.createBatch(auditDto.getAuditDetails());
        auditVo.setAuditDetails(auditDetailVos);
        BigDecimal totalApplyAmount = auditVo.getTotalApplyAmount();
        BigDecimal currentTotalAuditAmount = auditDetailVos.stream().map(AuditDetailVo::getAuditAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((totalApplyAmount.compareTo(currentTotalAuditAmount) == 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u8d39\u7528\u6c47\u603b\u91d1\u989d\u4e0e\u660e\u7ec6\u7533\u8bf7\u8d39\u7528\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.auditEventListeners)) {
            for (AuditEventListener auditEventListener : this.auditEventListeners) {
                auditEventListener.onCreated(auditVo);
            }
        }
        return auditVo;
    }

    @Transactional
    public AuditVo update(AuditDto auditDto) {
        this.updateValidate(auditDto);
        Audit audit = (Audit)((Object)this.auditRepository.getById((Serializable)((Object)auditDto.getId())));
        Validate.isTrue((StringUtils.isBlank((CharSequence)audit.getProcessStatus()) || ActApproveStatusEnum.CREATE.getCode().equals(audit.getProcessStatus()) || ActApproveStatusEnum.INTERRUPT.getCode().equals(audit.getProcessStatus()) || ActApproveStatusEnum.REJECTED.getCode().equals(audit.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u72b6\u6001\u4e3a\u3010\u5f85\u63d0\u4ea4\u3001\u6d41\u7a0b\u8ffd\u56de\u3001\u5ba1\u6279\u9a73\u56de\u3011\u8d39\u7528\u6838\u9500\u6570\u636e\u80fd\u4fee\u6539\uff0c\u3010%s\u3011\u8d39\u7528\u6838\u9500\u7533\u8bf7\u72b6\u6001\u4e3a\u3010%s\u3011", (Object[])new Object[]{audit.getAuditName(), ActApproveStatusEnum.getStatusName((String)audit.getProcessStatus())});
        AuditVo oldAuditVo = (AuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)audit), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        audit.setAuditName(auditDto.getAuditName());
        audit.setTotalApplyAmount(auditDto.getTotalApplyAmount());
        this.auditRepository.saveOrUpdate((Object)audit);
        AuditVo auditVo = (AuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditDto.getAuditActivities().forEach(item -> item.setAuditCode(auditVo.getAuditCode()));
        auditDto.getAuditDetails().forEach(item -> {
            item.setTenantCode(TenantUtils.getTenantCode());
            item.setAuditDto(auditDto);
            item.setAuditCode(auditDto.getAuditCode());
        });
        auditDto.getAuditFiles().forEach(item -> item.setAuditCode(auditVo.getAuditCode()));
        if (!CollectionUtils.isEmpty((Collection)auditDto.getAuditInvoices())) {
            auditDto.getAuditInvoices().forEach(item -> item.setAuditCode(auditVo.getAuditCode()));
        }
        this.auditActivitiesService.deleteByAuditCode(auditDto.getAuditCode());
        List<AuditActivitiesVo> auditActivitiesVos = this.auditActivitiesService.createBatch(auditDto.getAuditActivities());
        auditVo.setAuditActivities(auditActivitiesVos);
        this.auditDetailService.deleteByAuditCode(auditDto.getAuditCode());
        List<AuditDetailVo> auditDetailVos = this.auditDetailService.createBatch(auditDto.getAuditDetails());
        auditVo.setAuditDetails(auditDetailVos);
        this.auditFilesService.deleteByAuditCode(auditDto.getAuditCode());
        List<AuditFilesVo> auditFilesVos = this.auditFilesService.createBatch(auditDto.getAuditFiles());
        auditVo.setAuditFiles(auditFilesVos);
        this.auditInvoiceService.deleteByAuditCode(auditDto.getAuditCode());
        List<AuditInvoiceVo> auditInvoiceVos = this.auditInvoiceService.createBatch(auditDto.getAuditInvoices());
        auditVo.setAuditInvoices(auditInvoiceVos);
        if (!CollectionUtils.isEmpty(this.auditEventListeners)) {
            for (AuditEventListener auditEventListener : this.auditEventListeners) {
                auditEventListener.onUpdate(oldAuditVo, auditVo);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)auditDto.getProcessKey())) {
            auditDto.setId(audit.getId());
            auditDto.setAuditCode(audit.getAuditCode());
            audit.setProcessKey(auditDto.getProcessKey());
            audit.setProcessRemark(auditDto.getProcessRemark());
            audit.setProcessNumber(this.commitProcess(auditDto));
            audit.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
            this.auditRepository.saveOrUpdate((Object)audit);
            for (AuditDetailVo auditDetailVo : auditVo.getAuditDetails()) {
                BigDecimal excessAmount = auditDetailVo.getExcessAmount();
                if (excessAmount == null || excessAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(auditDetailVo.getActivitiesCode());
                ActivitiesDetailVo basicActivityItemVo = this.activitiesDetailService.findByActivitiesDetailCode(auditDetailVo.getActivitiesDetailCode());
                Validate.notNull((Object)basicActivityItemVo, (String)"\u6d3b\u52a8\u660e\u7ec6\u3010%s\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{auditDetailVo.getActivitiesDetailCode()});
                this.costBudgetVoService.occupy(auditDetailVo.getAuditCode(), auditDetailVo.getAuditDetailCode(), basicActivityItemVo.getCostBudgetCode(), excessAmount, activitiesVo.getActivityMark(), CostBudgetItemSourceType.AUDIT.getDescr());
            }
            if (!CollectionUtils.isEmpty(auditInvoiceVos)) {
                for (AuditInvoiceVo invoiceVo : auditInvoiceVos) {
                    InvoiceDetailDto detailDto = new InvoiceDetailDto();
                    detailDto.setInvoiceNo(invoiceVo.getInvoiceNo());
                    detailDto.setBusinessCode(audit.getAuditCode());
                    detailDto.setOperateAmount(invoiceVo.getUseAmount());
                    this.invoiceDeailService.occupy(detailDto);
                }
            }
        }
        AuditLogEventDto logEventDto = new AuditLogEventDto();
        logEventDto.setOriginal(oldAuditVo);
        logEventDto.setNewest(auditVo);
        SerializableBiConsumer & Serializable onUpdate = AuditLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return auditVo;
    }

    @Transactional
    public void updateProcessStatusByAuditCode(String auditCode, String processStatus) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)auditCode), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)processStatus), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditRepository.updateProcessStatusByAuditCode(auditCode, processStatus);
    }

    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Audit> audits = this.auditRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(audits)) {
            return;
        }
        audits.forEach(item -> Validate.isTrue((StringUtils.isBlank((CharSequence)item.getProcessStatus()) || ActApproveStatusEnum.CREATE.getCode().equals(item.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u3010\u5f85\u63d0\u4ea4\u3011\u8d39\u7528\u6838\u9500\u6570\u636e\u80fd\u5220\u9664\uff0c\u3010%s\u3011\u8d39\u7528\u6838\u9500\u7533\u8bf7\u72b6\u6001\u4e3a\u3010%s\u3011", (Object[])new Object[]{item.getAuditName(), ActApproveStatusEnum.getStatusName((String)item.getProcessStatus())}));
        Collection auditVos = this.nebulaToolkitService.copyCollectionByWhiteList(audits, Audit.class, AuditVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Set<String> delAuditCodes = audits.stream().map(Audit::getAuditCode).collect(Collectors.toSet());
        this.auditDetailService.deleteByAuditCodes(delAuditCodes);
        Set delIds = audits.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.auditRepository.removeByIds(delIds);
        if (!CollectionUtils.isEmpty(this.auditEventListeners)) {
            for (AuditEventListener auditEventListener : this.auditEventListeners) {
                for (AuditVo auditVo : auditVos) {
                    auditEventListener.onDeleted(auditVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDelete = AuditLogEventListener::onDelete;
        for (AuditVo auditVo : auditVos) {
            AuditLogEventDto logEventDto = new AuditLogEventDto();
            logEventDto.setOriginal(auditVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    public List<AuditVo> findByEnableStatus(String enableStatus) {
        if (StringUtils.isBlank((CharSequence)enableStatus)) {
            return Collections.emptyList();
        }
        List<Audit> audit = this.auditRepository.findByEnableStatus(enableStatus);
        if (CollectionUtils.isEmpty(audit)) {
            return Collections.emptyList();
        }
        Collection audits = this.nebulaToolkitService.copyCollectionByWhiteList(audit, Audit.class, AuditVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)audits);
    }

    @Transactional
    public void doRefund(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return;
        }
        AuditVo auditVo = this.findByCode(auditCode);
        if (auditVo != null && !CollectionUtils.isEmpty((Collection)auditVo.getAuditDetails())) {
            auditVo.getAuditDetails().forEach(item -> this.auditDetailService.doRefund(item.getAuditDetailCode()));
        }
    }

    @Transactional
    public void updateActivitiesAuditStatusByAuditCode(String auditCode) {
        List<AuditDetailVo> auditDetailVos = this.auditDetailService.findByAuditCode(auditCode);
        Set activitiesCodes = auditDetailVos.stream().filter(item -> BooleanEnum.TRUE.getCapital().equals(item.getIsFullAudit())).map(AuditDetailVo::getActivitiesCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return;
        }
        List activitiesVos = this.activitiesService.findDetailsByActivitiesCodes(activitiesCodes);
        for (ActivitiesVo activitiesVo : activitiesVos) {
            String activitiesCode = activitiesVo.getActivitiesCode();
            int dbWaitAuditDetailNum = activitiesVo.getWaitAuditDetailNum();
            int closedActivitiesDetailNum = this.activitiesDetailService.countByActivitiesCodeAndClosed(activitiesCode);
            int auditedDetailNum = 0;
            List activitiesDetailVos = this.activitiesDetailService.findByActivitiesCode(activitiesCode);
            for (ActivitiesDetailVo activitiesDetailVo : activitiesDetailVos) {
                AuditBillVo auditBillVo = this.auditBillService.findByActivitiesDetailCode(activitiesDetailVo.getActivitiesDetailCode());
                if (auditBillVo == null || !BooleanEnum.TRUE.getCapital().equals(auditBillVo.getIsFullAudit())) continue;
                ++auditedDetailNum;
            }
            if (dbWaitAuditDetailNum != auditedDetailNum + closedActivitiesDetailNum) continue;
            this.activitiesService.updateForAudit(activitiesCode);
        }
    }

    @Transactional
    public void updateActivitiesAuditStatusByActivitiesDetails(Collection<ActivitiesDetailVo> activitiesDetailVos) {
        if (CollectionUtils.isEmpty(activitiesDetailVos)) {
            return;
        }
        Map<String, List<ActivitiesDetailVo>> activitiesMap = activitiesDetailVos.stream().collect(Collectors.groupingBy(ActivitiesDetailVo::getActivitiesCode));
        Set<Map.Entry<String, List<ActivitiesDetailVo>>> entrySet = activitiesMap.entrySet();
        for (Map.Entry<String, List<ActivitiesDetailVo>> entry : entrySet) {
            String activitiesCode = entry.getKey();
            List<ActivitiesDetailVo> detailVos = entry.getValue();
            ActivitiesVo activitiesVo = this.activitiesService.findByActivitiesCode(activitiesCode);
            int detailNum = activitiesVo.getDetailNum();
            int dbWaitAuditDetailNum = activitiesVo.getWaitAuditDetailNum();
            int closedActivitiesDetailNum = this.activitiesDetailService.countByActivitiesCodeAndClosed(activitiesCode);
            int auditedDetailNum = 0;
            List byActivitiesCode = this.activitiesDetailService.findByActivitiesCode(activitiesCode);
            for (ActivitiesDetailVo activitiesDetailVo : byActivitiesCode) {
                AuditBillVo auditBillVo = this.auditBillService.findByActivitiesDetailCode(activitiesDetailVo.getActivitiesDetailCode());
                if (auditBillVo == null || !BooleanEnum.TRUE.getCapital().equals(auditBillVo.getIsFullAudit())) continue;
                ActivitiesDetailVo detailVo = this.activitiesDetailService.findByActivitiesDetailCode(activitiesDetailVo.getActivitiesDetailCode());
                if (BooleanEnum.TRUE.getCapital().equals(detailVo.getIsFullAudit())) {
                    this.activitiesDetailService.updateFullAuditByActivitiesDetailCode(activitiesDetailVo.getActivitiesDetailCode(), BooleanEnum.TRUE.getCapital());
                }
                ++auditedDetailNum;
            }
            if (detailNum == closedActivitiesDetailNum) {
                this.activitiesService.closeForAudit(activitiesCode);
            }
            if (auditedDetailNum == 0 || dbWaitAuditDetailNum != auditedDetailNum + closedActivitiesDetailNum) continue;
            this.activitiesService.updateForAudit(activitiesCode);
        }
    }

    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode("generate:prefix", prefix, prefix, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validationPrefix(AuditDto auditDto) {
        block5: {
            String prefix = auditDto.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode("generate:prefix", prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode("generate:prefix", prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
    }

    private void createValidate(AuditDto auditDto) {
        Validate.notNull((Object)auditDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        auditDto.setId(null);
        this.validationPrefix(auditDto);
        Validate.notBlank((CharSequence)auditDto.getAuditName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u7533\u8bf7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDto.getAuditCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u7533\u8bf7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditDto.getTotalApplyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u91d1\u989d\u6c47\u603b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Audit audit = this.auditRepository.findByCode(auditDto.getAuditCode());
        Validate.isTrue((audit == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7f16\u53f7\u91cd\u590d\u8bf7\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)auditDto.getAuditActivities(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)auditDto.getAuditDetails(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (auditDto.getAuditFiles() == null) {
            auditDto.setAuditFiles((List)Lists.newArrayList());
        }
    }

    private void updateValidate(AuditDto auditDto) {
        Validate.notNull((Object)auditDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validationPrefix(auditDto);
        Validate.notBlank((CharSequence)auditDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDto.getAuditName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u7533\u8bf7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDto.getAuditName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u7533\u8bf7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDto.getAuditCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u7533\u8bf7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditDto.getTotalApplyAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u91d1\u989d\u6c47\u603b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)auditDto.getAuditActivities(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)auditDto.getAuditDetails(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6838\u9500\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private String commitProcess(AuditDto dto) {
        List<AuditDetailVo> auditDetailVos = this.auditDetailService.findByAuditCode(dto.getAuditCode());
        auditDetailVos.forEach(item -> {
            ActivitiesDetailVo activitiesDetailVo = this.activitiesDetailService.findByActivitiesDetailCode(item.getActivitiesDetailCode());
            Validate.isTrue((!activitiesDetailVo.getIsClose().equals(BooleanEnum.TRUE.getCapital()) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u660e\u7ec6[%s]\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6838\u9500\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{activitiesDetailVo.getActivitiesDetailCode()});
        });
        StartProcessDto startProcessDto = new StartProcessDto();
        startProcessDto.setProcessKey(dto.getProcessKey());
        startProcessDto.setBusinessId(dto.getId());
        startProcessDto.setBusinessNo(dto.getAuditCode());
        startProcessDto.setRemark(dto.getProcessRemark());
        startProcessDto.setAttachmentVos(dto.getAttachmentVos());
        startProcessDto.setMenuCode(dto.getCompetenceCode());
        startProcessDto.setFormType("PAY_AUDIT");
        startProcessDto.setProcessTitle(dto.getProcessTitle());
        SerializableBiConsumer & Serializable sf = ProcessListener::onStartProcess;
        CommitWorkflowResponse response = (CommitWorkflowResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)startProcessDto, ProcessListener.class, (SerializableBiConsumer)sf);
        if (StringUtils.isNotEmpty((CharSequence)response.getProcessInstanceId())) {
            return response.getProcessInstanceId();
        }
        throw new RuntimeException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff01");
    }

    private String analysisSource(String value) {
        switch (value) {
            case "OrdinaryActivity": {
                return CostBudgetItemSourceType.ORDINARY_ACTIVITY.getDescr();
            }
            case "ProjectActivity": {
                return CostBudgetItemSourceType.PROJECT_ACTIVITY.getDescr();
            }
            case "SchemeActivity": {
                return CostBudgetItemSourceType.SCHEMA_ACTIVITY.getDescr();
            }
        }
        throw new IllegalArgumentException("\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u6765\u6e90\uff0c\u8bf7\u68c0\u67e5");
    }
}

