/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.pay.local.entity.InvoiceDetail;
import com.biz.crm.tpm.business.pay.local.repository.InvoiceDetailRepository;
import com.biz.crm.tpm.business.pay.sdk.dto.InvoiceDetailDto;
import com.biz.crm.tpm.business.pay.sdk.service.InvoiceDeailService;
import com.biz.crm.tpm.business.pay.sdk.service.InvoiceService;
import com.biz.crm.tpm.business.pay.sdk.vo.InvoiceDetailVo;
import com.biz.crm.tpm.business.pay.sdk.vo.InvoiceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceDeailServiceImpl
implements InvoiceDeailService {
    @Autowired
    private InvoiceDetailRepository invoiceDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private InvoiceService invoiceService;

    @Transactional
    public InvoiceDetailVo create(InvoiceDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInvoiceNo(), (String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessCode(), (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getBalance() == null ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u524d\u4f59\u989d\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.isTrue((dto.getFinalBalance() == null ? 1 : 0) != 0, (String)"\u6700\u7ec8\u53ef\u7528\u4f59\u989d\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperateAmount(), (String)"\u5f53\u524d\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getOperateAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((dto.getSortIndex() == null ? 1 : 0) != 0, (String)"\u6392\u5e8f\u503c\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getId()), (String)"\u53d1\u7968\u660e\u7ec6id\u4e3b\u952e\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        InvoiceDetail detail = (InvoiceDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, InvoiceDetail.class, HashSet.class, ArrayList.class, new String[0]));
        detail.setBalance(BigDecimal.ZERO);
        detail.setFinalBalance(dto.getOperateAmount());
        detail.setSortIndex(1);
        this.invoiceDetailRepository.save((Object)detail);
        return (InvoiceDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail, InvoiceDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<InvoiceDetailVo> findByInvoiceNo(String invoiceNo) {
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            return null;
        }
        List<InvoiceDetail> details = this.invoiceDetailRepository.findByInvoiceNo(invoiceNo);
        if (CollectionUtils.isEmpty(details)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(details, InvoiceDetail.class, InvoiceDetailVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public Map<String, List<InvoiceDetailVo>> findByInvoiceNos(Set<String> invoiceNos) {
        if (CollectionUtils.isEmpty(invoiceNos)) {
            return Maps.newHashMap();
        }
        List<InvoiceDetail> details = this.invoiceDetailRepository.findByInvoiceNos(invoiceNos);
        if (CollectionUtils.isEmpty(details)) {
            return Maps.newHashMap();
        }
        ArrayList detailVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(details, InvoiceDetail.class, InvoiceDetailVo.class, HashSet.class, ArrayList.class, new String[0]));
        return detailVos.stream().collect(Collectors.groupingBy(InvoiceDetailVo::getInvoiceNo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public InvoiceDetailVo occupy(InvoiceDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInvoiceNo(), (String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessCode(), (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getBalance() == null ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u524d\u4f59\u989d\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.isTrue((dto.getFinalBalance() == null ? 1 : 0) != 0, (String)"\u6700\u7ec8\u53ef\u7528\u4f59\u989d\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperateAmount(), (String)"\u5f53\u524d\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getOperateAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((dto.getSortIndex() == null ? 1 : 0) != 0, (String)"\u6392\u5e8f\u503c\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getId()), (String)"\u53d1\u7968\u660e\u7ec6id\u4e3b\u952e\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        InvoiceDetail entity = null;
        boolean hasLock = false;
        String redisLockKey = String.format("INVOICE_REDIS_LOCK_KEY:%s", dto.getInvoiceNo());
        try {
            hasLock = this.redisMutexService.tryLock(redisLockKey, TimeUnit.SECONDS, 20);
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            InvoiceVo invoiceVo = this.invoiceService.findByInvoiceNo(dto.getInvoiceNo());
            Validate.notNull((Object)invoiceVo, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u53d1\u7968\u53f7\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u53d1\u7968\u4fe1\u606f", (Object[])new Object[]{dto.getInvoiceNo()});
            Validate.isTrue((boolean)invoiceVo.getDelFlag().equals(DelFlagStatusEnum.NORMAL.getCode()), (String)"\u8be5\u53d1\u7968\u3010%s\u3011\u662f\u3010\u5df2\u5220\u9664\u3011\u72b6\u6001\uff0c\u672a\u80fd\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c", (Object[])new Object[]{dto.getInvoiceNo()});
            Validate.isTrue((boolean)invoiceVo.getEnableStatus().equals(EnableStatusEnum.ENABLE.getCode()), (String)"\u8be5\u53d1\u7968\u3010%s\u3011\u662f\u3010\u5df2\u7981\u7528\u3011\u72b6\u6001\uff0c\u672a\u80fd\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c", (Object[])new Object[]{dto.getInvoiceNo()});
            Validate.isTrue((invoiceVo.getFullUse() == null || invoiceVo.getFullUse() == false ? 1 : 0) != 0, (String)"\u8be5\u53d1\u7968\u3010%s\u3011\u53ef\u7528\u4f59\u989d\u4e3a0\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u5176\u4ed6\u4f7f\u7528\u64cd\u4f5c", (Object[])new Object[]{dto.getInvoiceNo()});
            List<InvoiceDetailVo> details = this.findByInvoiceNo(dto.getInvoiceNo());
            Validate.notEmpty(details, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u53d1\u7968\u53f7\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u53d1\u7968\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[]{dto.getInvoiceNo()});
            InvoiceDetailVo newestDetail = details.stream().max(Comparator.comparing(InvoiceDetailVo::getSortIndex)).orElse(null);
            Validate.notNull((Object)newestDetail, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u53d1\u7968\u53f7\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u6700\u65b0\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[]{dto.getInvoiceNo()});
            Validate.isTrue((newestDetail.getFinalBalance().compareTo(dto.getOperateAmount()) >= 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u53d1\u7968\u64cd\u4f5c\u7684\u91d1\u989d\u3010%s\u3011\u5927\u4e8e\u53ef\u7528\u4f59\u989d\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{dto.getOperateAmount().toString(), newestDetail.getFinalBalance().toString()});
            dto.setBalance(newestDetail.getFinalBalance());
            dto.setFinalBalance(newestDetail.getFinalBalance().subtract(dto.getOperateAmount()));
            dto.setSortIndex(Integer.valueOf(newestDetail.getSortIndex() + 1));
            entity = (InvoiceDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, InvoiceDetail.class, HashSet.class, ArrayList.class, new String[0]));
            this.invoiceDetailRepository.save((Object)entity);
            this.invoiceService.makeUsed(entity.getInvoiceNo(), dto.getOperateAmount(), Boolean.valueOf(true));
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock(redisLockKey);
            }
        }
        return (InvoiceDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, InvoiceDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public InvoiceDetailVo back(InvoiceDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInvoiceNo(), (String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessCode(), (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getBalance() == null ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u524d\u4f59\u989d\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.isTrue((dto.getFinalBalance() == null ? 1 : 0) != 0, (String)"\u6700\u7ec8\u53ef\u7528\u4f59\u989d\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperateAmount(), (String)"\u5f53\u524d\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getOperateAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((dto.getSortIndex() == null ? 1 : 0) != 0, (String)"\u6392\u5e8f\u503c\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getId()), (String)"\u53d1\u7968\u660e\u7ec6id\u4e3b\u952e\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        InvoiceDetail entity = null;
        boolean hasLock = false;
        String redisLockKey = String.format("INVOICE_REDIS_LOCK_KEY:%s", dto.getInvoiceNo());
        try {
            hasLock = this.redisMutexService.tryLock(redisLockKey, TimeUnit.SECONDS, 20);
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            InvoiceVo invoiceVo = this.invoiceService.findByInvoiceNo(dto.getInvoiceNo());
            Validate.notNull((Object)invoiceVo, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u53d1\u7968\u53f7\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u53d1\u7968\u4fe1\u606f", (Object[])new Object[]{dto.getInvoiceNo()});
            Validate.isTrue((boolean)invoiceVo.getDelFlag().equals(DelFlagStatusEnum.NORMAL.getCode()), (String)"\u8be5\u53d1\u7968\u3010%s\u3011\u662f\u3010\u5df2\u5220\u9664\u3011\u72b6\u6001\uff0c\u672a\u80fd\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c", (Object[])new Object[]{dto.getInvoiceNo()});
            Validate.isTrue((boolean)invoiceVo.getEnableStatus().equals(EnableStatusEnum.ENABLE.getCode()), (String)"\u8be5\u53d1\u7968\u3010%s\u3011\u662f\u3010\u5df2\u7981\u7528\u3011\u72b6\u6001\uff0c\u672a\u80fd\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c", (Object[])new Object[]{dto.getInvoiceNo()});
            List<InvoiceDetailVo> details = this.findByInvoiceNo(dto.getInvoiceNo());
            Validate.notEmpty(details, (String)"\u8be5\u53d1\u7968\u3010%s\u3011\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{invoiceVo.getInvoiceNo()});
            InvoiceDetailVo newestDetail = details.stream().max(Comparator.comparing(InvoiceDetailVo::getSortIndex)).orElse(null);
            Validate.notNull((Object)newestDetail, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u53d1\u7968\u53f7\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u6700\u65b0\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[]{dto.getInvoiceNo()});
            Validate.isTrue((invoiceVo.getPriceAndTax().compareTo(newestDetail.getFinalBalance().add(dto.getOperateAmount())) >= 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u53d1\u7968\u64cd\u4f5c\u7684\u91d1\u989d\u3010%s\u3011\u5927\u4e8e\u53ef\u64cd\u4f5c\u91d1\u989d\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{dto.getOperateAmount().toString(), invoiceVo.getPriceAndTax().subtract(newestDetail.getFinalBalance()).toString()});
            dto.setBalance(newestDetail.getFinalBalance());
            dto.setFinalBalance(newestDetail.getFinalBalance().add(dto.getOperateAmount()));
            dto.setSortIndex(Integer.valueOf(newestDetail.getSortIndex() + 1));
            entity = (InvoiceDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, InvoiceDetail.class, HashSet.class, ArrayList.class, new String[0]));
            this.invoiceDetailRepository.save((Object)entity);
            this.invoiceService.makeUsed(entity.getInvoiceNo(), dto.getOperateAmount(), Boolean.valueOf(false));
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock(redisLockKey);
            }
        }
        return (InvoiceDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, InvoiceDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

