/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.tpm.business.pay.local.entity.Invoice;
import com.biz.crm.tpm.business.pay.local.entity.InvoiceDetail;
import com.biz.crm.tpm.business.pay.local.repository.InvoiceDetailRepository;
import com.biz.crm.tpm.business.pay.local.repository.InvoiceRepository;
import com.biz.crm.tpm.business.pay.sdk.dto.InvoiceDetailDto;
import com.biz.crm.tpm.business.pay.sdk.dto.InvoiceDto;
import com.biz.crm.tpm.business.pay.sdk.dto.log.InvoiceLogEventDto;
import com.biz.crm.tpm.business.pay.sdk.enums.InvoiceType;
import com.biz.crm.tpm.business.pay.sdk.event.log.InvoiceLogEventListener;
import com.biz.crm.tpm.business.pay.sdk.service.InvoiceDeailService;
import com.biz.crm.tpm.business.pay.sdk.service.InvoiceService;
import com.biz.crm.tpm.business.pay.sdk.vo.InvoiceDetailVo;
import com.biz.crm.tpm.business.pay.sdk.vo.InvoiceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceServiceImpl
implements InvoiceService {
    private static final String PATTERN = "^[A-Za-z0-9]+$";
    @Autowired
    private InvoiceRepository invoiceRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private InvoiceDeailService invoiceDeailService;
    @Autowired
    private InvoiceDetailRepository invoiceDetailRepository;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<InvoiceVo> findByConditions(Pageable pageable, InvoiceDto dto) {
        Page<InvoiceVo> page;
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new InvoiceDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if ((page = this.invoiceRepository.findByConditions(pageable, dto)).getRecords().size() > 0) {
            Map detailsMap = this.invoiceDeailService.findByInvoiceNos(page.getRecords().stream().map(InvoiceVo::getInvoiceNo).collect(Collectors.toSet()));
            if (CollectionUtils.isEmpty((Map)detailsMap)) {
                return page;
            }
            for (InvoiceVo invoiceVo : page.getRecords()) {
                this.prefect(invoiceVo, (List)detailsMap.get(invoiceVo.getInvoiceNo()));
            }
        }
        return page;
    }

    @Transactional
    public InvoiceVo create(InvoiceDto dto) {
        this.createValidate(dto);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Invoice invoice = (Invoice)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Invoice.class, HashSet.class, ArrayList.class, new String[]{"file", "items"}));
        invoice.setFullUse(false);
        invoice.setHasUsed(false);
        this.invoiceRepository.save((Object)invoice);
        InvoiceVo invoiceVo = (InvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)invoice, InvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        InvoiceDetailDto detailDto = new InvoiceDetailDto();
        detailDto.setInvoiceNo(invoice.getInvoiceNo());
        detailDto.setOperateAmount(invoice.getPriceAndTax());
        detailDto.setTenantCode(invoice.getTenantCode());
        detailDto.setBusinessCode(invoice.getCode());
        this.invoiceDeailService.create(detailDto);
        InvoiceLogEventDto logEventDto = new InvoiceLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(invoiceVo);
        SerializableBiConsumer & Serializable onCreate = InvoiceLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InvoiceLogEventListener.class, (SerializableBiConsumer)onCreate);
        return invoiceVo;
    }

    @Transactional
    public InvoiceVo update(InvoiceDto dto) {
        InvoiceVo invoiceVo;
        this.updateValidate(dto);
        Invoice dbInvoice = (Invoice)((Object)this.invoiceRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)dbInvoice), (String)"\u6839\u636e\u53d1\u7968\u4e3b\u952eid\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        InvoiceVo oldInvoiceVo = (InvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbInvoice, InvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!StringUtils.equals((CharSequence)dto.getInvoiceNo(), (CharSequence)dbInvoice.getInvoiceNo())) {
            invoiceVo = this.findByInvoiceNo(dto.getInvoiceNo());
            Validate.isTrue((invoiceVo == null ? 1 : 0) != 0, (String)"\u53d1\u7968\u53f7\u7801\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{dto.getInvoiceNo()});
        }
        dbInvoice.setAmountWithoutTax(dto.getAmountWithoutTax());
        dbInvoice.setBillingDate(dto.getBillingDate());
        dbInvoice.setCheckCode(dto.getCheckCode());
        dbInvoice.setCode(dto.getCode());
        dbInvoice.setPAddressAndPhone(dto.getPAddressAndPhone());
        dbInvoice.setPBankAndAccount(dto.getPBankAndAccount());
        dbInvoice.setPNo(dto.getPNo());
        dbInvoice.setPriceAndTax(dto.getPriceAndTax());
        dbInvoice.setPurchaser(dto.getPurchaser());
        dbInvoice.setRemark(dto.getRemark());
        dbInvoice.setSAddressAndPhone(dto.getSAddressAndPhone());
        dbInvoice.setSBankAndAccount(dto.getSBankAndAccount());
        dbInvoice.setSeller(dto.getSeller());
        dbInvoice.setSNo(dto.getSNo());
        dbInvoice.setTaxAmount(dto.getTaxAmount());
        dbInvoice.setTaxRate(dto.getTaxRate());
        dbInvoice.setType(dto.getType());
        this.invoiceRepository.saveOrUpdate((Object)dbInvoice);
        invoiceVo = (InvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbInvoice, InvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<InvoiceDetail> details = this.invoiceDetailRepository.findByInvoiceNo(dbInvoice.getInvoiceNo());
        Validate.notEmpty(details, (String)"\u53d1\u7968\u53f7\u7801\u3010%s\u3011\uff0c\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{dbInvoice.getInvoiceNo()});
        Validate.isTrue((details.size() == 1 ? 1 : 0) != 0, (String)"\u53d1\u7968\u53f7\u7801\u3010%s\u3011\u5df2\u4ea7\u751f\u4f7f\u7528\u8bb0\u5f55\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91", (Object[])new Object[]{dbInvoice.getInvoiceNo()});
        InvoiceDetail detail = details.get(0);
        detail.setBalance(BigDecimal.ZERO);
        detail.setInvoiceNo(dbInvoice.getInvoiceNo());
        detail.setFinalBalance(dbInvoice.getPriceAndTax());
        detail.setOperateAmount(dbInvoice.getPriceAndTax());
        detail.setBusinessCode(dbInvoice.getCode());
        this.invoiceDetailRepository.saveOrUpdate((Object)detail);
        InvoiceLogEventDto logEventDto = new InvoiceLogEventDto();
        logEventDto.setOriginal(oldInvoiceVo);
        logEventDto.setNewest(invoiceVo);
        SerializableBiConsumer & Serializable onUpdate = InvoiceLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InvoiceLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return invoiceVo;
    }

    public List<InvoiceVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List invoices = this.invoiceRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return Lists.newArrayList();
        }
        ArrayList invoiceVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)invoices, Invoice.class, InvoiceVo.class, HashSet.class, ArrayList.class, new String[0]));
        Map detailsMap = this.invoiceDeailService.findByInvoiceNos(invoices.stream().map(Invoice::getInvoiceNo).collect(Collectors.toSet()));
        if (CollectionUtils.isEmpty((Map)detailsMap)) {
            return invoiceVos;
        }
        for (InvoiceVo invoiceVo : invoiceVos) {
            this.prefect(invoiceVo, (List)detailsMap.get(invoiceVo.getCode()));
        }
        return invoiceVos;
    }

    public InvoiceVo findByInvoiceNo(String invoiceNo) {
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            return null;
        }
        Invoice invoice = this.invoiceRepository.findByInvoiceNo(invoiceNo);
        if (invoice == null) {
            return null;
        }
        InvoiceVo invoiceVo = (InvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)invoice, InvoiceVo.class, HashSet.class, ArrayList.class, new String[0]);
        List detailVos = this.invoiceDeailService.findByInvoiceNo(invoiceNo);
        if (CollectionUtils.isEmpty((Collection)detailVos)) {
            return invoiceVo;
        }
        this.prefect(invoiceVo, detailVos);
        return invoiceVo;
    }

    public List<InvoiceVo> findByInvoiceNos(Set<String> invoiceNos) {
        if (CollectionUtils.isEmpty(invoiceNos)) {
            return Lists.newArrayList();
        }
        List<Invoice> invoices = this.invoiceRepository.findByInvoiceNos(invoiceNos);
        if (CollectionUtils.isEmpty(invoices)) {
            return Lists.newArrayList();
        }
        ArrayList invoiceVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(invoices, Invoice.class, InvoiceVo.class, HashSet.class, ArrayList.class, new String[0]));
        Map detailsMap = this.invoiceDeailService.findByInvoiceNos(invoiceNos);
        if (CollectionUtils.isEmpty((Map)detailsMap)) {
            return invoiceVos;
        }
        for (InvoiceVo invoiceVo : invoiceVos) {
            this.prefect(invoiceVo, (List)detailsMap.get(invoiceVo.getInvoiceNo()));
        }
        return invoiceVos;
    }

    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<InvoiceVo> invoiceVos = this.findByIds(Sets.newHashSet(idList));
        Validate.notEmpty(invoiceVos, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        this.invoiceRepository.delete(Sets.newHashSet(idList));
        SerializableBiConsumer & Serializable onDelete = InvoiceLogEventListener::onDelete;
        for (InvoiceVo invoiceVo : invoiceVos) {
            InvoiceLogEventDto logEventDto = new InvoiceLogEventDto();
            logEventDto.setOriginal(invoiceVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InvoiceLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional
    public void updateEnableStatus(Set<String> ids, String enableStatus) {
        Validate.notEmpty(ids, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)enableStatus, (String)"\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<InvoiceVo> invoiceVos = this.findByIds(ids);
        Validate.notEmpty(invoiceVos, (String)"\u6839\u636e\u6307\u5b9a\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.contains((String)enableStatus), (String)"\u672a\u77e5\u7684\u542f\u7981\u7528\u72b6\u6001", (Object[])new Object[0]);
        this.invoiceRepository.updateEnableStatus(invoiceVos.stream().map(UuidVo::getId).collect(Collectors.toSet()), enableStatus);
        if (EnableStatusEnum.ENABLE.getCode().equals(enableStatus)) {
            SerializableBiConsumer & Serializable onEnable = InvoiceLogEventListener::onEnable;
            for (InvoiceVo invoiceVo : invoiceVos) {
                InvoiceLogEventDto logEventDto = new InvoiceLogEventDto();
                logEventDto.setOriginal(invoiceVo);
                InvoiceVo newVo = (InvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)invoiceVo, InvoiceVo.class, HashSet.class, ArrayList.class, new String[0]);
                newVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                logEventDto.setNewest(newVo);
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InvoiceLogEventListener.class, (SerializableBiConsumer)onEnable);
            }
        } else {
            SerializableBiConsumer & Serializable onDisable = InvoiceLogEventListener::onDisable;
            for (InvoiceVo invoiceVo : invoiceVos) {
                InvoiceLogEventDto logEventDto = new InvoiceLogEventDto();
                logEventDto.setOriginal(invoiceVo);
                InvoiceVo newVo = (InvoiceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)invoiceVo, InvoiceVo.class, HashSet.class, ArrayList.class, new String[0]);
                newVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                logEventDto.setNewest(newVo);
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InvoiceLogEventListener.class, (SerializableBiConsumer)onDisable);
            }
        }
    }

    @Transactional
    public void makeUsed(String invoiceNo, BigDecimal operateAmount, Boolean occupy) {
        Validate.notBlank((CharSequence)invoiceNo, (String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operateAmount, (String)"\u53d1\u7968\u53ef\u4ee5\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)occupy, (String)"\u64cd\u4f5c\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0ctrue\u3010\u5360\u7528\u3011 false\u3010\u9000\u56de\u3011", (Object[])new Object[0]);
        Validate.isTrue((operateAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        InvoiceVo invoice = this.findByInvoiceNo(invoiceNo);
        Validate.notNull((Object)invoice, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u53d1\u7968\u53f7\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)invoice.getDelFlag().equals(DelFlagStatusEnum.NORMAL.getCode()), (String)"\u8be5\u53d1\u7968\u662f\u3010\u5df2\u5220\u9664\u3011\u72b6\u6001\uff0c\u672a\u80fd\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c", (Object[])new Object[0]);
        Validate.isTrue((boolean)invoice.getEnableStatus().equals(EnableStatusEnum.ENABLE.getCode()), (String)"\u8be5\u53d1\u7968\u662f\u3010\u5df2\u7981\u7528\u3011\u72b6\u6001\uff0c\u672a\u80fd\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c", (Object[])new Object[0]);
        List detailVos = this.invoiceDeailService.findByInvoiceNo(invoiceNo);
        Validate.notEmpty((Collection)detailVos, (String)"\u6839\u636e\u53d1\u7968\u53f7\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5173\u53d1\u7968\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[]{invoiceNo});
        InvoiceDetailVo newestDetail = detailVos.stream().max(Comparator.comparing(InvoiceDetailVo::getSortIndex)).orElse(null);
        Validate.notNull((Object)newestDetail, (String)"\u6839\u636e\u53d1\u7968\u53f7\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5173\u53d1\u7968\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[]{invoiceNo});
        Invoice entity = (Invoice)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)invoice, Invoice.class, HashSet.class, ArrayList.class, new String[0]));
        if (occupy.booleanValue()) {
            entity.setHasUsed(Boolean.TRUE);
        } else {
            entity.setHasUsed(invoice.getPriceAndTax().compareTo(newestDetail.getFinalBalance()) > 0);
        }
        entity.setFullUse(newestDetail.getFinalBalance().compareTo(BigDecimal.ZERO) == 0);
        this.invoiceRepository.saveOrUpdate((Object)entity);
    }

    private void createValidate(InvoiceDto dto) {
        this.validateBase(dto);
        this.validateType(dto);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getId()), (String)"\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        dto.setId(null);
        InvoiceVo dbInvoice = this.findByInvoiceNo(dto.getInvoiceNo());
        Validate.isTrue((dbInvoice == null ? 1 : 0) != 0, (String)"\u53d1\u7968\u53f7\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    private void updateValidate(InvoiceDto dto) {
        this.validateBase(dto);
        this.validateType(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4e3b\u952eid\u5fc5\u987b\u6709\u503c", (Object[])new Object[0]);
    }

    private void validateBase(InvoiceDto dto) {
        Validate.notNull((Object)dto, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getType(), (String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCode(), (String)"\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInvoiceNo(), (String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getPriceAndTax(), (String)"\u7a0e\u4ef7\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validatePattern(dto.getCode(), "\u53d1\u7968\u4ee3\u7801");
        this.validatePattern(dto.getInvoiceNo(), "\u53d1\u7968\u53d1\u7968\u53f7\u7801");
    }

    private void validateForVatGeneral(InvoiceDto dto) {
        Validate.notNull((Object)dto.getBillingDate(), (String)"\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCheckCode(), (String)"\u6821\u9a8c\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAmountWithoutTax(), (String)"\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getTaxRate(), (String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getTaxAmount(), (String)"\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal taxAmount = dto.getPriceAndTax().multiply(dto.getTaxRate()).multiply(new BigDecimal("0.01")).setScale(2, RoundingMode.HALF_UP);
        Validate.isTrue((taxAmount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u7a0e\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((dto.getTaxAmount().compareTo(taxAmount) == 0 ? 1 : 0) != 0, (String)"\u7a0e\u989d\u5fc5\u987b\u4e3a\u3010%s\u3011\u3010\u8ba1\u7b97\u516c\u5f0f\uff1a\u7a0e\u4ef7\u5408\u8ba1*\u7a0e\u7387*0.01\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{taxAmount.toString()});
        Validate.isTrue((dto.getTaxAmount().add(dto.getAmountWithoutTax()).compareTo(dto.getPriceAndTax()) == 0 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u6ee1\u8db3\u3010\u7a0e\u989d + \u4e0d\u542b\u7a0e\u91d1\u989d = \u7a0e\u4ef7\u5408\u8ba1\u91d1\u989d\u3011", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPurchaser(), (String)"\u8d2d\u4e70\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPNo(), (String)"\u8d2d\u4e70\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSeller(), (String)"\u9500\u552e\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSNo(), (String)"\u9500\u552e\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSBankAndAccount(), (String)"\u9500\u552e\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSAddressAndPhone(), (String)"\u9500\u552e\u65b9\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validatePattern(dto.getPNo(), "\u8d2d\u4e70\u65b9\u7a0e\u53f7");
        this.validatePattern(dto.getSNo(), "\u9500\u552e\u65b9\u7a0e\u53f7");
        Validate.isTrue((!StringUtils.equals((CharSequence)dto.getPNo(), (CharSequence)dto.getSNo()) ? 1 : 0) != 0, (String)"\u8d2d\u4e70\u65b9\u7a0e\u53f7\u4e0e\u9500\u552e\u65b9\u7a0e\u53f7\u4e0d\u80fd\u76f8\u540c", (Object[])new Object[0]);
    }

    private void validatePattern(String value, String descrName) {
        Validate.matchesPattern((CharSequence)value, (String)PATTERN, (String)"%s\u53ea\u80fd\u662f\u5b57\u6bcd\u548c\u6570\u5b57\u6784\u6210", (Object[])new Object[]{descrName});
    }

    private void validateType(InvoiceDto dto) {
        Validate.isTrue((boolean)InvoiceType.containsKey((String)dto.getType()), (String)"\u672a\u77e5\u7684\u53d1\u7968\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        InvoiceType invoiceType = InvoiceType.findByKey((String)dto.getType());
        Validate.notNull((Object)invoiceType, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u53d1\u7968\u7c7b\u578b\u3010%s\u3011\uff0c\u672a\u80fd\u627e\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{dto.getType()});
        switch (invoiceType) {
            case QUOTA: {
                break;
            }
            case VAT_GENERAL: {
                this.validateForVatGeneral(dto);
                break;
            }
            case VAT_SPECIAL: {
                this.validateForVatGeneral(dto);
                Validate.notBlank((CharSequence)dto.getPBankAndAccount(), (String)"\u8d2d\u4e70\u65b9\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)dto.getPAddressAndPhone(), (String)"\u8d2d\u4e70\u65b9\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u77e5\u7684\u53d1\u7968\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5");
            }
        }
    }

    private void prefect(InvoiceVo invoiceVo, List<InvoiceDetailVo> detailVos) {
        InvoiceDetailVo detailVo = detailVos.stream().max(Comparator.comparing(InvoiceDetailVo::getSortIndex)).orElse(null);
        if (detailVo == null) {
            return;
        }
        invoiceVo.setFinalBalance(detailVo.getFinalBalance());
        invoiceVo.setUsedAmount(invoiceVo.getPriceAndTax().subtract(invoiceVo.getFinalBalance()));
    }
}

