/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.biz.crm.tpm.business.pay.local.dto.PrepayBillRecordDto;
import com.biz.crm.tpm.business.pay.local.entity.PrepayBill;
import com.biz.crm.tpm.business.pay.local.repository.PrepayBillRepository;
import com.biz.crm.tpm.business.pay.local.service.PrepayBillRecordService;
import com.biz.crm.tpm.business.pay.local.service.PrepayBillService;
import com.biz.crm.tpm.business.pay.local.service.PrepayDetailService;
import com.biz.crm.tpm.business.pay.sdk.dto.PrepayBillDto;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayBillVo;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prepayBillService")
public class PrepayBillServiceImpl
implements PrepayBillService {
    @Autowired
    private PrepayBillRepository prepayBillRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private PrepayBillRecordService prepayBillRecordService;
    @Autowired
    private PrepayDetailService prepayDetailService;

    @Override
    public PrepayBillVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PrepayBill prepayBill = (PrepayBill)((Object)this.prepayBillRepository.getById((Serializable)((Object)id)));
        if (prepayBill == null) {
            return null;
        }
        PrepayBillVo prepayBillVo = (PrepayBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepayBill, PrepayBillVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return prepayBillVo;
    }

    @Override
    public PrepayBillVo findByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return null;
        }
        PrepayBill prepayBill = this.prepayBillRepository.findByActivitiesDetailCode(activitiesDetailCode);
        if (prepayBill == null) {
            return null;
        }
        PrepayBillVo prepayBillVo = (PrepayBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepayBill, PrepayBillVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return prepayBillVo;
    }

    @Override
    @Transactional
    public PrepayBillVo init(PrepayBillDto prepayBillDto) {
        Validate.notNull((Object)prepayBillDto.getApplyAmount(), (String)"\u521d\u59cb\u5316\u6570\u636e,\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)prepayBillDto.getActivitiesDetailCode(), (String)"\u521d\u59cb\u5316\u6570\u636e,\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        PrepayBillVo prepayBillVo = this.findByActivitiesDetailCode(prepayBillDto.getActivitiesDetailCode());
        if (prepayBillVo != null) {
            return prepayBillVo;
        }
        prepayBillDto.setId(null);
        prepayBillDto.setTenantCode(TenantUtils.getTenantCode());
        prepayBillDto.setPrepaidAmount(BigDecimal.ZERO);
        return this.create(prepayBillDto);
    }

    @Override
    @Transactional
    public PrepayBillVo create(PrepayBillDto prepayBillDto) {
        this.createValidate(prepayBillDto);
        PrepayBill prepayBill = (PrepayBill)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepayBillDto, PrepayBill.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        prepayBill.setTenantCode(TenantUtils.getTenantCode());
        this.prepayBillRepository.saveOrUpdate((Object)prepayBill);
        PrepayBillVo prepayBillVo = (PrepayBillVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepayBill, PrepayBillVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        prepayBillVo.setId(prepayBill.getId());
        return prepayBillVo;
    }

    @Override
    public void prepayAmountByPrepayCode(String prepayCode) {
        List<PrepayDetailVo> prepayDetailVos = this.prepayDetailService.findByPrepayCode(prepayCode);
        for (PrepayDetailVo prepayDetailVo : prepayDetailVos) {
            this.prepayAmountByActivityDetailCode(prepayDetailVo.getActivitiesDetailCode(), prepayDetailVo.getPrepayDetailCode(), prepayDetailVo.getPrepayAmount());
        }
    }

    @Override
    public void backPrepayAmountByPrepayCode(String prepayCode) {
        List<PrepayDetailVo> prepayDetailVos = this.prepayDetailService.findByPrepayCode(prepayCode);
        for (PrepayDetailVo prepayDetailVo : prepayDetailVos) {
            this.backPrepayAmountByActivityDetailCode(prepayDetailVo.getActivitiesDetailCode(), prepayDetailVo.getPrepayDetailCode(), prepayDetailVo.getPrepayAmount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepayAmountByActivityDetailCode(String activitiesDetailCode, String auditDetailCode, BigDecimal amount) {
        Validate.notBlank((CharSequence)activitiesDetailCode, (String)"\u66f4\u6539\u5df2\u6838\u9500\u91d1\u989d\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String lockKey = String.format("bz:crm:tpm:audit:lock:%s:%s", tenantCode, activitiesDetailCode);
        boolean isLock = false;
        try {
            isLock = this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, 10);
            Validate.isTrue((boolean)isLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            this.prepayBillRepository.addPreparedAmount(activitiesDetailCode, amount);
            PrepayBillRecordDto prepayBillRecordDto = new PrepayBillRecordDto();
            prepayBillRecordDto.setTenantCode(TenantUtils.getTenantCode());
            prepayBillRecordDto.setActivitiesDetailCode(activitiesDetailCode);
            prepayBillRecordDto.setBusinessCode(auditDetailCode);
            prepayBillRecordDto.setChangeAmount(amount);
            prepayBillRecordDto.setType(1);
            this.prepayBillRecordService.create(prepayBillRecordDto);
        }
        finally {
            if (isLock) {
                this.redisMutexService.unlock(lockKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backPrepayAmountByActivityDetailCode(String activitiesDetailCode, String auditDetailCode, BigDecimal amount) {
        Validate.notBlank((CharSequence)activitiesDetailCode, (String)"\u66f4\u6539\u5df2\u6838\u9500\u91d1\u989d\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String lockKey = String.format("bz:crm:tpm:audit:lock:%s:%s", tenantCode, activitiesDetailCode);
        boolean isLock = false;
        try {
            isLock = this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, 10);
            Validate.isTrue((boolean)isLock, (String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            this.prepayBillRepository.reducePreparedAmount(activitiesDetailCode, amount);
            PrepayBillRecordDto prepayBillRecordDto = new PrepayBillRecordDto();
            prepayBillRecordDto.setTenantCode(TenantUtils.getTenantCode());
            prepayBillRecordDto.setActivitiesDetailCode(activitiesDetailCode);
            prepayBillRecordDto.setBusinessCode(auditDetailCode);
            prepayBillRecordDto.setChangeAmount(amount);
            prepayBillRecordDto.setType(2);
            this.prepayBillRecordService.create(prepayBillRecordDto);
        }
        finally {
            if (isLock) {
                this.redisMutexService.unlock(lockKey);
            }
        }
    }

    private void createValidate(PrepayBillDto prepayBillDto) {
        Validate.notNull((Object)prepayBillDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((prepayBillDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)prepayBillDto.getApplyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)prepayBillDto.getPrepaidAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5df2\u9884\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

