/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.pay.local.entity.PrepayDetail;
import com.biz.crm.tpm.business.pay.local.repository.PrepayDetailRepository;
import com.biz.crm.tpm.business.pay.local.service.PrepayBillService;
import com.biz.crm.tpm.business.pay.local.service.PrepayDetailService;
import com.biz.crm.tpm.business.pay.sdk.dto.PrepayBillDto;
import com.biz.crm.tpm.business.pay.sdk.dto.PrepayDetailDto;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayBillVo;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="prepayDetailService")
public class PrepayDetailServiceImpl
implements PrepayDetailService {
    @Autowired
    private PrepayDetailRepository prepayDetailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PrepayBillService prepayBillService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<PrepayDetailVo> findByConditions(Pageable pageable, PrepayDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new PrepayDetailDto();
        }
        return this.prepayDetailRepository.findByConditions(pageable, dto);
    }

    @Override
    public PrepayDetailVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PrepayDetail prepayDetail = (PrepayDetail)((Object)this.prepayDetailRepository.getById((Serializable)((Object)id)));
        if (prepayDetail == null) {
            return null;
        }
        PrepayDetailVo prepayDetailVo = (PrepayDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepayDetail, PrepayDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.fillDetail(prepayDetailVo);
        return prepayDetailVo;
    }

    @Override
    public List<PrepayDetailVo> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<PrepayDetail> prepayDetails = this.prepayDetailRepository.findByIds(ids);
        Collection prepayDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(prepayDetails, PrepayDetail.class, PrepayDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        prepayDetailVos.forEach(this::fillDetail);
        return Lists.newArrayList((Iterable)prepayDetailVos);
    }

    @Override
    public List<PrepayDetailVo> findByPrepayCode(String prepayCode) {
        if (StringUtils.isBlank((CharSequence)prepayCode)) {
            return Collections.emptyList();
        }
        List<PrepayDetail> prepayDetails = this.prepayDetailRepository.findByPrepayCode(prepayCode);
        if (CollectionUtils.isEmpty(prepayDetails)) {
            return Collections.emptyList();
        }
        Collection prepayDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(prepayDetails, PrepayDetail.class, PrepayDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        prepayDetailVos.forEach(this::fillDetail);
        return Lists.newArrayList((Iterable)prepayDetailVos);
    }

    private void fillDetail(PrepayDetailVo prepayDetailVo) {
        PrepayBillVo prepayBillVo = this.prepayBillService.findByActivitiesDetailCode(prepayDetailVo.getActivitiesDetailCode());
        prepayDetailVo.setPrepaidAmount(prepayBillVo.getPrepaidAmount());
    }

    @Override
    @Transactional
    public PrepayDetailVo create(PrepayDetailDto prepayDetailDto) {
        prepayDetailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        String code = (String)this.generateCodeService.generateCode("YFMX", 1).get(0);
        prepayDetailDto.setPrepayDetailCode(code);
        prepayDetailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.createValidate(prepayDetailDto);
        PrepayDetail prepayDetail = (PrepayDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepayDetailDto, PrepayDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        prepayDetail.setTenantCode(TenantUtils.getTenantCode());
        this.prepayDetailRepository.saveOrUpdate((Object)prepayDetail);
        PrepayDetailVo prepayDetailVo = (PrepayDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepayDetail, PrepayDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        prepayDetailVo.setId(prepayDetail.getId());
        PrepayBillDto prepayBillDto = new PrepayBillDto();
        prepayBillDto.setApplyAmount(prepayDetailVo.getApplyAmount());
        prepayBillDto.setActivitiesDetailCode(prepayDetailVo.getActivitiesDetailCode());
        prepayBillDto.setPrepaidAmount(BigDecimal.ZERO);
        this.prepayBillService.init(prepayBillDto);
        return prepayDetailVo;
    }

    @Override
    @Transactional
    public List<PrepayDetailVo> createBatch(Collection<PrepayDetailDto> prepayDetailDtos) {
        if (CollectionUtils.isEmpty(prepayDetailDtos)) {
            return Lists.newArrayList();
        }
        ArrayList prepayDetailVos = Lists.newArrayList();
        for (PrepayDetailDto prepayDetailDto : prepayDetailDtos) {
            PrepayDetailVo prepayDetailVo = this.create(prepayDetailDto);
            prepayDetailVos.add(prepayDetailVo);
        }
        return prepayDetailVos;
    }

    @Override
    @Transactional
    public PrepayDetailVo update(PrepayDetailDto prepayDetailDto) {
        this.updateValidate(prepayDetailDto);
        PrepayDetail prepayDetail = (PrepayDetail)((Object)this.prepayDetailRepository.getById((Serializable)((Object)prepayDetailDto.getId())));
        Validate.notNull((Object)((Object)prepayDetail), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        prepayDetail.setPrepayAmount(prepayDetailDto.getPrepayAmount());
        prepayDetail.setPayBy(prepayDetailDto.getPayBy());
        prepayDetail.setReason(prepayDetailDto.getReason());
        prepayDetail.setPayer(prepayDetailDto.getPayer());
        prepayDetail.setPayerAccount(prepayDetailDto.getPayerAccount());
        prepayDetail.setPayee(prepayDetailDto.getPayee());
        prepayDetail.setPayeeAccount(prepayDetailDto.getPayeeAccount());
        prepayDetail.setCostTypeDetailCode(prepayDetailDto.getCostTypeDetailCode());
        prepayDetail.setCostTypeDetailName(prepayDetailDto.getCostTypeDetailName());
        prepayDetail.setCustomerName(prepayDetailDto.getCustomerName());
        prepayDetail.setCustomerCode(prepayDetailDto.getCustomerCode());
        prepayDetail.setTerminalName(prepayDetailDto.getTerminalName());
        prepayDetail.setTerminalCode(prepayDetailDto.getTerminalCode());
        this.prepayDetailRepository.saveOrUpdate((Object)prepayDetail);
        PrepayDetailVo prepayDetailVo = (PrepayDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepayDetail, PrepayDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return prepayDetailVo;
    }

    @Override
    @Transactional
    public List<PrepayDetailVo> updateBatch(Collection<PrepayDetailDto> prepayDetailDtos) {
        Set currentIds;
        if (CollectionUtils.isEmpty(prepayDetailDtos)) {
            return Collections.emptyList();
        }
        String code = prepayDetailDtos.stream().findFirst().get().getPrepayCode();
        List<PrepayDetailVo> dbPrepayDetailVos = this.findByPrepayCode(code);
        Set dbIds = dbPrepayDetailVos.stream().map(PrepayDetailVo::getId).collect(Collectors.toSet());
        Sets.SetView delData = Sets.difference(dbIds, currentIds = prepayDetailDtos.stream().map(PrepayDetailDto::getId).collect(Collectors.toSet()));
        if (!CollectionUtils.isEmpty((Collection)delData)) {
            this.delete((Collection<String>)delData);
        }
        List<PrepayDetailDto> addDtos = prepayDetailDtos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<PrepayDetailDto> updateDtos = prepayDetailDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).collect(Collectors.toList());
        List<PrepayDetailVo> prepayDetailVos = this.createBatch(addDtos);
        if (!CollectionUtils.isEmpty(updateDtos)) {
            updateDtos.forEach(item -> prepayDetailVos.add(this.update((PrepayDetailDto)item)));
        }
        return prepayDetailVos;
    }

    @Override
    @Transactional
    public void delete(Collection<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<PrepayDetail> prepayDetails = this.prepayDetailRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(prepayDetails)) {
            return;
        }
        Collection prepayDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(prepayDetails, PrepayDetail.class, PrepayDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.prepayDetailRepository.removeByIds(ids);
    }

    private void createValidate(PrepayDetailDto prepayDetailDto) {
        Validate.notNull((Object)prepayDetailDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((prepayDetailDto.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6,\u6570\u636e\u4e3b\u952e\u4e0d\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDetailDto.getPrepayCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u4ed8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)prepayDetailDto.getApplyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDetailDto.getActivitiesDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)prepayDetailDto.getPrepayAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDetailDto.getPayBy(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDetailDto.getCostTypeDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDetailDto.getCostTypeDetailName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        PrepayBillVo prepayBillVo = this.prepayBillService.findByActivitiesDetailCode(prepayDetailDto.getActivitiesDetailCode());
        BigDecimal prepayAmount = prepayDetailDto.getPrepayAmount();
        BigDecimal applyAmount = prepayDetailDto.getApplyAmount();
        BigDecimal preparedAmount = BigDecimal.ZERO;
        if (prepayBillVo != null) {
            preparedAmount = prepayBillVo.getPrepaidAmount();
        }
        Validate.isTrue((applyAmount.compareTo(prepayAmount.add(preparedAmount)) >= 0 ? 1 : 0) != 0, (String)"\u9884\u4ed8\u91d1\u989d\u4e0e\u5df2\u9884\u4ed8\u91d1\u989d\u4e0d\u80fd\u8d85\u51fa\u7533\u8bf7\u91d1\u989d", (Object[])new Object[0]);
    }

    private void updateValidate(PrepayDetailDto prepayDetailDto) {
        Validate.notNull((Object)prepayDetailDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDetailDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)prepayDetailDto.getPrepayAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDetailDto.getPayBy(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDetailDto.getCostTypeDetailCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prepayDetailDto.getCostTypeDetailName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        PrepayBillVo prepayBillVo = this.prepayBillService.findByActivitiesDetailCode(prepayDetailDto.getActivitiesDetailCode());
        BigDecimal prepayAmount = prepayDetailDto.getPrepayAmount();
        BigDecimal applyAmount = prepayDetailDto.getApplyAmount();
        BigDecimal preparedAmount = BigDecimal.ZERO;
        if (prepayBillVo != null) {
            preparedAmount = prepayBillVo.getPrepaidAmount();
        }
        Validate.isTrue((applyAmount.compareTo(prepayAmount.add(preparedAmount)) >= 0 ? 1 : 0) != 0, (String)"\u9884\u4ed8\u91d1\u989d\u4e0e\u5df2\u9884\u4ed8\u91d1\u989d\u4e0d\u80fd\u8d85\u51fa\u7533\u8bf7\u91d1\u989d", (Object[])new Object[0]);
    }
}

