/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.pay.local.entity.Account;
import com.biz.crm.tpm.business.pay.local.entity.WithHolding;
import com.biz.crm.tpm.business.pay.local.repository.WithHoldingRepository;
import com.biz.crm.tpm.business.pay.local.service.AccountService;
import com.biz.crm.tpm.business.pay.local.service.WithHoldingService;
import com.biz.crm.tpm.business.pay.local.service.WithHoldingVoService;
import com.biz.crm.tpm.business.pay.sdk.dto.WithHoldingDto;
import com.biz.crm.tpm.business.pay.sdk.dto.log.WithHoldingLogEventDto;
import com.biz.crm.tpm.business.pay.sdk.enums.WithHoldingTypeEnum;
import com.biz.crm.tpm.business.pay.sdk.event.log.WithHoldingLogEventListener;
import com.biz.crm.tpm.business.pay.sdk.vo.WithHoldingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="WithHoldingService")
public class WithHoldingServiceImpl
implements WithHoldingService {
    @Autowired
    private WithHoldingRepository WithHoldingRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AccountService accountService;
    @Autowired(required=false)
    private WithHoldingVoService withHoldingVoService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ActivitiesService activitiesService;
    @Autowired(required=false)
    private WithHoldingLogEventListener withHoldingLogEventListener;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<WithHolding> findByConditions(Pageable pageable, WithHoldingDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new WithHoldingDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.WithHoldingRepository.findByConditions(pageable, dto);
    }

    @Override
    public WithHolding findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (WithHolding)((Object)this.WithHoldingRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public void create(List<WithHolding> withHoldings) {
        Validate.notEmpty(withHoldings, (String)"\u65b0\u589e\u6570\u636e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (WithHolding withHolding : withHoldings) {
            this.createValidate(withHolding);
        }
        this.amountValidate(withHoldings);
        List<String> codes = withHoldings.stream().map(WithHolding::getActivitiesDetailCode).collect(Collectors.toList());
        List<WithHolding> dbList = this.findByActivitiesDetailCodes(codes);
        if (CollectionUtils.isEmpty(dbList)) {
            String ruleCode = StringUtils.join((Object[])new String[]{"YT", DateFormatUtils.format((Date)new Date(), (String)"yyyyMM")});
            List codeList = this.generateCodeService.generateCode(ruleCode, withHoldings.size(), Integer.valueOf(6), 2L, TimeUnit.DAYS);
            for (int i = 0; i < withHoldings.size(); ++i) {
                WithHolding withHolding = withHoldings.get(i);
                withHolding.setWithHoldingCode((String)codeList.get(i));
                Validate.notNull((Object)withHolding.getWithHoldingCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u63d0\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
            this.WithHoldingRepository.saveBatch(withHoldings);
            SerializableBiConsumer & Serializable onCreate = WithHoldingLogEventListener::onCreate;
            Collection withHoldingVos = this.nebulaToolkitService.copyCollectionByWhiteList(withHoldings, WithHolding.class, WithHoldingVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (WithHoldingVo withHolding : withHoldingVos) {
                WithHoldingLogEventDto dto = new WithHoldingLogEventDto();
                dto.setOriginal(null);
                dto.setNewest(withHolding);
                this.nebulaNetEventClient.publish((NebulaEventDto)dto, WithHoldingLogEventListener.class, (SerializableBiConsumer)onCreate);
            }
        } else {
            WithHolding withHolding;
            Map<String, WithHolding> dbMap = dbList.stream().collect(Collectors.toMap(WithHolding::getActivitiesDetailCode, e -> e));
            List copyDbList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dbList, WithHolding.class, WithHolding.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, WithHolding> copyDbMap = copyDbList.stream().collect(Collectors.toMap(WithHolding::getActivitiesDetailCode, e -> e));
            ArrayList<WithHolding> createList = new ArrayList<WithHolding>();
            ArrayList<WithHolding> updateList = new ArrayList<WithHolding>();
            for (WithHolding entity : withHoldings) {
                String activitiesDetailCode = entity.getActivitiesDetailCode();
                withHolding = dbMap.get(activitiesDetailCode);
                if (Objects.isNull((Object)withHolding)) {
                    createList.add(entity);
                    continue;
                }
                withHolding.setWithHoldingAmount(entity.getWithHoldingAmount());
                updateList.add(withHolding);
            }
            String ruleCode = StringUtils.join((Object[])new String[]{"YT", DateFormatUtils.format((Date)new Date(), (String)"yyyyMM")});
            List codeList = this.generateCodeService.generateCode(ruleCode, createList.size(), Integer.valueOf(6), 2L, TimeUnit.DAYS);
            for (int i = 0; i < createList.size(); ++i) {
                withHolding = (WithHolding)((Object)createList.get(i));
                withHolding.setWithHoldingCode((String)codeList.get(i));
                Validate.notNull((Object)withHolding.getWithHoldingCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u63d0\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
            this.WithHoldingRepository.saveBatch(createList);
            this.WithHoldingRepository.updateBatchById(updateList);
            SerializableBiConsumer & Serializable onCreate = WithHoldingLogEventListener::onCreate;
            Collection withHoldingVos = this.nebulaToolkitService.copyCollectionByWhiteList(createList, WithHolding.class, WithHoldingVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (WithHoldingVo withHolding2 : withHoldingVos) {
                WithHoldingLogEventDto dto = new WithHoldingLogEventDto();
                dto.setOriginal(null);
                dto.setNewest(withHolding2);
                this.nebulaNetEventClient.publish((NebulaEventDto)dto, WithHoldingLogEventListener.class, (SerializableBiConsumer)onCreate);
            }
            SerializableBiConsumer & Serializable onUpdate = WithHoldingLogEventListener::onUpdate;
            Collection updateVos = this.nebulaToolkitService.copyCollectionByWhiteList(updateList, WithHolding.class, WithHoldingVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (WithHoldingVo vo : updateVos) {
                WithHolding withHolding3 = copyDbMap.get(vo.getActivitiesDetailCode());
                WithHoldingLogEventDto dto = new WithHoldingLogEventDto();
                WithHoldingVo newVO = new WithHoldingVo();
                WithHoldingVo oldVO = new WithHoldingVo();
                oldVO.setId(withHolding3.getId());
                oldVO.setWithHoldingAmount(withHolding3.getWithHoldingAmount());
                newVO.setId(withHolding3.getId());
                newVO.setWithHoldingAmount(vo.getWithHoldingAmount());
                dto.setNewest(newVO);
                dto.setOriginal(oldVO);
                this.nebulaNetEventClient.publish((NebulaEventDto)dto, WithHoldingLogEventListener.class, (SerializableBiConsumer)onUpdate);
            }
        }
    }

    @Override
    @Transactional
    public WithHolding update(WithHolding withHolding) {
        this.updateValidate(withHolding);
        WithHolding entity = this.findById(withHolding.getId());
        BigDecimal oldAmount = entity.getWithHoldingAmount();
        entity.setWithHoldingAmount(withHolding.getWithHoldingAmount());
        this.amountValidate(entity);
        this.WithHoldingRepository.saveOrUpdate((Object)entity);
        SerializableBiConsumer & Serializable onUpdate = WithHoldingLogEventListener::onUpdate;
        WithHoldingLogEventDto dto = new WithHoldingLogEventDto();
        WithHoldingVo newVO = new WithHoldingVo();
        WithHoldingVo oldVO = new WithHoldingVo();
        oldVO.setId(entity.getId());
        oldVO.setWithHoldingAmount(oldAmount);
        newVO.setId(entity.getId());
        newVO.setWithHoldingAmount(entity.getWithHoldingAmount());
        dto.setNewest(newVO);
        dto.setOriginal(oldVO);
        this.nebulaNetEventClient.publish((NebulaEventDto)dto, WithHoldingLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return withHolding;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.WithHoldingRepository.delete(idList);
    }

    @Override
    public void push(List<String> idList) {
    }

    @Override
    public void handleManual(List<WithHoldingDto> withHoldings) {
        Validate.notEmpty(withHoldings, (String)"\u65b0\u589e\u8d39\u7528\u9884\u63d0\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(withHoldings, WithHoldingDto.class, WithHolding.class, HashSet.class, ArrayList.class, new String[0]);
        for (WithHolding withHolding : list) {
            withHolding.setWithHoldingType(WithHoldingTypeEnum.HANDLE.getDictCode());
        }
        this.create(list);
    }

    @Override
    public void handleAuto(WithHoldingDto withHolding) {
        Date withHoldingYears = withHolding.getWithHoldingYears();
        Validate.notNull((Object)withHolding, (String)"\u9884\u63d0\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date date = new Date();
        GregorianCalendar begin = new GregorianCalendar();
        begin.setTime(date);
        ((Calendar)begin).add(2, 0);
        begin.set(5, 1);
        Validate.isTrue((withHoldingYears.compareTo(date) <= 0 ? 1 : 0) != 0, (String)"\u6240\u9009\u9884\u63d0\u5e74\u6708\u5fc5\u987b\u4e3a\u5f53\u6708\u4e4b\u524d\u7684\u5e74\u6708\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String format = sdf.format(withHoldingYears);
        List codeByTime = this.activitiesService.findCodeByTime(format);
        Validate.notEmpty((Collection)codeByTime, (String)"\u6240\u9009\u5e74\u6708\u65e0\u6d3b\u52a8\u4fe1\u606f", (Object[])new Object[0]);
        List<WithHoldingVo> withHoldingVos = this.withHoldingVoService.findActivitiesByConditions(codeByTime);
        Validate.notEmpty(withHoldingVos, (String)"\u6240\u9009\u6708\u4efd\u65e0\u6d3b\u52a8\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        for (WithHoldingVo holding : withHoldingVos) {
            holding.setWithHoldingYears(withHoldingYears);
            holding.setWithHoldingAmount(holding.getApplyAmount().subtract(holding.getAccountAmount()));
            holding.setWithHoldingType(WithHoldingTypeEnum.AUTO.getDictCode());
            holding.setPayBy(holding.getPayType());
            holding.setPayByName(holding.getPayTypeName());
        }
        List withHoldings = (List)this.nebulaToolkitService.copyCollectionByWhiteList(withHoldingVos, WithHoldingVo.class, WithHolding.class, HashSet.class, ArrayList.class, new String[0]);
        this.create(withHoldings);
    }

    @Override
    public List<WithHolding> findByActivitiesDetailCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<WithHolding>(0);
        }
        return this.WithHoldingRepository.findByActivitiesDetailCodes(codes);
    }

    private void createValidate(WithHolding withHolding) {
        Validate.notNull((Object)((Object)withHolding), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        withHolding.setId(null);
        withHolding.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        withHolding.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        withHolding.setTenantCode(TenantUtils.getTenantCode());
        Validate.notNull((Object)withHolding.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)withHolding.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)withHolding.getApplyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)withHolding.getBudgetSubjectsCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u79d1\u76ee\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)withHolding.getCostTypeCategoryCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)withHolding.getCostTypeDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)withHolding.getWithHoldingAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u63d0\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(WithHolding withHolding) {
        Validate.notNull((Object)((Object)withHolding), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)withHolding.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)withHolding.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)withHolding.getActivitiesCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)withHolding.getApplyAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)withHolding.getBudgetSubjectsCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u7b97\u79d1\u76ee\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)withHolding.getCostTypeCategoryCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)withHolding.getCostTypeDetailCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)withHolding.getWithHoldingAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u63d0\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)withHolding.getWithHoldingCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u63d0\u7f16\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.amountValidate(withHolding);
    }

    private void amountValidate(WithHolding withHolding) {
        BigDecimal withHoldingAmount = withHolding.getWithHoldingAmount();
        BigDecimal applyAmount = withHolding.getApplyAmount();
        String activitiesDetailCode = withHolding.getActivitiesDetailCode();
        List<Account> byActivitiesDetailCode = this.accountService.findByActivitiesDetailCode(Lists.newArrayList((Object[])new String[]{activitiesDetailCode}));
        if (CollectionUtils.isEmpty(byActivitiesDetailCode)) {
            Validate.isTrue((applyAmount.compareTo(withHoldingAmount) >= 0 ? 1 : 0) != 0, (String)"\u9884\u63d0\u91d1\u989d\u8d85\u51fa\u7533\u8bf7\u91d1\u989d", (Object[])new Object[0]);
            return;
        }
        BigDecimal amount = byActivitiesDetailCode.stream().map(Account::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal availableAmount = applyAmount.subtract(amount);
        Validate.isTrue((availableAmount.compareTo(withHoldingAmount) >= 0 ? 1 : 0) != 0, (String)"\u9884\u63d0\u91d1\u989d\u8d85\u51fa\u7533\u8bf7\u91d1\u989d-\u4e0a\u8d26\u91d1\u989d", (Object[])new Object[0]);
    }

    private void amountValidate(List<WithHolding> withHolding) {
        List<String> codes = withHolding.stream().map(WithHolding::getActivitiesDetailCode).collect(Collectors.toList());
        List<Account> accountList = this.accountService.findByActivitiesDetailCode(codes);
        if (CollectionUtils.isEmpty(accountList)) {
            for (WithHolding entity : withHolding) {
                BigDecimal withHoldingAmount = entity.getWithHoldingAmount();
                BigDecimal applyAmount = entity.getApplyAmount();
                Validate.isTrue((applyAmount.compareTo(withHoldingAmount) >= 0 ? 1 : 0) != 0, (String)"\u9884\u63d0\u91d1\u989d\u8d85\u51fa\u7533\u8bf7\u91d1\u989d", (Object[])new Object[0]);
            }
            return;
        }
        Map<String, List<Account>> map = accountList.stream().collect(Collectors.groupingBy(Account::getActivitiesDetailCode));
        for (WithHolding entity : withHolding) {
            BigDecimal withHoldingAmount = entity.getWithHoldingAmount();
            BigDecimal applyAmount = entity.getApplyAmount();
            List<Account> list = map.get(entity.getActivitiesDetailCode());
            if (CollectionUtils.isEmpty(list)) {
                Validate.isTrue((applyAmount.compareTo(withHoldingAmount) >= 0 ? 1 : 0) != 0, (String)"\u9884\u63d0\u91d1\u989d\u8d85\u51fa\u7533\u8bf7\u91d1\u989d", (Object[])new Object[0]);
                continue;
            }
            BigDecimal reduce = list.stream().map(Account::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal availableAmount = applyAmount.subtract(reduce);
            Validate.isTrue((availableAmount.compareTo(withHoldingAmount) >= 0 ? 1 : 0) != 0, (String)"\u9884\u63d0\u91d1\u989d\u8d85\u51fa\u7533\u8bf7\u91d1\u989d-\u4e0a\u8d26\u91d1\u989d", (Object[])new Object[0]);
        }
    }
}

