/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.internal;

import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.budget.sdk.strategy.payby.PayByStrategy;
import com.biz.crm.tpm.business.pay.local.entity.Account;
import com.biz.crm.tpm.business.pay.local.entity.WithHolding;
import com.biz.crm.tpm.business.pay.local.service.AccountService;
import com.biz.crm.tpm.business.pay.local.service.WithHoldingService;
import com.biz.crm.tpm.business.pay.local.service.WithHoldingVoService;
import com.biz.crm.tpm.business.pay.sdk.vo.WithHoldingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WithHoldingVoServiceImpl
implements WithHoldingVoService {
    @Autowired(required=false)
    private ActivitiesService activitiesService;
    @Autowired(required=false)
    private ActivitiesDetailService activitiesDetailService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private WithHoldingService withHoldingService;
    @Autowired
    private List<PayByStrategy> payByStrategies;

    @Override
    public List<WithHoldingVo> findActivitiesByConditions(List<String> codes) {
        Validate.notEmpty(codes, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Map byActivitiesCodes = this.activitiesDetailService.findByActivitiesCodes(codes);
        if (CollectionUtils.isEmpty((Map)byActivitiesCodes)) {
            return new ArrayList<WithHoldingVo>();
        }
        ArrayList<WithHoldingVo> resList = new ArrayList<WithHoldingVo>();
        byActivitiesCodes.forEach((k, v) -> {
            if (CollectionUtils.isEmpty((Collection)v)) {
                return;
            }
            Collection withHoldingVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)v, ActivitiesDetailVo.class, WithHoldingVo.class, HashSet.class, ArrayList.class, new String[0]);
            resList.addAll(withHoldingVos);
        });
        if (CollectionUtils.isEmpty(resList)) {
            return resList;
        }
        for (WithHoldingVo withHoldingVo : resList) {
            withHoldingVo.setAccountAmount(BigDecimal.ZERO);
        }
        List<String> detailCodes = resList.stream().map(WithHoldingVo::getActivitiesDetailCode).collect(Collectors.toList());
        List<Account> byActivitiesDetailCode = this.accountService.findByActivitiesDetailCode(detailCodes);
        if (CollectionUtils.isEmpty(byActivitiesDetailCode)) {
            return resList;
        }
        Map<String, List<Account>> collect = byActivitiesDetailCode.stream().collect(Collectors.groupingBy(Account::getActivitiesDetailCode));
        HashMap amountMap = new HashMap();
        collect.forEach((k, v) -> {
            BigDecimal amount = v.stream().map(Account::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            amountMap.put(k, amount);
        });
        for (WithHoldingVo vo : resList) {
            String activitiesDetailCode = vo.getActivitiesDetailCode();
            BigDecimal amount = (BigDecimal)amountMap.get(activitiesDetailCode);
            if (Objects.isNull(amount)) {
                amount = BigDecimal.ZERO;
            }
            vo.setAccountAmount(amount);
        }
        List<WithHoldingVo> list = resList.stream().filter(e -> e.getApplyAmount().compareTo(e.getAccountAmount()) > 0).collect(Collectors.toList());
        return list;
    }

    @Override
    public WithHoldingVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        WithHolding byId = this.withHoldingService.findById(id);
        if (Objects.isNull((Object)byId)) {
            return null;
        }
        String code = byId.getActivitiesDetailCode();
        WithHoldingVo withHoldingVo = (WithHoldingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)byId, WithHoldingVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<Account> accountList = this.accountService.findByActivitiesDetailCode(Lists.newArrayList((Object[])new String[]{code}));
        if (!CollectionUtils.isEmpty(accountList)) {
            BigDecimal reduce = accountList.stream().map(Account::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            withHoldingVo.setAccountAmount(reduce);
        } else {
            withHoldingVo.setAccountAmount(BigDecimal.ZERO);
        }
        Map<String, String> payBy = this.payByStrategies.stream().collect(Collectors.toMap(PayByStrategy::getCode, PayByStrategy::getName));
        if (!CollectionUtils.isEmpty(payBy)) {
            withHoldingVo.setPayByName(payBy.get(withHoldingVo.getPayBy()));
        }
        return withHoldingVo;
    }
}

