/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.observer;

import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.pay.local.service.AuditBillService;
import com.biz.crm.tpm.business.pay.local.service.AuditInvoiceService;
import com.biz.crm.tpm.business.pay.sdk.dto.InvoiceDetailDto;
import com.biz.crm.tpm.business.pay.sdk.service.AuditService;
import com.biz.crm.tpm.business.pay.sdk.service.InvoiceDeailService;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditDetailVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditInvoiceVo;
import com.biz.crm.tpm.business.pay.sdk.vo.AuditVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditProcessCallBackListener
implements CallBackListener {
    @Autowired
    private AuditService auditService;
    @Autowired
    private AuditBillService auditBillService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private ActivitiesDetailService activitiesDetailService;
    @Autowired
    private AuditInvoiceService auditInvoiceService;
    @Autowired
    private InvoiceDeailService invoiceDeailService;

    public void onCallBack(CallBackDto dto) {
        if (!dto.getFormType().equals("PAY_AUDIT")) {
            return;
        }
        String code = dto.getFormNo();
        AuditVo auditVo = this.auditService.findByCode(code);
        Validate.notNull((Object)auditVo, (String)"\u8d39\u7528\u6838\u9500\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5b9e\u4f8b", (Object[])new Object[0]);
        String processStatus = auditVo.getProcessStatus();
        Validate.isTrue((boolean)processStatus.equals(ActApproveStatusEnum.APPROVING.getCode()), (String)"\u8d39\u7528\u6838\u9500\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u5f53\u524d\u5b9e\u4f8b\u975e\u5ba1\u6279\u4e2d\u72b6\u6001\uff01", (Object[])new Object[0]);
        if (String.valueOf(dto.getProcessState()).equals(ActApproveStatusEnum.APPROVED.getCode())) {
            this.auditService.updateProcessStatusByAuditCode(auditVo.getAuditCode(), ActApproveStatusEnum.APPROVED.getCode());
            this.auditBillService.auditAmountByAuditCode(auditVo.getAuditCode());
            this.auditService.updateActivitiesAuditStatusByAuditCode(auditVo.getAuditCode());
        }
        if (String.valueOf(dto.getProcessState()).equals(ActApproveStatusEnum.REJECTED.getCode())) {
            this.auditService.updateProcessStatusByAuditCode(auditVo.getAuditCode(), ActApproveStatusEnum.REJECTED.getCode());
            this.auditAmountBack(auditVo);
            this.invoiceBack(auditVo);
        }
        if (String.valueOf(dto.getProcessState()).equals(ActApproveStatusEnum.INTERRUPT.getCode())) {
            this.auditService.updateProcessStatusByAuditCode(auditVo.getAuditCode(), ActApproveStatusEnum.INTERRUPT.getCode());
            this.auditAmountBack(auditVo);
            this.invoiceBack(auditVo);
        }
    }

    private void auditAmountBack(AuditVo auditVo) {
        for (AuditDetailVo auditDetailVo : auditVo.getAuditDetails()) {
            BigDecimal excessAmount = auditDetailVo.getExcessAmount();
            if (excessAmount == null || excessAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            ActivitiesDetailVo basicActivityItemVo = this.activitiesDetailService.findByActivitiesDetailCode(auditDetailVo.getActivitiesDetailCode());
            Validate.notNull((Object)basicActivityItemVo, (String)"\u6d3b\u52a8\u660e\u7ec6\u3010%s\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{auditDetailVo.getActivitiesDetailCode()});
            this.costBudgetVoService.back(auditDetailVo.getAuditCode(), auditDetailVo.getAuditDetailCode(), basicActivityItemVo.getCostBudgetCode(), excessAmount, null, CostBudgetItemSourceType.AUDIT.getDescr());
        }
    }

    private void invoiceBack(AuditVo auditVo) {
        List<AuditInvoiceVo> auditInvoiceVos = this.auditInvoiceService.findByAuditCode(auditVo.getAuditCode());
        if (!CollectionUtils.isEmpty(auditInvoiceVos)) {
            for (AuditInvoiceVo invoiceVo : auditInvoiceVos) {
                InvoiceDetailDto detailDto = new InvoiceDetailDto();
                detailDto.setInvoiceNo(invoiceVo.getInvoiceNo());
                detailDto.setBusinessCode(auditVo.getAuditCode());
                detailDto.setOperateAmount(invoiceVo.getUseAmount());
                this.invoiceDeailService.back(detailDto);
            }
        }
    }
}

