/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.observer;

import com.biz.crm.tpm.business.pay.local.service.PrepayBillService;
import com.biz.crm.tpm.business.pay.sdk.service.PrepayService;
import com.biz.crm.tpm.business.pay.sdk.vo.PrepayVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrepayActivitiesProcessCallBackListener
implements CallBackListener {
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private PrepayService prepayService;
    @Autowired
    private PrepayBillService prepayBillService;

    public void onCallBack(CallBackDto dto) {
        if (!dto.getFormType().equals("PAY_PREPAY")) {
            return;
        }
        String code = dto.getFormNo();
        PrepayVo prepayVo = this.prepayService.findByCode(code);
        String processStatus = prepayVo.getProcessStatus();
        Validate.isTrue((boolean)processStatus.equals(ActApproveStatusEnum.APPROVING.getCode()), (String)"\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u5f53\u524d\u5b9e\u4f8b\u975e\u5ba1\u6279\u4e2d\u72b6\u6001\uff01", (Object[])new Object[0]);
        if (String.valueOf(dto.getProcessState()).equals(ActApproveStatusEnum.APPROVED.getCode())) {
            this.prepayService.updateStatusByCode(prepayVo.getPrepayCode(), ActApproveStatusEnum.APPROVED.getCode());
            this.prepayBillService.prepayAmountByPrepayCode(prepayVo.getPrepayCode());
        }
        if (String.valueOf(dto.getProcessState()).equals(ActApproveStatusEnum.REJECTED.getCode())) {
            this.prepayService.updateStatusByCode(prepayVo.getPrepayCode(), ActApproveStatusEnum.REJECTED.getCode());
        }
        if (String.valueOf(dto.getProcessState()).equals(ActApproveStatusEnum.INTERRUPT.getCode())) {
            this.prepayService.updateStatusByCode(prepayVo.getPrepayCode(), ActApproveStatusEnum.INTERRUPT.getCode());
        }
    }
}

