/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.strategy;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolPayTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolUseTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.service.CostPoolDiscountVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.account.AccountPayByStrategy;
import com.biz.crm.tpm.business.pay.sdk.dto.AccountDto;
import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class DiscountAccountPayByStrategy
implements AccountPayByStrategy {
    @Autowired(required=false)
    private CostPoolDiscountVoService costPoolDiscountVoService;
    private final String SUCCESSFUL_CODE = "200";

    public void execute(Object o) {
        AccountDto accountDto = (AccountDto)o;
        Validate.notNull((Object)accountDto, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        BigDecimal amount = accountDto.getAmount();
        Validate.notNull((Object)amount, (String)"\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((amount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        String payBy = accountDto.getPayBy();
        Validate.notBlank((CharSequence)accountDto.getCustomerCode(), (String)"\u5411\u6298\u6263\u6c60\u4e0a\u8d26\u65f6\uff0c\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        CostPoolDiscountDto dto = new CostPoolDiscountDto();
        dto.setPoolGroup(PoolGroupEnum.DEFAULT.getDictCode());
        dto.setPayType(PoolPayTypeEnum.DISCOUNT.getDictCode());
        dto.setUseType(PoolUseTypeEnum.DEFAULT.getDictCode());
        dto.setOperationType(PoolOperationTypeEnum.ACT_ACCOUNT.getDictCode());
        dto.setCustomerCode(accountDto.getCustomerCode());
        dto.setCustomerName(accountDto.getCustomerName());
        dto.setAmount(accountDto.getAmount());
        Result result = this.costPoolDiscountVoService.handleAdjust(dto);
        Validate.notNull((Object)result, (String)"\u8c03\u7528\u6298\u6263\u6c60\u4e0a\u8d26\u5931\u8d25[\u65e0\u6cd5\u8fde\u63a5\u5230DMS]", (Object[])new Object[0]);
        Validate.isTrue((boolean)result.getCode().toString().equals("200"), (String)("\u6298\u6263\u6c60\u4e0a\u8d26\u5931\u8d25[" + result.getMessage() + "]"), (Object[])new Object[0]);
    }
}

