/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.local.service.strategy;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentProductDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolGroupEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolPayTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolUseTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.service.CostPoolReplenishmentVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.account.AccountPayByStrategy;
import com.biz.crm.tpm.business.pay.sdk.dto.AccountDto;
import com.biz.crm.tpm.business.pay.sdk.dto.AccountProductDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class RestockAccountPayByStrategy
implements AccountPayByStrategy {
    @Autowired(required=false)
    private CostPoolReplenishmentVoService costPoolReplenishmentVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    private final String SUCCESSFUL_CODE = "200";

    public void execute(Object o) {
        AccountDto accountDto = (AccountDto)o;
        Validate.notNull((Object)accountDto, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        String payBy = accountDto.getPayBy();
        BigDecimal amount = accountDto.getAmount();
        Validate.notNull((Object)amount, (String)"\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((amount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)accountDto.getCustomerCode(), (String)"\u5411\u8d27\u8865\u6c60\u4e0a\u8d26\u65f6\uff0c\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)accountDto.getProductLevelCode(), (String)"\u5411\u8d27\u8865\u6c60\u4e0a\u8d26\u65f6\uff0c\u7f3a\u5931\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801", (Object[])new Object[0]);
        CostPoolReplenishmentDto dto = new CostPoolReplenishmentDto();
        dto.setPoolGroup(PoolGroupEnum.DEFAULT.getDictCode());
        dto.setUseType(PoolUseTypeEnum.DEFAULT.getDictCode());
        dto.setPayType(PoolPayTypeEnum.Replenishment.getDictCode());
        dto.setOperationType(PoolOperationTypeEnum.ACT_ACCOUNT.getDictCode());
        dto.setCustomerCode(accountDto.getCustomerCode());
        dto.setCustomerName(accountDto.getCustomerName());
        dto.setGoodsProductLevelCode(accountDto.getProductLevelCode());
        dto.setGoodsProductLevelName(accountDto.getProductLevelName());
        dto.setAmount(accountDto.getAmount());
        List productList = accountDto.getProductList();
        if (!CollectionUtils.isEmpty((Collection)productList)) {
            ArrayList<CostPoolReplenishmentProductDto> costPoolReplenishmentProduct = new ArrayList<CostPoolReplenishmentProductDto>();
            for (AccountProductDto accountProductDto : productList) {
                CostPoolReplenishmentProductDto productDto = new CostPoolReplenishmentProductDto();
                productDto.setGoodsProductCode(accountProductDto.getProductCode());
                productDto.setGoodsProductName(accountProductDto.getProductName());
                productDto.setProductLevelCode(accountDto.getProductLevelCode());
                costPoolReplenishmentProduct.add(productDto);
            }
            dto.setCostPoolReplenishmentProduct(costPoolReplenishmentProduct);
        }
        Result result = this.costPoolReplenishmentVoService.handleAdjust(dto);
        Validate.notNull((Object)result, (String)"\u8c03\u7528\u8d27\u8865\u6c60\u4e0a\u8d26\u5931\u8d25[\u65e0\u6cd5\u8fde\u63a5\u5230DMS]", (Object[])new Object[0]);
        Validate.isTrue((boolean)result.getCode().toString().equals("200"), (String)("\u8d27\u8865\u6c60\u4e0a\u8d26\u5931\u8d25[" + result.getMessage() + "]"), (Object[])new Object[0]);
    }
}

