/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.pay.sdk.enums;

import org.apache.commons.lang3.StringUtils;

public enum InvoiceType {
    VAT_SPECIAL("special", "special", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", "1"),
    VAT_GENERAL("general", "general", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968", "2"),
    QUOTA("quota", "quota", "\u5b9a\u989d\u53d1\u7968", "3");

    private String key;
    private String dictCode;
    private String value;
    private String order;

    public static InvoiceType findByKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        for (InvoiceType e : InvoiceType.values()) {
            if (!StringUtils.equals((CharSequence)e.getKey(), (CharSequence)key)) continue;
            return e;
        }
        return null;
    }

    public static boolean containsKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        for (InvoiceType e : InvoiceType.values()) {
            if (!StringUtils.equals((CharSequence)e.getKey(), (CharSequence)key)) continue;
            return true;
        }
        return false;
    }

    public static InvoiceType findByValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        for (InvoiceType e : InvoiceType.values()) {
            if (!StringUtils.equals((CharSequence)e.getValue(), (CharSequence)value)) continue;
            return e;
        }
        return null;
    }

    private InvoiceType(String key, String dictCode, String value, String order) {
        this.key = key;
        this.dictCode = dictCode;
        this.value = value;
        this.order = order;
    }

    public String getKey() {
        return this.key;
    }

    public String getDictCode() {
        return this.dictCode;
    }

    public String getValue() {
        return this.value;
    }

    public String getOrder() {
        return this.order;
    }
}

