package com.biz.crm.tpm.business.payment.receipt.local.dataView;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/12/5 20:08
 * @description: tpm付款单数据视图
 */
@Component
@Slf4j
public class PaymentReceiptDataViewRegister implements DataviewRegister {
    /**
     * 编码
     */
    @Override
    public String code() {
        return "tpm_payment_receipt_data_view";
    }

    /**
     * 名称
     */
    @Override
    public String desc() {
        return "TPM-付款单";
    }

    /**
     * sql
     */
    @Override
    public String buildSql() {
        return "select a.* from tpm_payment_receipt a " +
                "    where a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "    and a.tenant_code = :tenantCode ";
    }
}
