package com.biz.crm.tpm.business.payment.receipt.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/12/5 11:22
 * @description: 付款单实体类
 */
@ApiModel(value = "PaymentReceipt", description = "付款单")
@TableName("tpm_payment_receipt")
@Getter
@Setter
@Entity(name = "tpm_payment_receipt")
@org.hibernate.annotations.Table(appliesTo = "tpm_payment_receipt", comment = "付款单")
@Table(name = "tpm_payment_receipt", indexes = {
        @Index(name = "tpm_payment_receipt_INDEX1", columnList = "payment_receipt_code", unique = true)})
public class PaymentReceipt extends TenantFlagOpEntity {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    @Column(name = "payment_receipt_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '付款单编码'")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "付款单状态", notes = "付款单状态")
    @Column(name = "payment_receipt_state", length = 32, columnDefinition = "VARCHAR(32) COMMENT '付款单状态'")
    private String paymentReceiptState;

    @ApiModelProperty(name = "流程审批状态", notes = "流程审批状态")
    @Column(name = "process_state", length = 32, columnDefinition = "VARCHAR(32) COMMENT '流程审批状态'")
    private String processState;

    @ApiModelProperty("流程编号")
    @Column(name = "process_no", length = 64, columnDefinition = "varchar(64) COMMENT '流程编号'")
    private String processNo;

//    @ApiModelProperty(name = "保存状态", notes = "保存状态")
//    @Column(name = "save_state", length = 32, columnDefinition = "VARCHAR(32) COMMENT '保存状态'")
//    private String saveState;

    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "申请人工号", notes = "申请人工号")
    @Column(name = "apply_work_no", length = 32, columnDefinition = "VARCHAR(32) COMMENT '申请人工号'")
    private String applyWorkNo;

    @ApiModelProperty(name = "申请人", notes = "申请人")
    @Column(name = "apply_person", length = 128, columnDefinition = "VARCHAR(128) COMMENT '申请人'")
    private String applyPerson;

    @ApiModelProperty(name = "申请人部门", notes = "申请人部门")
    @Column(name = "apply_depart_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '申请人部门'")
    private String applyDepartName;

    @ApiModelProperty(name = "申请人部门编码", notes = "申请人部门编码")
    @Column(name = "apply_depart_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '申请人部门编码'")
    private String applyDepartCode;

    @ApiModelProperty(name = "公司名称", notes = "公司名称")
    @Column(name = "company_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '公司名称'")
    private String companyName;

    @ApiModelProperty(name = "公司编码", notes = "公司编码")
    @Column(name = "company_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '公司编码'")
    private String companyCode;

    @ApiModelProperty(name = "利润中心编码", notes = "利润中心编码")
    @Column(name = "profit_center_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '利润中心编码'")
    private String profitCenterCode;

    @ApiModelProperty(name = "利润中心名称", notes = "利润中心名称")
    @Column(name = "profit_center_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '利润中心名称'")
    private String profitCenterName;

    @ApiModelProperty(name = "付款类型", notes = "付款类型")
    @Column(name = "pay_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款类型'")
    private String payType;

    @ApiModelProperty(name = "付款细类", notes = "付款细类")
    @Column(name = "pay_item_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款细类'")
    private String payItemType;

    @ApiModelProperty(name = "交易货币", notes = "交易货币")
    @Column(name = "trade_currency", length = 64, columnDefinition = "VARCHAR(64) COMMENT '交易货币'")
    private String tradeCurrency;

    @ApiModelProperty(name = "汇率", notes = "汇率")
    @Column(name = "exchange_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '汇率'")
    private String exchangeRate;

    @ApiModelProperty(name = "付款方式", notes = "付款方式")
    @Column(name = "pay_way", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款方式'")
    private String payWay;

    @ApiModelProperty(name = "FSSC审核部门", notes = "FSSC审核部门")
    @Column(name = "audit_depart", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'FSSC审核部门'")
    private String auditDepart;

    @ApiModelProperty(name = "是否有合同", notes = "是否有合同")
    @Column(name = "is_have_contract", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否有合同'")
    private String isHaveContract;

    @ApiModelProperty(name = "是否挂账保理", notes = "是否挂账保理")
    @Column(name = "is_factoring", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否挂账保理'")
    private String isFactoring;

    @ApiModelProperty(name = "付款总金额", notes = "付款总金额")
    @Column(name = "pay_total_money", length = 24, columnDefinition = "decimal(24,6) COMMENT '付款总金额'")
    private String payTotalMoney;

    @ApiModelProperty(name = "开支内容", notes = "开支内容")
    @Column(name = "spending_content", length = 400, columnDefinition = "VARCHAR(400) COMMENT '开支内容'")
    private String spendingContent;

    @ApiModelProperty(name = "ceDocumentNumber", notes = "ce单据单号")
    @Column(name = "ce_document_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'ce单据单号'")
    private String ceDocumentNumber;

    @ApiModelProperty("CE提交状态")
    @Column(name = "ce_commit_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'CE提交状态'")
    private String ceCommitStatus;

    @ApiModelProperty("CE提交信息")
    @Column(name = "ce_commit_message", length = 1000, columnDefinition = "VARCHAR(1000) COMMENT 'CE提交信息'")
    private String ceCommitMessage;

    @ApiModelProperty("SAP转款提交状态")
    @Column(name = "sap_transfer_commit_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'SAP转款提交状态 SapTransferCommitStatusEnum'")
    private String sapTransferCommitStatus;

    @ApiModelProperty("SAP转款提交信息")
    @Column(name = "sap_transfer_commit_message", length = 1000, columnDefinition = "VARCHAR(1000) COMMENT 'SAP转款提交信息'")
    private String sapTransferCommitMessage;

    @ApiModelProperty("SAP会计凭证号")
    @Column(name = "sap_transfer_belnr", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'SAP会计凭证号'")
    private String sapTransferBelnr;


    @ApiModelProperty("SAP转款凭证编码")
    @Column(name = "sap_transfer_cert_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'SAP转款凭证编码'")
    private String sapTransferCertCode;

    @ApiModelProperty("付款编码")
    @Column(name = "eas_order_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款编码'")
    private String easOrderId;

    @ApiModelProperty("付款流水号")
    @Column(name = "flow_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款流水号'")
    private String flowId;

    @ApiModelProperty("付款账号")
    @Column(name = "pay_account_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款账号'")
    private String payAccountCode;

    @ApiModelProperty("付款编码")
    @Column(name = "eas_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款编码'")
    private String easCode;

    @ApiModelProperty("付款描述")
    @Column(name = "eas_desc", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款描述'")
    private String easDesc;

    @ApiModelProperty("EAS返回信息")
    @Column(name = "eas_message", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'EAS返回信息'")
    private String easMessage;

    @ApiModelProperty("付款成功日期")
    @Column(name = "pay_success_date", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款成功日期'")
    private String paySuccessDate;

    @ApiModelProperty("SAP付款凭证号")
    @Column(name = "sap_voucher_no", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'SAP付款凭证号'")
    private String sapVoucherNo;

    @ApiModelProperty("流程状态")
    @Column(name = "process_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '流程状态'")
    private String processStatus;

    @ApiModelProperty("数据来源")
    @Column(name = "data_source",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '数据来源 [PaymentReceiptDataSourceEnum]'")
    private String dataSource;

    @ApiModelProperty("组织编码")
    @Column(name = "org_code",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @Column(name = "org_name",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '组织编码'")
    private String orgName;
}
