package com.biz.crm.tpm.business.payment.receipt.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author: chenlong
 * @date: 2022/12/6 13:59
 * @description: 付款单-附件信息
 */
@ApiModel(value = "PaymentReceiptFile", description = "付款单-附件信息")
@TableName("tpm_payment_receipt_file")
@Getter
@Setter
@Entity(name = "tpm_payment_receipt_file")
@org.hibernate.annotations.Table(appliesTo = "tpm_payment_receipt_file", comment = "付款单-附件信息")
@Table(name = "tpm_payment_receipt_file", indexes = {
        @Index(name = "tpm_payment_receipt_index1", columnList = "payment_receipt_code")})
public class PaymentReceiptFile extends TenantFlagOpEntity {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    @Column(name = "payment_receipt_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '付款单编码'")
    private String paymentReceiptCode;

    @ApiModelProperty("文件唯一识别号")
    @Column(name = "file_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
    private String fileCode;

    @ApiModelProperty(name = "originalFileName", value = "原始文件名")
    @Column(name = "original_file_name", nullable = true, columnDefinition = "varchar(255) COMMENT '原始文件名'")
    private String originalFileName;
}
