package com.biz.crm.tpm.business.payment.receipt.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/12/5 17:19
 * @description: 付款单支付明细
 */
@ApiModel(value = "PaymentReceiptPay", description = "付款单支付明细")
@TableName("tpm_payment_receipt_pay")
@Getter
@Setter
@Entity(name = "tpm_payment_receipt_pay")
@org.hibernate.annotations.Table(appliesTo = "tpm_payment_receipt_pay", comment = "付款单支付明细")
@Table(name = "tpm_payment_receipt_pay", indexes = {
        @Index(name = "tpm_payment_receipt_pay_index1", columnList = "payment_receipt_code")})
public class PaymentReceiptPay extends TenantFlagOpEntity {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    @Column(name = "payment_receipt_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '付款单编码'")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "支付明细编码", notes = "支付明细编码")
    @Column(name = "pay_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '支付明细编码'")
    private String payCode;

    @ApiModelProperty(name = "应付明细编码", notes = "应付明细编码")
    @Column(name = "should_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '应付明细编码'")
    private String shouldCode;

    @ApiModelProperty(name = "核销付款信息编码", notes = "核销付款信息编码")
    @Column(name = "audit_pay_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销付款信息编码'")
    private String auditPayCode;

    @ApiModelProperty(name = "支付摘要", notes = "支付摘要")
    @Column(name = "payment_digest", length = 255, columnDefinition = "VARCHAR(255) COMMENT '支付摘要'")
    private String paymentDigest;

    @ApiModelProperty(name = "支付摘要描述", notes = "支付摘要描述")
    @Column(name = "payment_digest_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '支付摘要描述'")
    private String paymentDigestName;

    @ApiModelProperty(name = "利润中心", notes = "利润中心")
    @Column(name = "profit_center", length = 64, columnDefinition = "VARCHAR(64) COMMENT '利润中心'")
    private String profitCenter;

    @ApiModelProperty(name = "资金流出项目", notes = "资金流出项目")
    @Column(name = "capital_outflow_project", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资金流出项目'")
    private String capitalOutflowProject;

    @ApiModelProperty(name = "资金流出项目名称", notes = "资金流出项目名称")
    @Column(name = "capital_outflow_project_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '资金流出项目名称'")
    private String capitalOutflowProjectName;

    @ApiModelProperty(name = "原因代码", notes = "原因代码")
    @Column(name = "reason_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '原因代码'")
    private String reasonCode;

    @ApiModelProperty(name = "原因代码名称", notes = "原因代码名称")
    @Column(name = "reason_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '原因代码名称'")
    private String reasonName;


    @ApiModelProperty(name = "序号", notes = "序号")
    @Column(name = "sort_no", length = 24, nullable = false, columnDefinition = "decimal(24,6) COMMENT '序号'")
    private Integer sortNo;

    @ApiModelProperty(name = "本次应付金额（元）", notes = "本次应付金额（元）")
    @Column(name = "now_should_pay_money", length = 24, columnDefinition = "decimal(24,6) COMMENT '本次应付金额（元）'")
    private BigDecimal nowShouldPayMoney;
}
