package com.biz.crm.tpm.business.payment.receipt.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/12/5 17:17
 * @description: 付款单应付明细
 */
@ApiModel(value = "PaymentReceiptShould", description = "付款单应付明细")
@TableName("tpm_payment_receipt_should")
@Getter
@Setter
@Entity(name = "tpm_payment_receipt_should")
@org.hibernate.annotations.Table(appliesTo = "tpm_payment_receipt_should", comment = "付款单")
@Table(name = "tpm_payment_receipt_should", indexes = {
        @Index(name = "tpm_payment_receipt_should_index1", columnList = "payment_receipt_code")})
public class PaymentReceiptShould extends TenantFlagOpEntity {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    @Column(name = "payment_receipt_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '付款单编码'")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "应付明细编码", notes = "应付明细编码")
    @Column(name = "should_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '应付明细编码'")
    private String shouldCode;

    @ApiModelProperty(name = "核销编码", notes = "核销编码")
    @Column(name = "audit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销编码'")
    private String auditCode;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    @Column(name = "audit_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销明细编码'")
    private String auditItemCode;

    @ApiModelProperty(name = "核销付款信息编码", notes = "核销付款信息编码")
    @Column(name = "audit_pay_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销付款信息编码'")
    private String auditPayCode;

    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    @Column(name = "suppliers_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码'")
    private String suppliersCode;

    @ApiModelProperty(name = "供应商名称", notes = "供应商名称")
    @Column(name = "suppliers_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '供应商名称'")
    private String suppliersName;

    @ApiModelProperty(name = "保理客户编码", notes = "保理客户编码")
    @Column(name = "factoring_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客商编码'")
    private String factoringCode;

    @ApiModelProperty(name = "保理客户名称", notes = "保理客户名称")
    @Column(name = "factoring_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '保理客户名称'")
    private String factoringName;

    @ApiModelProperty(name = "客商类型", notes = "客商类型")
    @Column(name = "merchants_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客商类型'")
    private String merchantsType;

    @ApiModelProperty(name = "款项性质", notes = "款项性质")
    @Column(name = "payment_nature", length = 32, columnDefinition = "VARCHAR(32) COMMENT '款项性质'")
    private String paymentNature;

    @ApiModelProperty(name = "客商编码", notes = "客商编码")
    @Column(name = "merchants_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客商编码'")
    private String merchantsCode;

    @ApiModelProperty(name = "客商名称", notes = "客商名称")
    @Column(name = "merchants_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客商名称'")
    private String merchantsName;

    @ApiModelProperty(name = "收款信息id", notes = "收款信息id")
    @Column(name = "account_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '收款信息id'")
    private String accountId;

    @ApiModelProperty(name = "户名", notes = "户名")
    @Column(name = "account_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '户名'")
    private String accountName;

    @ApiModelProperty(name = "收款账号", notes = "收款账号")
    @Column(name = "collection_account", length = 32, columnDefinition = "VARCHAR(32) COMMENT '收款账号'")
    private String collectionAccount;

    @ApiModelProperty(name = "开户行", notes = "开户行")
    @Column(name = "account_bank", length = 128, columnDefinition = "VARCHAR(128) COMMENT '开户行'")
    private String accountBank;

    @ApiModelProperty(name = "银联行号", notes = "银联行号")
    @Column(name = "union_pay_account", length = 32, columnDefinition = "VARCHAR(32) COMMENT '银联行号'")
    private String unionPayAccount;

    @ApiModelProperty(name = "客商编码2", notes = "客商编码2")
    @Column(name = "merchants_two_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客商编码2'")
    private String merchantsTwoCode;

    @ApiModelProperty(name = "客商名称2", notes = "客商名称2")
    @Column(name = "merchants_two_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客商名称2'")
    private String merchantsTwoName;

    @ApiModelProperty(name = "结案金额（元）", notes = "结案金额（元）")
    @Column(name = "audit_money", length = 24, columnDefinition = "decimal(24,6) COMMENT '结案金额（元）'")
    private BigDecimal auditMoney;

    @ApiModelProperty(name = "考核扣款金额（元）", notes = "考核扣款金额（元）")
    @Column(name = "assess_deduction_money", length = 24, columnDefinition = "decimal(24,6) COMMENT '考核扣款金额（元）'")
    private BigDecimal assessDeductionMoney;

    @ApiModelProperty(name = "应付金额（元）", notes = "应付金额（元）")
    @Column(name = "should_pay_money", length = 24, columnDefinition = "decimal(24,6) COMMENT '应付金额（元）'")
    private BigDecimal shouldPayMoney;

    @ApiModelProperty(name = "预付金额（元）", notes = "预付金额（元）")
    @Column(name = "prepaid_money", length = 24, columnDefinition = "decimal(24,6) COMMENT '预付金额（元）'")
    private BigDecimal prepaidMoney;

    @ApiModelProperty(name = "已付金额（含审批中）", notes = "已付金额（含审批中）")
    @Column(name = "already_money", length = 24, columnDefinition = "decimal(24,6) COMMENT '已付金额（含审批中）'")
    private BigDecimal alreadyMoney;

    @ApiModelProperty(name = "本次应付金额（元）", notes = "本次应付金额（元）")
    @Column(name = "now_should_pay_money", length = 24, columnDefinition = "decimal(24,6) COMMENT '本次应付金额（元）'")
    private BigDecimal nowShouldPayMoney;

    @ApiModelProperty(name = "期望付款日期", notes = "期望付款日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "expect_pay_date", length = 24, columnDefinition = "datetime COMMENT '期望付款日期'")
    private Date expectPayDate;

    @ApiModelProperty(name = "邮件通知人", notes = "邮件通知人")
    @Column(name = "mail_notice_person", length = 128, columnDefinition = "VARCHAR(128) COMMENT '邮件通知人'")
    private String mailNoticePerson;

    @ApiModelProperty(name = "汇票期限", notes = "汇票期限")
    @Column(name = "bill_date", length = 24, columnDefinition = "decimal(24,6) COMMENT '汇票期限'")
    private Integer billDate;

    @ApiModelProperty(name = "单位", notes = "单位")
    @Column(name = "date_unit", length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位'")
    private String dateUnit;

    @ApiModelProperty(name = "合同编码", notes = "合同编码")
    @Column(name = "contract_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '合同编码'")
    private String contractCode;

    @ApiModelProperty(name = "合同名称", notes = "合同名称")
    @Column(name = "contract_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '合同名称'")
    private String contractName;

    @ApiModelProperty(name = "序号", notes = "序号")
    @Column(name = "sort_no", length = 24, nullable = false, columnDefinition = "decimal(24,6) COMMENT '序号'")
    private Integer sortNo;

    @ApiModelProperty(name = "reimbursementItemCode", notes = "报销项目编码")
    @Column(name = "reimbursement_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '报销项目编码'")
    private String reimbursementItemCode;

    @ApiModelProperty(name = "reimbursementItemName", notes = "报销项目名称")
    @Column(name = "reimbursement_item_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '报销项目名称'")
    private String reimbursementItemName;


}
