package com.biz.crm.tpm.business.payment.receipt.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.math.BigDecimal;

/**
 * @ClassName PaymentReceiptShouldAuditRelations
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/4/25 14:25
 **/
@ApiModel(value = "PaymentReceiptShouldAuditRelations", description = "付款单应付明细与核销明细关联表")
@TableName("payment_receipt_should_audit_relations")
@Getter
@Setter
@Entity(name = "payment_receipt_should_audit_relations")
@org.hibernate.annotations.Table(appliesTo = "payment_receipt_should_audit_relations", comment = "付款单应付明细与核销明细关联表")
public class PaymentReceiptShouldAuditRelations extends TenantFlagOpEntity {

    @ApiModelProperty(name = "核销明细ID", notes = "核销明细ID")
    @Column(name = "audit_detail_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销明细ID'")
    private String auditDetailId;

    @ApiModelProperty(name = "应付明细编码", notes = "应付明细编码")
    @Column(name = "should_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '应付明细编码'")
    private String shouldCode;

    @ApiModelProperty(name = "付款单编码 ", notes = "付款单编码")
    @Column(name = "payment_receipt_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '付款单编码'")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "本次应付金额（元）", notes = "本次应付金额（元）")
    @Column(name = "now_should_pay_money", length = 24, columnDefinition = "decimal(24,6) COMMENT '本次应付金额（元）'")
    private BigDecimal nowShouldPayMoney;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    @Column(name = "audit_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销明细编码'")
    private String auditItemCode;

}
