package com.biz.crm.tpm.business.payment.receipt.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.elasticsearch.annotations.Field;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * @ClassName ReimburseFundsReasonMappingEntity
 * @Description 报销项目与资金流出项目及原因代码映射关系
 * @AUTHOR WangJJ
 * @DATE 2023/2/25 14:48
 **/
@ApiModel(value = "ReimburseFundsReasonMapping", description = "报销项目与资金流出项目及原因代码映射关系")
@TableName("tpm_audit_reason_code_funds_outflow_mapping")
@Getter
@Setter
@Entity(name = "tpm_audit_reason_code_funds_outflow_mapping")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_reason_code_funds_outflow_mapping", comment = "报销项目与资金流出项目及原因代码映射关系")
public class ReimburseFundsReasonMapping extends TenantFlagOpEntity {

    @ApiModelProperty("报销项目编码")
    @Column(name = "reimburse_item", length = 256, columnDefinition = "VARCHAR(256) COMMENT '报销项目编码'")
    private String reimburseItem;

    @ApiModelProperty("报销项目编码")
    @Column(name = "reimburse_item_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '报销项目名称'")
    private String reimburseItemName;

    @ApiModelProperty("原因代码")
    @Column(name = "reason_code", length = 256, columnDefinition = "VARCHAR(256) COMMENT '原因代码'")
    private String reasonCode;

    @ApiModelProperty("原因代码名称")
    @Column(name = "reason_code_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '原因代码名称'")
    private String reasonCodeName;

    @ApiModelProperty("资金流出项目代码")
    @Column(name = "funds_outflow_item", length = 256, columnDefinition = "VARCHAR(256) COMMENT '资金流出项目代码'")
    private String fundsOutflowItem;

    @ApiModelProperty("资金流出项目名称")
    @Column(name = "funds_outflow_item_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '资金流出项目名称'")
    private String fundsOutflowItemName;

}
