package com.biz.crm.tpm.business.payment.receipt.local.listener;

import com.biz.crm.tpm.business.payment.receipt.local.service.PaymentReceiptService;
import com.biz.crm.tpm.business.payment.receipt.sdk.constant.PaymentReceiptConstants;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 营销策略审批通过回调
 *
 * @author wanghaojia
 * @date 2022/11/30 20:57
 */
@Component
public class PaymentReceiptProcessCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private PaymentReceiptService paymentReceiptService;

    @Override
    public String getBusinessCode() {
        return PaymentReceiptConstants.PROCESS_NAME_PAYMENT_RECEIPT;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty(dto.getBusinessNo())) {
            return;
        }

        //多策略提交
        Validate.notEmpty(dto.getBusinessNoList(), "流程编码不能为空！");

        paymentReceiptService.updateProcessStatusBatch(dto);
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(dto.getProcessStatus())) {
            paymentReceiptService.processPassSendData(dto);
        }

    }
}
