package com.biz.crm.tpm.business.payment.receipt.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceipt;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.ReimburseFundsReasonMappingVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/5 11:34
 * @description: 付款单表(PaymentReceipt)表mybatis访问层
 */
public interface PaymentReceiptMapper extends BaseMapper<PaymentReceipt> {


    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询Dto
     * @return 所有数据
     */
    Page<PaymentReceiptVo> findByConditions(@Param("page") Page<PaymentReceiptVo> page, @Param("dto") PaymentReceiptDto dto);

    List<ReimburseFundsReasonMappingVo> findAuditReasonCodeFundsOutflowMapping(@Param("codes") List<String> codes);
}
