package com.biz.crm.tpm.business.payment.receipt.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptPay;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.MobilePaymentReceiptApprovedVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptPayVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/12/5 19:38
 * @description: 付款单-支付明细表(PaymentReceiptPay)表mybatis访问层
 */
public interface PaymentReceiptPayMapper extends BaseMapper<PaymentReceiptPay> {
    /**
     * 根据付款单编码查支付明细
     *
     * @param codes
     * @param tenantCode
     * @return
     */
    List<PaymentReceiptPayVo> findByPaymentReceiptCodes(@Param("codes") Set<String> codes,@Param("tenantCode") String tenantCode);

    List<MobilePaymentReceiptApprovedVo> mobilePaymentReceiptApproved(@Param("processNo") String processNo);

    List<MobilePaymentReceiptApprovedVo> findAlreadyMoneyByAuditDetailCodes(@Param("auditItemCodes") List<String> auditItemCodes);
}
