package com.biz.crm.tpm.business.payment.receipt.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptShould;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptAuditPayDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptShouldVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.ReimburseFundsReasonMappingVo;
import org.apache.ibatis.annotations.Param;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/12/5 19:38
 * @description: 付款单-应付明细表(PaymentReceiptShould)表mybatis访问层
 */
public interface PaymentReceiptShouldMapper extends BaseMapper<PaymentReceiptShould> {

    /**
     * 分页查询可付款的核销付款信息
     *
     * @param page 分页对象
     * @param dto  查询Dto
     * @return Page<PaymentReceiptShouldVo>
     */
    Page<PaymentReceiptShouldVo> findAuditPayByConditions(@Param("page") Page<PaymentReceiptShouldVo> page, @Param("dto") PaymentReceiptAuditPayDto dto);

    /**
     * 分页查询可付款的核销付款信息 (不加付款方式)
     *
     * @param page 分页对象
     * @param dto  查询Dto
     * @return Page<PaymentReceiptShouldVo>
     */
    Page<PaymentReceiptShouldVo> findAuditPayByConditionsWithoutPayType(@Param("page") Page<PaymentReceiptShouldVo> page, @Param("dto") PaymentReceiptAuditPayDto dto);

    LinkedList<PaymentReceiptShouldVo> findAuditPaymentByCode(@Param("auditCode") String auditCode, @Param("tenantCode") String tenantCode);


    /**
     * 查询核销付款信息
     *
     * @param tenantCode 租户编码
     * @param codes      核销付款信息id列表
     * @return List<PaymentReceiptShouldVo>
     */
    List<PaymentReceiptShouldVo> findAuditPayByAuditPayCode(@Param("tenantCode") String tenantCode, @Param("codes") List<String> codes);

    /**
     * 获取付款单核销明细报销项目相关映射
     *
     * @param auditPayCode
     * @return
     */
    List<ReimburseFundsReasonMappingVo> findAuditReimburseMapping(@Param("auditPayCode") String auditPayCode, @Param("paymentReceiptCode") String paymentReceiptCode);

    /**
     * 根据核销编码查应付明细
     *
     * @param codeSet
     * @param tenantCode
     * @return
     */
    List<PaymentReceiptShouldVo> findPaymentReceiptShouldByAuditCode(@Param("codeSet") Set<String> codeSet,@Param("tenantCode")  String tenantCode);
}
