package com.biz.crm.tpm.business.payment.receipt.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptFile;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptPay;
import com.biz.crm.tpm.business.payment.receipt.local.mapper.PaymentReceiptFileMapper;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptFileVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/12/6 14:07
 * @description: 付款单-附件信息表(PaymentReceiptFile)表数据库访问层
 */
@Component
public class PaymentReceiptFileRepository extends ServiceImpl<PaymentReceiptFileMapper, PaymentReceiptFile> {

    @Autowired(required = false)
    private PaymentReceiptFileMapper paymentReceiptFileMapper;

    /**
     * 重构批量修改方法
     *
     * @param entitys    实体类集合
     * @param tenantCode 租户编码
     */
    public void updateBatchByIdAndTenantCode(Collection<PaymentReceiptFile> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty(tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank(item.getId())) {
                LambdaUpdateWrapper<PaymentReceiptFile> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(PaymentReceiptFile::getTenantCode, tenantCode);
                lambdaUpdateWrapper.eq(PaymentReceiptFile::getId, item.getId());
                this.baseMapper.update(item, lambdaUpdateWrapper);
            }
        });
    }


    public List<PaymentReceiptFileVo> findByPaymentReceiptCodes(Set<String> paymentReceiptCodes) {
        return paymentReceiptFileMapper.findByPaymentReceiptCodes(paymentReceiptCodes, TenantUtils.getTenantCode());
    }
}
