package com.biz.crm.tpm.business.payment.receipt.local.repository;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptPay;
import com.biz.crm.tpm.business.payment.receipt.local.mapper.PaymentReceiptPayMapper;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.MobilePaymentReceiptApprovedVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptPayVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/12/5 19:42
 * @description: 付款单-支付明细表(PaymentReceiptPay)表数据库访问层
 */
@Component
public class PaymentReceiptPayRepository extends ServiceImpl<PaymentReceiptPayMapper, PaymentReceiptPay> {

    @Autowired(required = false)
    private PaymentReceiptPayMapper paymentReceiptPayMapper;

    /**
     * 重构批量修改方法
     *
     * @param entitys    实体类集合
     * @param tenantCode 租户编码
     */
    public void updateBatchByIdAndTenantCode(Collection<PaymentReceiptPay> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty(tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank(item.getId())) {
                LambdaUpdateWrapper<PaymentReceiptPay> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(PaymentReceiptPay::getTenantCode, tenantCode);
                lambdaUpdateWrapper.eq(PaymentReceiptPay::getId, item.getId());
                this.baseMapper.update(item, lambdaUpdateWrapper);
            }
        });
    }

    public LinkedList<PaymentReceiptPayVo> findPaymentReceiptPayByCode(String code){

        LinkedList<PaymentReceiptPayVo> resultList = new LinkedList<>();

        if (CharSequenceUtil.isEmpty(code)) {
            return null;
        }

        List<PaymentReceiptPay> list = this.baseMapper
                .selectList(Wrappers.lambdaQuery(PaymentReceiptPay.class)
                        .eq(PaymentReceiptPay::getPaymentReceiptCode, code));
        if (CollUtil.isEmpty(list)){
            return null;
        }

        list.forEach(item -> {
            PaymentReceiptPayVo paymentReceiptPayVo = new PaymentReceiptPayVo();
            BeanUtils.copyProperties(item, paymentReceiptPayVo);
            resultList.add(paymentReceiptPayVo);

        });

        return resultList;
    }

    public void deleteByCode(List<String> receiptCodes){

        if (CollUtil.isEmpty(receiptCodes)){
            return;
        }

        this.baseMapper
                .delete(Wrappers.lambdaQuery(PaymentReceiptPay.class)
                        .in(PaymentReceiptPay::getPaymentReceiptCode, receiptCodes));
    }

    public List<PaymentReceiptPayVo> findByPaymentReceiptCodes(Set<String> paymentReceiptCodes) {
        return paymentReceiptPayMapper.findByPaymentReceiptCodes(paymentReceiptCodes, TenantUtils.getTenantCode());
    }

    public List<MobilePaymentReceiptApprovedVo> mobilePaymentReceiptApproved(String processNo) {
        if(StringUtils.isEmpty(processNo)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().mobilePaymentReceiptApproved(processNo);
    }

    public List<MobilePaymentReceiptApprovedVo> findAlreadyMoneyByAuditDetailCodes(List<String> auditItemCodes) {
        if(CollectionUtils.isEmpty(auditItemCodes)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findAlreadyMoneyByAuditDetailCodes(auditItemCodes);
    }
}
