package com.biz.crm.tpm.business.payment.receipt.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptShould;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptShouldAuditRelations;
import com.biz.crm.tpm.business.payment.receipt.local.mapper.PaymentReceiptShouldAuditRelationsMapper;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptShouldDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @ClassName PaymentReceiptShouldAuditRelationsRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/4/25 14:33
 **/
@Component
public class PaymentReceiptShouldAuditRelationsRepository extends ServiceImpl<PaymentReceiptShouldAuditRelationsMapper, PaymentReceiptShouldAuditRelations> {


    public void deleteByShouldCodeList(List<String> shouldCodeList){
        this.lambdaUpdate()
                .in(PaymentReceiptShouldAuditRelations::getShouldCode,shouldCodeList)
                .remove();
    }

    public List<PaymentReceiptShouldAuditRelations> findListByByShouldCodeList(List<String> shouldCodeList){
        if (CollectionUtils.isEmpty(shouldCodeList)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(PaymentReceiptShouldAuditRelations::getShouldCode,shouldCodeList)
                .list();
    }

    public List<PaymentReceiptShouldAuditRelations> findListByByPaymentReceiptCode(String code){
        if (StringUtils.isBlank(code)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(PaymentReceiptShouldAuditRelations::getPaymentReceiptCode,code)
                .eq(PaymentReceiptShouldAuditRelations::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(PaymentReceiptShouldAuditRelations::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    @Transactional
    public void replace(List<PaymentReceiptShouldAuditRelations> dtoList, String paymentReceiptCode) {
        this.lambdaUpdate()
                .eq(PaymentReceiptShouldAuditRelations::getTenantCode, TenantUtils.getTenantCode())
                .eq(PaymentReceiptShouldAuditRelations::getPaymentReceiptCode, paymentReceiptCode)
                .set(PaymentReceiptShouldAuditRelations::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .remove();
        this.saveOrUpdateBatch(dtoList);
    }
}
