package com.biz.crm.tpm.business.payment.receipt.local.service;

import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptFileDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptShouldDto;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/6 18:07
 * @description: 付款单-附件信息表(PaymentReceiptFile)表服务接口
 */
public interface PaymentReceiptFileService {

    /**
     * 批量修改付款单-附件信息
     *
     * @param dtoList            附件信息列表
     * @param paymentReceiptCode 主键结合
     * @param tenantCode         租户编号
     */
    void batchEdit(List<PaymentReceiptFileDto> dtoList, String paymentReceiptCode, String tenantCode);

    void replace(List<PaymentReceiptFileDto> dtoList, String paymentReceiptCode);
}
