package com.biz.crm.tpm.business.payment.receipt.local.service;

import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptPayDto;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/5 19:47
 * @description: 付款单-支付明细表(PaymentReceiptPay)表服务接口
 */
public interface PaymentReceiptPayService {

    /**
     * 批量修改付款单-支付明细
     *
     * @param dtoList            核销明细列表
     * @param paymentReceiptCode 主键结合
     * @param tenantCode         租户编号
     */
    void batchEdit(List<PaymentReceiptPayDto> dtoList, String paymentReceiptCode, String tenantCode);

    void replace(List<PaymentReceiptPayDto> dtoList, String paymentReceiptCode);
}
