package com.biz.crm.tpm.business.payment.receipt.local.service;

import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptProcessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/7 10:20
 * @description: 付款单(PaymentReceipt)表服务接口
 */
public interface PaymentReceiptService {

    /**
     * 付款单流程审批通过
     * @param dto 流程参数
     */
    void processPassSendData(ProcessStatusDto dto);

    /**
     * 异步推送付款单数据
     * @param codeList id集合
     */
    void pushDataAfterProcessPass(List<String> codeList);

    /**
     * 付款单 流程结束
     * @param dto 流程参数
     */
    void updateProcessStatusBatch(ProcessStatusDto dto);

    /**
     * 提交工作流
     *
     * @param processDto 参数
     */
    void submitApproval(PaymentReceiptProcessDto processDto);
}
