package com.biz.crm.tpm.business.payment.receipt.local.service;

import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptPayDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptShouldDto;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/5 19:47
 * @description: 付款单-应付明细表(PaymentReceiptShould)表服务接口
 */
public interface PaymentReceiptShouldService {

    /**
     * 批量修改付款单-应付明细
     *
     * @param dtoList            应付明细列表
     * @param paymentReceiptCode 主键结合
     * @param tenantCode         租户编号
     */
    void batchEdit(List<PaymentReceiptShouldDto> dtoList, String paymentReceiptCode, String tenantCode);

    void replace(List<PaymentReceiptShouldDto> dtoList, String paymentReceiptCode);

}
