//package com.biz.crm.tpm.business.payment.receipt.local.service.internal;
//
//import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
//import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
//import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptAuditItem;
//import com.biz.crm.tpm.business.payment.receipt.local.repository.PaymentReceiptAuditItemRepository;
//import com.biz.crm.tpm.business.payment.receipt.local.service.PaymentReceiptAuditItemService;
//import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptAuditItemDto;
//import com.bizunited.nebula.common.service.NebulaToolkitService;
//import org.apache.commons.lang3.StringUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Transactional;
//import org.springframework.util.CollectionUtils;
//
//import java.util.ArrayList;
//import java.util.Collection;
//import java.util.LinkedHashSet;
//import java.util.List;
//
///**
// * @author: chenlong
// * @date: 2022/12/5 19:48
// * @description: 付款单-核销明细表(PaymentReceiptAuditItem)表服务接口实现类
// */
//@Service("PaymentReceiptAuditItemService")
//public class PaymentReceiptAuditItemServiceImpl implements PaymentReceiptAuditItemService {
//
//    @Autowired(required = false)
//    private PaymentReceiptAuditItemRepository paymentReceiptAuditItemRepository;
//    @Autowired(required = false)
//    private NebulaToolkitService nebulaToolkitService;
//
//    /**
//     * 批量修改付款单-核销明细
//     *
//     * @param dtoList            核销明细列表
//     * @param paymentReceiptCode 主键结合
//     * @param tenantCode         租户编号
//     */
//    @Transactional(rollbackFor = Exception.class)
//    @Override
//    public void batchEdit(List<PaymentReceiptAuditItemDto> dtoList, String paymentReceiptCode, String tenantCode) {
//        if (CollectionUtils.isEmpty(dtoList)) {
//            return;
//        }
//        List<PaymentReceiptAuditItemDto> newAuditDtoList = new ArrayList<>();
//        List<String> idList = new ArrayList<>();
//        for (PaymentReceiptAuditItemDto item : dtoList) {
//            if (StringUtils.isBlank(item.getId())) {
//                item.setPaymentReceiptCode(paymentReceiptCode);
//                item.setTenantCode(tenantCode);
//                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
//                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
//                item.setId(null);
//                newAuditDtoList.add(item);
//            } else {
//                idList.add(item.getId());
//            }
//        }
//        //删除数据
//        if (!CollectionUtils.isEmpty(idList)) {
//            this.paymentReceiptAuditItemRepository.lambdaUpdate()
//                    .eq(PaymentReceiptAuditItem::getTenantCode, tenantCode)
//                    .notIn(PaymentReceiptAuditItem::getId, idList)
//                    .set(PaymentReceiptAuditItem::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
//                    .update();
//        }
//        //修改数据
//        dtoList.removeAll(newAuditDtoList);
//        if (!CollectionUtils.isEmpty(dtoList)) {
//            Collection<PaymentReceiptAuditItem> auditItems = this.nebulaToolkitService.copyCollectionByBlankList(
//                    dtoList, PaymentReceiptAuditItemDto.class, PaymentReceiptAuditItem.class, LinkedHashSet.class, ArrayList.class);
//            this.paymentReceiptAuditItemRepository.updateBatchByIdAndTenantCode(auditItems, tenantCode);
//        }
//        //保存新数据
//        if (!CollectionUtils.isEmpty(newAuditDtoList)) {
//            Collection<PaymentReceiptAuditItem> auditItems = this.nebulaToolkitService.copyCollectionByBlankList(
//                    newAuditDtoList, PaymentReceiptAuditItemDto.class, PaymentReceiptAuditItem.class, LinkedHashSet.class, ArrayList.class);
//            this.paymentReceiptAuditItemRepository.saveBatch(auditItems);
//        }
//    }
//}
